/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class PetrifiedBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.defineId(PetrifiedBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PetrifiedBoatEntity(EntityType<? extends Boat> boat, Level world) {
        super(boat, world);
        this.blocksBuilding = true;
    }

    public PetrifiedBoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)DDEntityTypes.PETRIFIED_BOAT.get()), world);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOAT_TYPE, (Object)BoatType.PETRIFIED.ordinal());
    }

    public Item getDropItem() {
        return (Item)DDItems.PETRIFIED_BOAT.get();
    }

    public void setBoatType(BoatType type) {
        this.entityData.set(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Type", this.getBoatTypeDropItem().getName());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Type", 8)) {
            this.setBoatType(BoatType.byName(tag.getString("Type")));
        }
    }

    public BoatType getBoatTypeDropItem() {
        return BoatType.byId((Integer)this.entityData.get(BOAT_TYPE));
    }

    public static enum BoatType {
        PETRIFIED((Block)DDBlocks.PETRIFIED_PLANKS.get(), "petrified");

        private final String name;
        private final Block planks;

        private BoatType(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int p_38431_) {
            BoatType[] aboat$type = BoatType.values();
            if (p_38431_ < 0 || p_38431_ >= aboat$type.length) {
                p_38431_ = 0;
            }
            return aboat$type[p_38431_];
        }

        public static BoatType byName(String p_38433_) {
            BoatType[] aboat$type = BoatType.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].getName().equals(p_38433_)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }
}

