/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.entities.control.ConfigurableMoveControl;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import com.naterbobber.darkerdepths.init.DDSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GlowshroomMonsterEntity
extends Monster
implements GeoEntity {
    private int damageDelay;
    private Entity attackTarget;
    private static final float REACH = 4.0f;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation ATTACK_SLAM = RawAnimation.begin().then("attack.slam", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation ROAR = RawAnimation.begin().thenLoop("roar");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(GlowshroomMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(GlowshroomMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GlowshroomMonsterEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.xpReward = 20;
        this.moveControl = new ConfigurableMoveControl((Mob)this, 12.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 2.0, 32.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 300, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, false, false, entity -> !(entity instanceof Creeper) && !(entity instanceof GlowshroomMonsterEntity) && !(entity instanceof Bat) && !(entity instanceof VoidSoulEntity)));
    }

    public void aiStep() {
        super.aiStep();
        if (this.getAttackTick() > 0) {
            this.setAttackTick(this.getAttackTick() - 1);
            if (this.getAttackTick() == 0) {
                this.setAttacking(false);
            }
        }
        if (this.damageDelay > 0) {
            --this.damageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.isAlive() || !this.isAlive()) {
            this.attackTarget = null;
            return;
        }
        if (this.damageDelay == 0) {
            if (this.distanceToSqr(this.attackTarget) < 16.0) {
                this.attackTarget.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.5f);
            }
            this.attackTarget = null;
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.5f);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (this.getAttackTick() == 0) {
            this.setAttacking(true);
            this.setAttackTick(50);
            this.damageDelay = 24;
            if (entity instanceof LivingEntity) {
                this.attackTarget = entity;
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    protected AABB getAttackBoundingBox() {
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            return new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        }
        return this.getBoundingBox().inflate(4.0, 0.0, 4.0);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || GlowshroomMonsterEntity.isDarkEnoughToSpawn(level, pos, random)) && GlowshroomMonsterEntity.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        DimensionType dimensiontype = level.dimensionType();
        int i = 5;
        if (level.getBrightness(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.getLevel().isThundering() ? level.getMaxLocalRawBrightness(pos, 10) : level.getMaxLocalRawBrightness(pos);
        return j <= dimensiontype.monsterSpawnLightTest().sample(random);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33034_) {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_HURT.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkingController", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate));
    }

    protected <E extends GlowshroomMonsterEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            return event.setAndContinue(WALK);
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends GlowshroomMonsterEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_SLAM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        SynchedEntityData.Builder define = builder.define(ATTACKING, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
    }

    public int getAttackTick() {
        return (Integer)this.entityData.get(ATTACK_TICK);
    }

    public void setAttackTick(int attackTick) {
        this.entityData.set(ATTACK_TICK, (Object)attackTick);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }
}

