/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.data.loot;

import com.naterbobber.darkerdepths.block.custom.AshBlock;
import com.naterbobber.darkerdepths.block.custom.GlowshroomBlock;
import com.naterbobber.darkerdepths.block.generic.VerticalSlabBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class DDBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> blockIgnores = new HashSet<Block>();

    protected DDBlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.add((Block)DDBlocks.PETRIFIED_WALL_SIGN.get(), (Block block) -> this.createSingleItemTable((ItemLike)DDItems.PETRIFIED_SIGN.get()));
        this.add((Block)DDBlocks.PETRIFIED_WALL_HANGING_SIGN.get(), (Block block) -> this.createSingleItemTable((ItemLike)DDItems.PETRIFIED_HANGING_SIGN.get()));
        this.skipBlock((Block)DDBlocks.MOB_PLACER.get());
        this.add((Block)DDBlocks.MOSSY_GRIMESTONE.get(), (Block block) -> this.createSingleItemTableWithSilkTouch((Block)DDBlocks.MOSSY_GRIMESTONE.get(), (ItemLike)DDBlocks.GRIMESTONE.asItem()));
        this.add((Block)DDBlocks.ARID_DEEPSLATE.get(), (Block block) -> this.createSingleItemTableWithSilkTouch((Block)DDBlocks.ARID_DEEPSLATE.get(), (ItemLike)Blocks.DEEPSLATE.asItem()));
        this.add((Block)DDBlocks.AMBER_CLUSTER.get(), (Block block) -> this.createSingleItemTableWithSilkTouch((Block)DDBlocks.AMBER_CLUSTER.get(), (ItemLike)DDItems.AMBER.get()));
        this.add((Block)DDBlocks.GLIMMERING_VINES.get(), (Block block) -> this.createShearsOrChanceBreakLoot((Block)DDBlocks.GLIMMERING_VINES.get(), (Item)DDItems.GLOW_GRIME.get(), 0.3f));
        this.add((Block)DDBlocks.GLIMMERING_VINE_PLANT.get(), (Block block) -> this.createShearsOrChanceBreakLoot((Block)DDBlocks.GLIMMERING_VINES.get(), (Item)DDItems.GLOW_GRIME.get(), 0.3f));
        this.add((Block)DDBlocks.GLOWSHROOM.get(), (Block block) -> this.createStageBasedLoot((Block)DDBlocks.GLOWSHROOM.get(), GlowshroomBlock.GLOWSHROOM_CLUSTERS));
        this.add((Block)DDBlocks.ASH.get(), (Block block) -> this.createStageBasedLoot((Block)DDBlocks.ASH.get(), AshBlock.LAYERS));
        this.add((Block)DDBlocks.POROUS_PETRIFIED_LOG.get(), (Block block) -> this.createSingleItemTableWithSilkTouch((Block)DDBlocks.POROUS_PETRIFIED_LOG.get(), (ItemLike)DDItems.AMBER.get(), (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)));
        this.add((Block)DDBlocks.PETRIFIED_BOOKSHELF.get(), (Block block) -> this.createSingleItemTableWithSilkTouch((Block)DDBlocks.PETRIFIED_BOOKSHELF.get(), (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
        this.autoGenerateDrops();
    }

    protected Iterable<Block> getKnownBlocks() {
        return DDBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }

    private void skipBlock(Block block) {
        this.blockIgnores.add(block);
    }

    protected void add(Block block, LootTable.Builder builder) {
        super.add(block, builder);
        this.blockIgnores.add(block);
    }

    protected void add(Block block, Function<Block, LootTable.Builder> factory) {
        super.add(block, factory);
        this.blockIgnores.add(block);
    }

    private void autoGenerateDrops() {
        Set<Block> defaultDropBlocks = DDBlocks.BLOCKS.getEntries().stream().map(Holder::value).filter(item -> !this.blockIgnores.contains(item)).collect(Collectors.toSet());
        defaultDropBlocks.forEach(block -> {
            Block block2 = block;
            Objects.requireNonNull(block2);
            Block selector0$temp = block2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SlabBlock.class, VerticalSlabBlock.class, DoorBlock.class, BushBlock.class, FlowerPotBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    SlabBlock b = (SlabBlock)selector0$temp;
                    this.add((Block)b, this.createSlabItemTable((Block)b));
                    break;
                }
                case 1: {
                    VerticalSlabBlock b = (VerticalSlabBlock)selector0$temp;
                    this.add((Block)b, this.createSlabItemTable(b));
                    break;
                }
                case 2: {
                    DoorBlock b = (DoorBlock)selector0$temp;
                    this.add((Block)b, this.createDoorTable((Block)b));
                    break;
                }
                case 3: {
                    BushBlock b = (BushBlock)selector0$temp;
                    this.add((Block)b, this.createGrassDrops((Block)b));
                    break;
                }
                case 4: {
                    FlowerPotBlock b = (FlowerPotBlock)selector0$temp;
                    this.add((Block)b, this.createPotFlowerItemTable((ItemLike)b.getPotted()));
                    break;
                }
                default: {
                    this.dropSelf((Block)block);
                }
            }
        });
    }

    private LootTable.Builder createStageBasedLoot(Block block, IntegerProperty stageProperty) {
        List<Integer> stages = stageProperty.getPossibleValues().stream().filter(item -> item >= 2).toList();
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)block).apply(stages, stage -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)stage.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)stageProperty, stage.intValue())))))));
    }

    private LootTable.Builder createShearsOrChanceBreakLoot(Block block, Item item, float dropChance) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when(HAS_SHEARS))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when(HAS_SHEARS.invert())).when(LootItemRandomChanceCondition.randomChance((float)dropChance))).when(HAS_SHEARS.invert()));
    }
}

