/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.generic;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ConnectedPillarBlock
extends Block {
    public static final EnumProperty<PillarState> PILLAR_STATE = EnumProperty.create((String)"pillar_state", PillarState.class);

    public ConnectedPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PILLAR_STATE, (Comparable)((Object)PillarState.DEFAULT)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getState((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP || pDirection == Direction.DOWN) {
            return this.getState(pLevel, pCurrentPos);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private BlockState getState(LevelAccessor level, BlockPos pos) {
        boolean isPillarBelow;
        Block blockAbove = level.getBlockState(pos.above()).getBlock();
        Block blockBelow = level.getBlockState(pos.below()).getBlock();
        boolean isPillarAbove = blockAbove == this;
        boolean bl = isPillarBelow = blockBelow == this;
        PillarState currentState = isPillarAbove && isPillarBelow ? PillarState.MIDDLE : (isPillarAbove ? PillarState.LOWER : (isPillarBelow ? PillarState.UPPER : PillarState.DEFAULT));
        return (BlockState)this.defaultBlockState().setValue(PILLAR_STATE, (Comparable)((Object)currentState));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{PILLAR_STATE});
    }

    public static enum PillarState implements StringRepresentable
    {
        DEFAULT("default"),
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private PillarState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

