/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.block.blockentities.TombBlockEntity;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TombBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty INHABITED = BooleanProperty.create((String)"inhabited");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape CORNER_PART = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)5.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)3.0, (double)6.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)1.0, (double)10.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0)});
    private static final VoxelShape CORNER_PART_MIRRORED = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)5.0, (double)14.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)3.0, (double)6.0, (double)13.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)4.0, (double)15.0, (double)15.0, (double)16.0)});
    private static final VoxelShape CENTER_PART = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)3.0, (double)6.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0)});
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);

    public TombBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.FRONT_CENTER))).setValue((Property)INHABITED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, WATERLOGGED, INHABITED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Part part = (Part)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue((Property)FACING);
        VoxelShape shape = part.shape();
        return TombBlock.rotateVoxelShape(shape, facing);
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.getValue(PART) == Part.FRONT_CENTER ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(PART, (Comparable)((Object)Part.FRONT_CENTER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(this.getMainBlockPos(pos, state), facing, level);
        for (MultiblockPartData partData : parts.values()) {
            BlockState block = level.getBlockState(partData.pos);
            if (block.is((Block)this) ? block.getValue((Property)FACING) != partData.state.getValue((Property)FACING) || block.getValue(PART) != partData.state.getValue(PART) : !block.canBeReplaced()) {
                return false;
            }
            if (super.canSurvive(partData.state, level, partData.pos)) continue;
            return false;
        }
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide && !isMoving && state.getValue(PART) == Part.FRONT_CENTER) {
            this.placeMultiblockParts(level, pos, state);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && !state.is(newState.getBlock())) {
            TombBlockEntity tombEntity;
            BlockEntity blockEntity;
            if (state.getValue(PART) == Part.FRONT_CENTER && (blockEntity = level.getBlockEntity(pos)) instanceof TombBlockEntity && (tombEntity = (TombBlockEntity)blockEntity).hasStoredItem()) {
                ItemStack storedItem = tombEntity.getStoredItem();
                TombBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)storedItem);
            }
            this.removeMultiblockParts(level, pos, state);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockPos mainPos;
        Part part;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if ((part = (Part)((Object)state.getValue(PART))) != Part.FRONT_CENTER && !level.getBlockState(mainPos = this.getMainBlockPos(currentPos, state)).is((Block)this)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos mainPos;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(mainPos = this.getMainBlockPos(pos, state))) instanceof TombBlockEntity) {
            TombBlockEntity tombEntity = (TombBlockEntity)blockEntity;
            if (player.isSecondaryUseActive() && tombEntity.isOpen() && tombEntity.isInhabited() && tombEntity.hasStoredItem()) {
                tombEntity.toggleTomb();
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isSecondaryUseActive()) {
                return ItemInteractionResult.SUCCESS;
            }
            if (tombEntity.isOpen() && tombEntity.isInhabited()) {
                ItemStack storedItem;
                ItemStack heldItem = player.getItemInHand(hand);
                if (tombEntity.hasStoredItem() && heldItem.isEmpty() && !(storedItem = tombEntity.removeItem(0, 64)).isEmpty()) {
                    if (!player.getInventory().add(storedItem)) {
                        player.drop(storedItem, false);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
            tombEntity.toggleTomb();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return super.getDrops(state, params);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(PART) == Part.FRONT_CENTER ? new TombBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.getValue(PART) == Part.FRONT_CENTER) {
            return TombBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.TOMB.get()), TombBlockEntity::tick);
        }
        return null;
    }

    private static Map<Part, MultiblockPartData> generateMultiblockPartData(BlockPos mainPos, Direction facing, LevelReader level) {
        HashMap<Part, MultiblockPartData> parts = new HashMap<Part, MultiblockPartData>();
        for (Part part : Part.values()) {
            BlockPos partPos = TombBlock.getPartPos(mainPos, part, facing);
            boolean isWaterlogged = level.getFluidState(partPos).getType() == Fluids.WATER;
            BlockState partState = (BlockState)((BlockState)((BlockState)((TombBlock)((Object)DDBlocks.TOMB.get())).defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)part))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
            parts.put(part, new MultiblockPartData(partPos, partState));
        }
        return parts;
    }

    public static Set<StructureTemplate.StructureBlockInfo> generateMultiblockForProcessor(BlockPos mainPos, Direction facing, LevelReader level, BlockPos relativePos) {
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(mainPos, facing, level);
        HashSet<StructureTemplate.StructureBlockInfo> targets = new HashSet<StructureTemplate.StructureBlockInfo>();
        for (MultiblockPartData partData : parts.values()) {
            targets.add(new StructureTemplate.StructureBlockInfo(relativePos.offset((Vec3i)partData.pos.subtract((Vec3i)mainPos)), partData.state, null));
        }
        return targets;
    }

    private void placeMultiblockParts(Level level, BlockPos mainPos, BlockState mainState) {
        Direction facing = (Direction)mainState.getValue((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(mainPos, facing, (LevelReader)level);
        for (MultiblockPartData partData : parts.values()) {
            level.setBlock(partData.pos, partData.state, 3);
        }
    }

    private void removeMultiblockParts(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(this.getMainBlockPos(pos, state), facing, (LevelReader)level);
        for (MultiblockPartData partData : parts.values()) {
            BlockState replace = (Boolean)partData.state.getValue((Property)WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(partData.pos, replace, 3);
            level.addDestroyBlockEffect(partData.pos, partData.state);
        }
    }

    public static BlockPos getPartPos(BlockPos mainPos, Part part, Direction facing) {
        Direction right = facing.getClockWise();
        return mainPos.relative(part.xOffset() > 0 ? right : right.getOpposite(), Math.abs(part.xOffset())).relative(part.zOffset() > 0 ? facing : facing.getOpposite(), Math.abs(part.zOffset()));
    }

    private BlockPos getMainBlockPos(BlockPos partPos, BlockState state) {
        Part part = (Part)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction left = facing.getCounterClockWise();
        return partPos.relative(part.xOffset() > 0 ? left : left.getOpposite(), Math.abs(part.xOffset())).relative(part.zOffset() > 0 ? facing.getOpposite() : facing, Math.abs(part.zOffset()));
    }

    private static VoxelShape rotateVoxelShape(VoxelShape shape, Direction direction) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        ArrayList rotatedBoxes = new ArrayList();
        shape.toAabbs().forEach(aabb -> {
            double minX = aabb.minX;
            double minY = aabb.minY;
            double minZ = aabb.minZ;
            double maxX = aabb.maxX;
            double maxY = aabb.maxY;
            double maxZ = aabb.maxZ;
            VoxelShape rotatedBox = switch (direction) {
                case Direction.SOUTH -> Shapes.box((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                case Direction.WEST -> Shapes.box((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                case Direction.EAST -> Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                default -> shape;
            };
            rotatedBoxes.add(rotatedBox);
        });
        return Shapes.or((VoxelShape)Shapes.empty(), (VoxelShape[])rotatedBoxes.toArray(new VoxelShape[0]));
    }

    public static enum Part implements StringRepresentable
    {
        FRONT_CENTER("front_center", 0, 0, CENTER_PART),
        FRONT_LEFT("front_left", -1, 0, CORNER_PART),
        FRONT_RIGHT("front_right", 1, 0, CORNER_PART_MIRRORED),
        BACK_CENTER("back_center", 0, -1, TombBlock.rotateVoxelShape(CENTER_PART, Direction.SOUTH)),
        BACK_LEFT("back_left", -1, -1, TombBlock.rotateVoxelShape(CORNER_PART_MIRRORED, Direction.SOUTH)),
        BACK_RIGHT("back_right", 1, -1, TombBlock.rotateVoxelShape(CORNER_PART, Direction.SOUTH));

        private final String name;
        private final int xOffset;
        private final int zOffset;
        private final VoxelShape shape;

        private Part(String name, int xOffset, int zOffset, VoxelShape shape) {
            this.name = name;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
            this.shape = shape;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int xOffset() {
            return this.xOffset;
        }

        public int zOffset() {
            return this.zOffset;
        }

        public VoxelShape shape() {
            return this.shape;
        }
    }

    private record MultiblockPartData(BlockPos pos, BlockState state) {
    }
}

