/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.block.blockentities.ParanoiaAltarBlockEntity;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ParanoiaAltarBlock
extends BaseEntityBlock {
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public ParanoiaAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ParanoiaAltarBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0));
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LOCKED});
        builder.add(new Property[]{ENABLED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)DDItems.VOID_SOUL_REQUIEM.get()) && ((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)state.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)), 2);
            level.playSound(null, blockPos, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 2.0f);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, blockPos, player, hand, result);
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)LOCKED)).booleanValue()) {
            return 0.0f;
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        if (((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            return 1200.0f;
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return null;
        }
        return ParanoiaAltarBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.PARANOIA_ALTAR.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }
}

