/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.blockentities;

import com.naterbobber.darkerdepths.block.custom.ParanoiaAltarBlock;
import com.naterbobber.darkerdepths.config.DDConfig;
import com.naterbobber.darkerdepths.entities.BodySnatcherEntity;
import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.RenderUtil;

public class ParanoiaAltarBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int tickCounter = 0;

    public ParanoiaAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntityTypes.PARANOIA_ALTAR.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate));
    }

    private PlayState animationPredicate(AnimationState<ParanoiaAltarBlockEntity> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)ParanoiaAltarBlock.ENABLED)).booleanValue() || level.isClientSide) {
            return;
        }
        if (this.tickCounter++ != 100) {
            return;
        }
        this.tickCounter = 0;
        int radiusHorizontal = (Integer)DDConfig.CONFIG.PARANOIA_ALTAR_RADIUS_HORIZONTAL.get();
        int radiusY = (Integer)DDConfig.CONFIG.PARANOIA_ALTAR_RADIUS_VERTICAL.get();
        AABB finalArea = new AABB(pos).inflate((double)radiusHorizontal, (double)radiusY, (double)radiusHorizontal);
        List players = level.getEntitiesOfClass(Player.class, finalArea);
        int playerMobCap = 6;
        int catacombsMobCap = players.size() * playerMobCap;
        for (Player player : players) {
            if (player.isSpectator() || player.isCreative() && !((Boolean)DDConfig.CONFIG.PARANOIA_ALTAR_EFFECTS_CREATIVE.get()).booleanValue()) continue;
            player.addEffect(new MobEffectInstance(DDMobEffects.PARANOIA, 320, 0, false, false, true));
            if (level.getRandom().nextDouble() > 0.33) continue;
            List catacombsBodySnatcherList = level.getEntitiesOfClass(BodySnatcherEntity.class, finalArea);
            List playerBodySnatcherList = level.getEntitiesOfClass(BodySnatcherEntity.class, player.getBoundingBox().inflate(28.0));
            if (!((Boolean)state.getValue((Property)ParanoiaAltarBlock.LOCKED)).booleanValue() || catacombsBodySnatcherList.size() > catacombsMobCap || playerBodySnatcherList.size() > playerMobCap) continue;
            this.spawnMobInValidPosition(level, player, (Entity)new BodySnatcherEntity((EntityType<? extends VoidSoulMonster>)((EntityType)DDEntityTypes.BODY_SNATCHER.get()), level));
        }
    }

    private void spawnMobInValidPosition(Level level, Player player, Entity entity) {
        BlockPos pos;
        boolean found = false;
        int height = 6;
        int spawnAttempts = 20;
        block0: do {
            if (!level.getBlockState(pos = this.getRandomPositionAroundPlayer(player, 16.0, 24.0, height, level.getRandom())).isAir()) continue;
            for (int i = 0; i < height; ++i) {
                BlockPos nextPos = pos.relative(Direction.Axis.Y, -i);
                if (level.getBlockState(nextPos).isAir()) continue;
                found = true;
                pos = nextPos.above();
                continue block0;
            }
        } while (!found && --spawnAttempts > 0);
        if (found) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    private BlockPos getRandomPositionAroundPlayer(Player player, double minRadius, double maxRadius, int height, RandomSource random) {
        Vec3 position;
        AABB minHorizontalArea = player.getBoundingBox().inflate(minRadius);
        AABB maxHorizontalArea = player.getBoundingBox().inflate(maxRadius);
        AABB verticalArea = player.getBoundingBox().inflate((double)height / 2.0);
        AABB minArea = new AABB(minHorizontalArea.minX, verticalArea.minY, minHorizontalArea.minZ, minHorizontalArea.maxX, verticalArea.maxY, minHorizontalArea.maxZ);
        AABB maxArea = new AABB(maxHorizontalArea.minX, verticalArea.minY, maxHorizontalArea.minZ, maxHorizontalArea.maxX, verticalArea.maxY, maxHorizontalArea.maxZ);
        while (minArea.contains(position = new Vec3(maxArea.minX + random.nextDouble() * maxArea.getXsize(), maxArea.minY + random.nextDouble() * (double)height, maxArea.minZ + random.nextDouble() * maxArea.getZsize()))) {
        }
        return BlockPos.containing((Position)position);
    }
}

