/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.blockentities;

import com.naterbobber.darkerdepths.block.custom.GeyserBlock;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.util.DDTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GeyserBlockEntity
extends BlockEntity {
    public GeyserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntityTypes.GEYSER.get(), pos, state);
    }

    public static void geyserTick(Level world, BlockPos pos, BlockState state, GeyserBlockEntity geyserBlockEntity) {
        if (world.isClientSide()) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)GeyserBlock.FACING);
        double boostSpeed = 0.06;
        double booster = (world.getBlockState(pos.relative(direction.getOpposite())).is(DDTags.Blocks.GEYSER_BOOSTERS) ? boostSpeed * 2.0 : boostSpeed) * (double)direction.getAxisDirection().getStep();
        for (int i = 1; i < 7; ++i) {
            BlockPos relativePosition = pos.relative(direction, i);
            BlockState relativeState = world.getBlockState(relativePosition);
            if (!world.isStateAtPosition(relativePosition, DripstoneUtils::isEmptyOrWaterOrLava)) {
                if (!relativeState.getTags().anyMatch(arg_0 -> DDTags.Blocks.GEYSER_BYPASSES.equals(arg_0)) && (!relativeState.hasProperty((Property)BlockStateProperties.LAYERS) || (Integer)relativeState.getValue((Property)BlockStateProperties.LAYERS) != 1)) break;
            }
            List nearbyEntities = world.getEntitiesOfClass(Entity.class, new AABB(relativePosition));
            for (Entity entity : nearbyEntities) {
                Vec3 motion = entity.getDeltaMovement();
                double xBooster = direction.getAxis() == Direction.Axis.X ? booster : 0.0;
                double yBooster = direction.getAxis() == Direction.Axis.Y ? booster : 0.0;
                double zBooster = direction.getAxis() == Direction.Axis.Z ? booster : 0.0;
                entity.setDeltaMovement(motion.x + xBooster, motion.y + yBooster, motion.z + zBooster);
                entity.fallDistance = 0.0f;
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
    }
}

