/*
 * Decompiled with CFR 0.152.
 */
package com.Imphuls3.createcafe.common.item.foods;

import com.Imphuls3.createcafe.config.CafeConfig;
import com.Imphuls3.createcafe.core.registry.ItemRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IcedCoffeeDrinkMilk
extends Item {
    String type;

    public IcedCoffeeDrinkMilk(Item.Properties properties, String type) {
        super(properties);
        this.type = type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.createcafe.caffeinated").withStyle(ChatFormatting.BLUE));
        if (this.type != "none") {
            tooltip.add((Component)Component.translatable((String)("tooltip.createcafe." + this.type)).withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(stack, level, livingEntity);
        if (!level.isClientSide) {
            livingEntity.removeAllEffects();
        }
        if (((Boolean)CafeConfig.giveEmptyCups.get()).booleanValue()) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)livingEntity;
                CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, stack);
                serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)ItemRegistry.ICED_COFFEE_CUP.get());
            }
            if (livingEntity instanceof Player && !((Player)livingEntity).getAbilities().instabuild) {
                ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.ICED_COFFEE_CUP.get());
                Player player = (Player)livingEntity;
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
            }
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }
}

