/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import ianm1647.expandeddelight.common.entity.CinnamonBoat;
import ianm1647.expandeddelight.common.entity.CinnamonChestBoat;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class CinnamonBoatRenderer
extends BoatRenderer {
    private final Map<CinnamonBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public CinnamonBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context, false);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(CinnamonBoat.Type.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)CinnamonBoatRenderer.getTextureLocation(model, chestBoat)), (Object)this.createBoatModel(context, (CinnamonBoat.Type)((Object)model), chestBoat))));
    }

    private static String getTextureLocation(CinnamonBoat.Type type, boolean chestBoat) {
        return chestBoat ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, CinnamonBoat.Type type, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? CinnamonBoatRenderer.chestBoatTextureLocation(type) : CinnamonBoatRenderer.boatTextureLocation(type);
        ModelPart baked = context.bakeLayer(modellayerlocation);
        return hasChest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }

    private static ModelLayerLocation getModel(String name, String model) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)name), model);
    }

    public static ModelLayerLocation boatTextureLocation(CinnamonBoat.Type type) {
        return CinnamonBoatRenderer.getModel("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation chestBoatTextureLocation(CinnamonBoat.Type type) {
        return CinnamonBoatRenderer.getModel("chest_boat/" + type.getName(), "main");
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof CinnamonBoat) {
            CinnamonBoat cinnamonBoat = (CinnamonBoat)boat;
            return this.boatResources.get((Object)cinnamonBoat.getModel());
        }
        if (boat instanceof CinnamonChestBoat) {
            CinnamonChestBoat cinnamonChestBoat = (CinnamonChestBoat)boat;
            return this.boatResources.get((Object)cinnamonChestBoat.getModel());
        }
        return null;
    }
}

