/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.blockEntity;

import dan200.computercraft.api.peripheral.IPeripheral;
import dev.kleinbox.cccbridge.common.CCCRegistries;
import dev.kleinbox.cccbridge.common.computercraft.peripherals.RedRouterBlockPeripheral;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.PeripheralBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedRouterBlockEntity
extends BlockEntity
implements PeripheralBlockEntity {
    private final HashMap<String, Integer> outputDir = new HashMap();
    private final HashMap<String, Integer> inputDir = new HashMap();
    private boolean blockupdate = false;
    private boolean newInputs = false;
    private RedRouterBlockPeripheral peripheral;
    private Direction facing;

    public RedRouterBlockEntity(BlockPos pos, BlockState state) {
        super(CCCRegistries.REDROUTER_BLOCK_ENTITY.get(), pos, state);
        this.facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.outputDir.put("up", 0);
        this.outputDir.put("down", 0);
        this.outputDir.put("north", 0);
        this.outputDir.put("east", 0);
        this.outputDir.put("south", 0);
        this.outputDir.put("west", 0);
        this.inputDir.put("up", 0);
        this.inputDir.put("down", 0);
        this.inputDir.put("north", 0);
        this.inputDir.put("east", 0);
        this.inputDir.put("south", 0);
        this.inputDir.put("west", 0);
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, BlockEntity be) {
        if (!(be instanceof RedRouterBlockEntity)) {
            return;
        }
        RedRouterBlockEntity redrouter = (RedRouterBlockEntity)be;
        if (state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) != redrouter.facing) {
            redrouter.blockupdate = true;
            redrouter.facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        if (redrouter.blockupdate) {
            world.updateNeighborsAt(blockPos, state.getBlock());
            for (Direction dir : Direction.values()) {
                BlockPos relative = blockPos.relative(dir);
                world.updateNeighborsAt(relative, world.getBlockState(relative).getBlock());
            }
            redrouter.blockupdate = false;
        }
        RedRouterBlockEntity.updateInputs(world, blockPos, redrouter);
        if (redrouter.newInputs && redrouter.peripheral != null) {
            redrouter.peripheral.sendEvent("redstone", new Object[0]);
            redrouter.newInputs = false;
        }
    }

    public static void updateInputs(Level world, BlockPos blockPos, RedRouterBlockEntity redrouter) {
        for (Map.Entry<String, Integer> entry : redrouter.inputDir.entrySet()) {
            String side = entry.getKey();
            Direction dir = Direction.byName((String)side).getOpposite();
            BlockPos offsetPos = blockPos.relative(dir);
            BlockState block = world.getBlockState(offsetPos);
            int power = block.getSignal((BlockGetter)world, offsetPos, dir);
            if (redrouter.inputDir.get(side) != power) {
                redrouter.newInputs = true;
            }
            redrouter.inputDir.put(side, power);
        }
    }

    public Direction getFacing() {
        if (this.facing == null) {
            return Direction.NORTH;
        }
        return this.facing;
    }

    public int getRedstoneInput(Direction side) {
        try {
            return this.inputDir.get(side.getName());
        }
        catch (NullPointerException ignored) {
            return 0;
        }
    }

    public int getPower(Direction side) {
        try {
            return this.outputDir.get(side.getName());
        }
        catch (NullPointerException ignored) {
            return 0;
        }
    }

    public void setPower(String side, int power) {
        this.outputDir.put(side, power);
        this.setChanged();
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        for (Map.Entry<String, Integer> entry : this.outputDir.entrySet()) {
            String side = entry.getKey();
            this.outputDir.put(side, tag.getInt(side));
        }
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        for (Map.Entry<String, Integer> entry : this.outputDir.entrySet()) {
            tag.putInt(entry.getKey(), entry.getValue().intValue());
        }
        super.saveAdditional(tag, registries);
    }

    public void setChanged() {
        super.setChanged();
        this.blockupdate = true;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    public IPeripheral getPeripheral(@NotNull Direction side) {
        if (this.peripheral == null) {
            this.peripheral = new RedRouterBlockPeripheral(this);
        }
        return this.peripheral;
    }
}

