/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.registry;

import com.berksire.furniture.client.entity.CanvasEntity;
import com.berksire.furniture.client.entity.ChairEntity;
import com.berksire.furniture.client.entity.PellsEntity;
import com.berksire.furniture.core.block.entity.CabinetBlockEntity;
import com.berksire.furniture.core.block.entity.ChimneyBlockEntity;
import com.berksire.furniture.core.block.entity.ClockBlockEntity;
import com.berksire.furniture.core.block.entity.CofferBlockEntity;
import com.berksire.furniture.core.block.entity.DisplayBlockEntity;
import com.berksire.furniture.core.block.entity.DresserBlockEntity;
import com.berksire.furniture.core.block.entity.FishTankBlockEntity;
import com.berksire.furniture.core.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.core.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.core.registry.ObjectRegistry;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class EntityTypeRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.ENTITY_TYPE);
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final RegistrySupplier<BlockEntityType<GrandfatherClockBlockEntity>> GRANDFATHER_CLOCK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("grandfather_clock", () -> BlockEntityType.Builder.of(GrandfatherClockBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("oak").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("birch").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("acacia").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("cherry").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("dark_oak").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("jungle").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("mangrove").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("spruce").get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ClockBlockEntity>> CLOCK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("clock", () -> BlockEntityType.Builder.of(ClockBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CLOCKS.get("oak").get(), (Block)ObjectRegistry.CLOCKS.get("birch").get(), (Block)ObjectRegistry.CLOCKS.get("acacia").get(), (Block)ObjectRegistry.CLOCKS.get("cherry").get(), (Block)ObjectRegistry.CLOCKS.get("dark_oak").get(), (Block)ObjectRegistry.CLOCKS.get("jungle").get(), (Block)ObjectRegistry.CLOCKS.get("mangrove").get(), (Block)ObjectRegistry.CLOCKS.get("spruce").get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CofferBlockEntity>> COFFER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("coffer", () -> BlockEntityType.Builder.of(CofferBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COFFER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CABINETS.get("oak").get(), (Block)ObjectRegistry.CABINETS.get("birch").get(), (Block)ObjectRegistry.CABINETS.get("acacia").get(), (Block)ObjectRegistry.CABINETS.get("cherry").get(), (Block)ObjectRegistry.CABINETS.get("dark_oak").get(), (Block)ObjectRegistry.CABINETS.get("jungle").get(), (Block)ObjectRegistry.CABINETS.get("mangrove").get(), (Block)ObjectRegistry.CABINETS.get("spruce").get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<FishTankBlockEntity>> FISH_TANK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("fish_tank", () -> BlockEntityType.Builder.of(FishTankBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COPPER_FISH_TANK.get(), (Block)ObjectRegistry.IRON_FISH_TANK.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<GramophoneBlockEntity>> GRAMOPHONE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("gramophone", () -> BlockEntityType.Builder.of(GramophoneBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GRAMOPHONE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ChimneyBlockEntity>> CHIMNEY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("chimney", () -> BlockEntityType.Builder.of(ChimneyBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COPPER_CHIMNEY.get(), (Block)ObjectRegistry.STONE_BRICKS_CHIMNEY.get(), (Block)ObjectRegistry.BRICK_CHIMNEY.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<DresserBlockEntity>> DRESSER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("dresser", () -> BlockEntityType.Builder.of(DresserBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DRESSER.get("oak").get(), (Block)ObjectRegistry.DRESSER.get("birch").get(), (Block)ObjectRegistry.DRESSER.get("acacia").get(), (Block)ObjectRegistry.DRESSER.get("cherry").get(), (Block)ObjectRegistry.DRESSER.get("dark_oak").get(), (Block)ObjectRegistry.DRESSER.get("jungle").get(), (Block)ObjectRegistry.DRESSER.get("mangrove").get(), (Block)ObjectRegistry.DRESSER.get("spruce").get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<DisplayBlockEntity>> DISPLAY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("display", () -> BlockEntityType.Builder.of(DisplayBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DISPLAY.get()}).build(null));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(FurnitureIdentifier.parseIdentifier("chair").toString()));
    public static final RegistrySupplier<EntityType<CanvasEntity>> CANVAS = EntityTypeRegistry.registerEntity("canvas", () -> EntityType.Builder.of(CanvasEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 2.0f).build(FurnitureIdentifier.parseIdentifier("canvas").toString()));
    public static final RegistrySupplier<EntityType<PellsEntity>> PELLS = EntityTypeRegistry.registerEntity("pells", () -> EntityType.Builder.of(PellsEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 2.0f).build(FurnitureIdentifier.parseIdentifier("pells").toString()));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(FurnitureIdentifier.parseIdentifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(path, type);
    }

    public static void registerAttributes() {
        EntityAttributeRegistry.register(PELLS, PellsEntity::createMobAttributes);
    }

    static {
        ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

