/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block.entity;

import com.berksire.furniture.core.block.CofferBlock;
import com.berksire.furniture.core.registry.EntityTypeRegistry;
import com.berksire.furniture.core.registry.SoundRegistry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CofferBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController = new ChestLidController();

    public CofferBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.COFFER_BLOCK_ENTITY.get(), pos, state);
        this.items = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                CofferBlockEntity.this.playOpenSound(state);
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                CofferBlockEntity.this.playCloseSound(state);
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int before, int after) {
                CofferBlockEntity.this.signalOpenCount(level, pos, state, before, after);
            }

            protected boolean isOwnContainer(Player player) {
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ChestMenu) {
                    ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                    return chestMenu.getContainer() == CofferBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.getLootTable() == null && this.level != null) {
            CompoundTag tag = new CompoundTag();
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)this.level.registryAccess());
            if (tag.contains("Items", 9) && !tag.getList("Items", 10).isEmpty()) {
                ResourceLocation id = Objects.requireNonNull(this.getType().builtInRegistryHolder()).key().location();
                tag.putString("id", id.toString());
                builder.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        CompoundTag tag;
        super.applyImplicitComponents(input);
        CustomData data = (CustomData)input.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null && this.level != null && (tag = data.copyTag()).contains("Items", 9) && !tag.getList("Items", 10).isEmpty() && !this.tryLoadLootTable(tag)) {
            this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            RegistryAccess provider = this.level.registryAccess();
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        }
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, Inventory inv) {
        return new ChestMenu(MenuType.GENERIC_9x4, syncId, inv, (Container)this, 4);
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return 36;
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void playOpenSound(BlockState state) {
        Vec3i off = ((Direction)state.getValue((Property)CofferBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)off.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)off.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)off.getZ() / 2.0;
        assert (this.level != null);
        this.level.playSound(null, x, y, z, (SoundEvent)SoundRegistry.COFFER_OPEN.get(), SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat());
    }

    void playCloseSound(BlockState state) {
        Vec3i off = ((Direction)state.getValue((Property)CofferBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)off.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)off.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)off.getZ() / 2.0;
        assert (this.level != null);
        this.level.playSound(null, x, y, z, (SoundEvent)SoundRegistry.COFFER_CLOSE.get(), SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat());
    }

    public float getOpenNess(float partialTick) {
        return this.chestLidController.getOpenness(partialTick);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, CofferBlockEntity entity) {
        entity.chestLidController.tickLid();
    }

    public boolean triggerEvent(int id, int param) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(param > 0);
            return true;
        }
        return super.triggerEvent(id, param);
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int before, int after) {
        Block block = state.getBlock();
        level.blockEvent(pos, block, 1, after);
    }
}

