/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SteamVentBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty PARTICLES_ENABLED = BooleanProperty.create((String)"particles_enabled");
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>>();
    private static final Map<FurnitureUtil.VerticalConnectingType, VoxelShape> SHAPES = new EnumMap<FurnitureUtil.VerticalConnectingType, VoxelShape>(FurnitureUtil.VerticalConnectingType.class);

    public SteamVentBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, PARTICLES_ENABLED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = this.defaultBlockState();
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        blockState = (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.above()), world.getBlockState(clickedPos.below()))));
        return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(clickedPos).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.getBlockState(pos.above()), world.getBlockState(pos.below()));
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.getBlock() == state.getBlock();
        boolean bl = shapeBelowSame = below.getBlock() == state.getBlock();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.getValue(TYPE));
        return SHAPES.get((Object)type);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            boolean particlesEnabled = (Boolean)blockState.getValue((Property)PARTICLES_ENABLED);
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)PARTICLES_ENABLED, (Comparable)Boolean.valueOf(!particlesEnabled)), 3);
            String messageKey = particlesEnabled ? "tooltip.furniture.vent_disabled" : "tooltip.furniture.vent_enabled";
            player.displayClientMessage((Component)Component.translatable((String)messageKey), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)PARTICLES_ENABLED)).booleanValue() && (state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.NONE || state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM)) {
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY() - 1;
            double z = (double)pos.getZ() + 0.5;
            double vx = 0.0;
            double vy = 0.02 + random.nextDouble() * 0.02;
            double vz = 0.0;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, vx, vy, vz);
        }
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, SteamVentBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, SteamVentBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, SteamVentBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, SteamVentBlock::makeBottomShape);
        for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
            SHAPES.put(entry.getKey(), entry.getValue().get());
        }
    }
}

