/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.FacingBlock;
import com.berksire.furniture.core.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.core.registry.SoundRegistry;
import com.berksire.furniture.core.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.NotNull;

public class GrandfatherClockBlock
extends FacingBlock
implements EntityBlock {
    private final WoodType woodType;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.0, (double)0.25, (double)0.34375, (double)0.125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.125, (double)0.25, (double)0.78125, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.5625, (double)0.25, (double)0.78125, (double)1.3125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)1.3125, (double)0.1875, (double)0.84375, (double)1.375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)1.375, (double)0.25, (double)0.78125, (double)1.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)1.8125, (double)0.25, (double)0.78125, (double)2.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.46875, (double)1.625, (double)0.21875, (double)0.53125, (double)1.6875, (double)0.28125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.65625, (double)0.0, (double)0.25, (double)0.78125, (double)0.125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.65625, (double)0.0, (double)0.625, (double)0.78125, (double)0.125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.0, (double)0.625, (double)0.34375, (double)0.125, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public GrandfatherClockBlock(BlockBehaviour.Properties settings, WoodType woodType) {
        super(settings);
        this.woodType = woodType;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrandfatherClockBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getDayTime() % 24000L == 0L) {
            world.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.GRANDFATHERS_CLOCK_TICKING.get(), SoundSource.BLOCKS, 0.15f, 1.0f);
        }
        world.scheduleTick(pos, (Block)this, 20);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.isClientSide && state.getBlock() != newState.getBlock()) {
            world.getBlockTicks().schedule(new ScheduledTick((Object)state.getBlock(), pos, world.getGameTime(), 0L));
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            long time = level.getDayTime();
            int hours = (int)((time / 1000L + 6L) % 24L);
            int minutes = (int)(60L * (time % 1000L) / 1000L);
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.furniture.clock", (Object[])new Object[]{String.format(Locale.ENGLISH, "%02d:%02d", hours, minutes)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum WoodType {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        MANGROVE,
        CHERRY;

    }
}

