/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.entity.FishTankBlockEntity;
import com.berksire.furniture.core.registry.EntityTypeRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTankBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final EnumProperty<BedPart> PART = EnumProperty.create((String)"part", BedPart.class);
    public static final BooleanProperty HAS_COD = BooleanProperty.create((String)"has_cod");
    public static final BooleanProperty HAS_PUFFERFISH = BooleanProperty.create((String)"has_pufferfish");
    public static final BooleanProperty HAS_SALMON = BooleanProperty.create((String)"has_salmon");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<FishTankBlock> CODEC = FishTankBlock.simpleCodec(FishTankBlock::new);

    public FishTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)HAS_COD, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_SALMON, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, HAS_COD, HAS_PUFFERFISH, HAS_SALMON, FACING});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (state.getValue(PART) == BedPart.FOOT) {
            BlockPos headPos = pos.relative((Direction)state.getValue((Property)FACING));
            world.setBlock(headPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BedPart part = (BedPart)state.getValue(PART);
        Direction facing = (Direction)state.getValue((Property)FACING);
        VoxelShape footShape = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.0, (double)0.9375, (double)0.875, (double)0.9375));
        footShape = Shapes.or((VoxelShape)footShape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        VoxelShape headShape = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.box((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.875, (double)1.0));
        headShape = Shapes.or((VoxelShape)headShape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        VoxelShape selectedShape = part == BedPart.FOOT ? footShape : headShape;
        return FishTankBlock.rotate(selectedShape, Direction.NORTH, facing);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing;
        BlockPos pos;
        BlockPos headPos;
        Level world = context.getLevel();
        if (world.getBlockState(headPos = (pos = context.getClickedPos()).relative(facing = context.getHorizontalDirection().getOpposite())).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)BedPart.FOOT);
        }
        return null;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.05f, 0.95f, false);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FishTankBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return FishTankBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.FISH_TANK_BLOCK_ENTITY.get()), (level1, pos, state, blockEntity) -> blockEntity.tick(level1, pos, state, (FishTankBlockEntity)blockEntity));
    }

    private static VoxelShape rotate(VoxelShape shape, Direction originalDir, Direction newDir) {
        if (originalDir != newDir) {
            VoxelShape[] newShape = new VoxelShape[]{Shapes.empty()};
            shape.forAllBoxes((x, y, z, a, b, c) -> {
                double i = 1.0 - c;
                double j = 1.0 - z;
                newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)Math.min(i, j), (double)y, (double)x, (double)Math.max(i, j), (double)b, (double)a));
            });
            return FishTankBlock.rotate(newShape[0], originalDir.getClockWise(), newDir);
        }
        return shape;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        FishTankBlockEntity blockEntity = (FishTankBlockEntity)world.getBlockEntity(pos);
        if (blockEntity != null) {
            boolean hasModified = false;
            if (itemStack.getItem() == Items.SALMON_BUCKET && !blockEntity.hasSalmon()) {
                blockEntity.setHasSalmon(true);
                hasModified = true;
            } else if (itemStack.getItem() == Items.PUFFERFISH_BUCKET && !blockEntity.hasPufferfish()) {
                blockEntity.setHasPufferfish(true);
                hasModified = true;
            } else if (itemStack.getItem() == Items.COD_BUCKET && !blockEntity.hasCod()) {
                blockEntity.setHasCod(true);
                hasModified = true;
            }
            if (hasModified) {
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)HAS_SALMON, (Comparable)Boolean.valueOf(blockEntity.hasSalmon()))).setValue((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(blockEntity.hasPufferfish()))).setValue((Property)HAS_COD, (Comparable)Boolean.valueOf(blockEntity.hasCod())), 3);
                BlockPos otherPartPos = state.getValue(PART) == BedPart.FOOT ? pos.relative((Direction)state.getValue((Property)FACING)) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
                BlockState otherPartState = world.getBlockState(otherPartPos);
                if (otherPartState.getBlock() == this) {
                    world.setBlock(otherPartPos, (BlockState)((BlockState)((BlockState)otherPartState.setValue((Property)HAS_SALMON, (Comparable)Boolean.valueOf(blockEntity.hasSalmon()))).setValue((Property)HAS_PUFFERFISH, (Comparable)Boolean.valueOf(blockEntity.hasPufferfish()))).setValue((Property)HAS_COD, (Comparable)Boolean.valueOf(blockEntity.hasCod())), 3);
                }
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        FishTankBlockEntity blockEntity;
        super.playerWillDestroy(world, pos, state, player);
        BlockPos otherPartPos = state.getValue(PART) == BedPart.FOOT ? pos.relative((Direction)state.getValue((Property)FACING)) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        BlockState otherPartState = world.getBlockState(otherPartPos);
        if (otherPartState.getBlock() == this && otherPartState.getValue(PART) != state.getValue(PART)) {
            world.destroyBlock(otherPartPos, false);
        }
        if ((blockEntity = (FishTankBlockEntity)world.getBlockEntity(pos)) != null) {
            if (blockEntity.hasCod()) {
                Cod cod = new Cod(EntityType.COD, world);
                cod.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)cod);
            }
            if (blockEntity.hasSalmon()) {
                Salmon salmon = new Salmon(EntityType.SALMON, world);
                salmon.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)salmon);
            }
            if (blockEntity.hasPufferfish()) {
                Pufferfish pufferfish = new Pufferfish(EntityType.PUFFERFISH, world);
                pufferfish.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)pufferfish);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

