/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.entity.ChimneyBlockEntity;
import com.berksire.furniture.core.util.FurnitureUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChimneyBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<FurnitureUtil.SmokeType> SMOKE_TYPE = EnumProperty.create((String)"smoke_type", FurnitureUtil.SmokeType.class);
    public static final BooleanProperty SOOTY = BooleanProperty.create((String)"sooty");
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public ChimneyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SMOKE_TYPE, (Comparable)((Object)FurnitureUtil.SmokeType.NO_SMOKE))).setValue((Property)SOOTY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SMOKE_TYPE, SOOTY});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(SMOKE_TYPE, (Comparable)((Object)FurnitureUtil.SmokeType.SMOKE))).setValue((Property)SOOTY, (Comparable)Boolean.valueOf(false));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (player.getItemInHand(hand).getItem() == Items.BRUSH && ((Boolean)state.getValue((Property)SOOTY)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)SOOTY, (Comparable)Boolean.valueOf(false)), 3);
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, Items.BLACK_DYE.getDefaultInstance()));
                for (int i = 0; i < 5; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.WAX_ON, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown()) {
                FurnitureUtil.SmokeType currentType = (FurnitureUtil.SmokeType)((Object)state.getValue(SMOKE_TYPE));
                FurnitureUtil.SmokeType newType = currentType.getNext();
                world.setBlock(pos, (BlockState)state.setValue(SMOKE_TYPE, (Comparable)((Object)newType)), 3);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.furniture.smoke_type", (Object[])new Object[]{Component.translatable((String)newType.getTranslationKey())}), true);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, blockHitResult);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i;
        FurnitureUtil.SmokeType smokeType = (FurnitureUtil.SmokeType)((Object)state.getValue(SMOKE_TYPE));
        boolean isSooty = (Boolean)state.getValue((Property)SOOTY);
        if (smokeType == FurnitureUtil.SmokeType.HEAVY_SMOKE) {
            for (i = 0; i < 10; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            }
        } else if (smokeType == FurnitureUtil.SmokeType.SMOKE) {
            for (i = 0; i < 5; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            }
        }
        if (isSooty) {
            for (i = 0; i < 5; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            }
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChimneyBlockEntity(pos, state);
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityTicker<E> getTicker(Level level, BlockState state, BlockEntityType<E> blockEntityType) {
        return level.isClientSide ? null : (lvl, pos, blockState, t) -> {
            if (t instanceof ChimneyBlockEntity) {
                ChimneyBlockEntity.tick(lvl, pos, blockState);
            }
        };
    }
}

