/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.registry.ObjectRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BinBlock
extends Block {
    public static final IntegerProperty FILL_STAGE = IntegerProperty.create((String)"fill_stage", (int)0, (int)11);
    private static final VoxelShape SHAPE = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.9375, (double)0.875);
    private static final Random RANDOM = new Random();
    private static final double BAG_DROP_PROBABILITY = 0.25;

    public BinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILL_STAGE});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty()) {
            int currentFillStage = (Integer)state.getValue((Property)FILL_STAGE);
            if (currentFillStage < 11) {
                world.setBlock(pos, (BlockState)state.setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(currentFillStage + 1)), 3);
                world.playSound(null, pos, SoundEvents.COMPOSTER_FILL_SUCCESS, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (currentFillStage >= 9) {
                    this.spawnParticles(world, pos);
                }
            } else {
                world.playSound(null, pos, SoundEvents.COMPOSTER_READY, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (RANDOM.nextDouble() < 0.25) {
                    this.dropItem(world, pos);
                }
                world.setBlock(pos, (BlockState)state.setValue((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void dropItem(Level world, BlockPos pos) {
        ItemStack droppedItem = new ItemStack((ItemLike)ObjectRegistry.TRASH_BAG.get());
        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)droppedItem);
    }

    private void spawnParticles(Level world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = RANDOM.nextDouble() * 0.6 - 0.3;
            double offsetY = RANDOM.nextDouble() * 0.6 - 0.3;
            double offsetZ = RANDOM.nextDouble() * 0.6 - 0.3;
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 1.0 + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0, 1.0, 0.0);
        }
    }
}

