/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.util;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;

public class Util {
    public static final DustParticleOptions AQUATIC_TORCH_PARTICLE = new DustParticleOptions(Vec3.fromRGB24((int)3119001).toVector3f(), 1.0f);

    public static FluidStack getFluidFromNbt(CompoundTag nbt) {
        Tag tag = nbt.get("Fluid");
        if (!(tag instanceof CompoundTag)) {
            return FluidStack.EMPTY;
        }
        CompoundTag tag2 = (CompoundTag)tag;
        ResourceLocation id = ResourceLocation.parse((String)tag2.getString("id"));
        int amount = nbt.get("Fluid") instanceof CompoundTag ? ((CompoundTag)nbt.get("Fluid")).getInt("amount") : 0;
        return new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amount);
    }

    public static CompoundTag getBlockEntityData(ItemStack stack) {
        CustomData component = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (component == null) {
            return new CompoundTag();
        }
        return component.copyTag();
    }

    public static void distributePowerToInventory(Player player, ItemStack startStack, int maxOutput, Predicate<ItemStack> filter) {
        IEnergyStorage startStorage = (IEnergyStorage)startStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (startStorage == null) {
            return;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            IEnergyStorage endStorage;
            ItemStack endStack = player.getInventory().getItem(i);
            if (endStack.isEmpty() || !filter.test(endStack) || (endStorage = (IEnergyStorage)endStack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
            int newAmount = Math.min(startStorage.extractEnergy(maxOutput, true), endStorage.receiveEnergy(maxOutput, true));
            endStorage.receiveEnergy(newAmount, false);
            startStorage.extractEnergy(newAmount, false);
        }
    }

    public static ItemStack singleCopy(ItemStack stack) {
        return stack.transmuteCopy((ItemLike)stack.getItem(), 1);
    }

    public static NumberFormat formatAccordingToLanguage() {
        Locale locale = Locale.forLanguageTag(Minecraft.getInstance().getLanguageManager().getSelected().replace("_", "-"));
        return NumberFormat.getNumberInstance(locale);
    }
}

