/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.recipe.drying;

import me.luligabi.coxinhautilities.common.block.dryingrack.DryingRackInventory;
import me.luligabi.coxinhautilities.common.recipe.RecipeRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class DryingRecipe
implements Recipe<DryingRackInventory.DryingRackInput> {
    private final Ingredient ingredient;
    private final int dryingTime;
    private final ItemStack outputStack;

    public DryingRecipe(Ingredient ingredient, int dryingTime, ItemStack outputStack) {
        this.ingredient = ingredient;
        this.dryingTime = dryingTime;
        this.outputStack = outputStack;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getOutput() {
        return this.outputStack.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.getOutput();
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public ItemStack assemble(DryingRackInventory.DryingRackInput input, HolderLookup.Provider lookup) {
        return this.outputStack.copy();
    }

    public boolean matches(DryingRackInventory.DryingRackInput input, Level world) {
        return this.ingredient.test(input.getItem(0));
    }

    public boolean canCraftInDimensions(int var1, int var2) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.DRYING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.DRYING_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }
}

