/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.woodenhopper;

import com.mojang.serialization.MapCodec;
import java.util.List;
import me.luligabi.coxinhautilities.common.block.BlockEntityRegistry;
import me.luligabi.coxinhautilities.common.block.woodenhopper.WoodenHopperBlockEntity;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class WoodenHopperBlock
extends HopperBlock
implements IWittyComment {
    public WoodenHopperBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<HopperBlock> codec() {
        return WoodenHopperBlock.simpleCodec(WoodenHopperBlock::new);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof WoodenHopperBlockEntity) {
                player.openMenu((MenuProvider)((WoodenHopperBlockEntity)blockEntity));
                player.awardStat(Stats.ITEM_USED.get((Object)this.asItem()));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WoodenHopperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.isClientSide ? WoodenHopperBlock.createTickerHelper(type, BlockEntityRegistry.WOODEN_HOPPER_ENTITY.get(), HopperBlockEntity::pushItemsTick) : null;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.wooden_hopper.1").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.wooden_hopper.2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.wooden_hopper.witty"));
    }
}

