/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.tank;

import me.luligabi.coxinhautilities.common.block.BlockEntityRegistry;
import me.luligabi.coxinhautilities.common.block.ClientSyncedBlockEntity;
import me.luligabi.coxinhautilities.common.block.tank.PortableTankBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class PortableTankBlockEntity
extends ClientSyncedBlockEntity {
    public final FluidTank fluidStorage = new FluidTank(((PortableTankBlock)this.getBlockState().getBlock()).getTankTier().getCapacity()){

        protected void onContentsChanged() {
            PortableTankBlockEntity.this.setChanged();
        }
    };

    public PortableTankBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.PORTABLE_TANK.get(), pos, state);
    }

    public boolean fluidIo(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidStorage);
    }

    public boolean hasWrittenNbt() {
        return this.fluidStorage.getFluid() != FluidStack.EMPTY;
    }

    public void setChanged() {
        super.setChanged();
        if (!this.isClientSide()) {
            this.sync();
        }
    }

    @Override
    public void toTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fluidStorage.writeToNBT(registryLookup, nbt);
    }

    @Override
    public void fromTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fluidStorage.readFromNBT(registryLookup, nbt);
    }

    @Override
    public void toClientTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.toTag(nbt, registryLookup);
    }

    @Override
    public void fromClientTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fromTag(nbt, registryLookup);
    }
}

