/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.sponge;

import java.util.List;
import me.luligabi.coxinhautilities.common.block.BlockRegistry;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;

public class WetLavaSpongeBlock
extends Block
implements IWittyComment {
    private final BlockState hardenedState = BlockRegistry.LAVA_SPONGE.get().defaultBlockState();

    public WetLavaSpongeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WET_SPONGE).mapColor(MapColor.NETHER));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos blockPos;
        Level blockView = ctx.getLevel();
        return WetLavaSpongeBlock.shouldHarden((BlockGetter)blockView, blockPos = ctx.getClickedPos(), blockState = blockView.getBlockState(blockPos)) ? this.hardenedState : super.getStateForPlacement(ctx);
    }

    private static boolean shouldHarden(BlockGetter world, BlockPos pos, BlockState state) {
        return WetLavaSpongeBlock.hardensIn(state) || WetLavaSpongeBlock.hardensOnAnySide(world, pos);
    }

    private static boolean hardensOnAnySide(BlockGetter world, BlockPos pos) {
        boolean shouldHarden = false;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (Direction direction : Direction.values()) {
            BlockState blockState = world.getBlockState((BlockPos)mutable);
            if (direction == Direction.DOWN && !WetLavaSpongeBlock.hardensIn(blockState)) continue;
            mutable.setWithOffset((Vec3i)pos, direction);
            blockState = world.getBlockState((BlockPos)mutable);
            if (!WetLavaSpongeBlock.hardensIn(blockState) || blockState.isFaceSturdy(world, pos, direction.getOpposite())) continue;
            shouldHarden = true;
            break;
        }
        return shouldHarden;
    }

    private static boolean hardensIn(BlockState state) {
        return state.getFluidState().is(FluidTags.WATER);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return WetLavaSpongeBlock.hardensOnAnySide((BlockGetter)world, pos) ? this.hardenedState : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && world.getRandom().nextFloat() < 0.35f) {
            world.setBlockAndUpdate(pos, BlockRegistry.LAVA_SPONGE.get().defaultBlockState());
            world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction != Direction.UP) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            if (!state.canOcclude() || !blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite())) {
                double x = pos.getX();
                double y = pos.getY();
                double z = pos.getZ();
                if (direction == Direction.DOWN) {
                    y -= 0.05;
                    x += random.nextDouble();
                    z += random.nextDouble();
                } else {
                    y += random.nextDouble() * 0.8;
                    if (direction.getAxis() == Direction.Axis.X) {
                        z += random.nextDouble();
                        x = direction == Direction.EAST ? (x += 1.0) : (x += 0.05);
                    } else {
                        x += random.nextDouble();
                        z = direction == Direction.SOUTH ? (z += 1.0) : (z += 0.05);
                    }
                }
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.lava_sponge.witty"));
    }
}

