/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.sink;

import javax.annotation.Nonnull;
import me.luligabi.coxinhautilities.common.block.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class GrannysSinkBlockEntity
extends BlockEntity {
    public final FluidTank fluidStorage = new FluidTank(this, Integer.MAX_VALUE){

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.WATER) {
                return resource.copy();
            }
            return super.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, maxDrain);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }
    };

    public GrannysSinkBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.GRANNYS_SINK.get(), pos, state);
    }

    public boolean fluidIo(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidStorage);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fluidStorage.writeToNBT(registryLookup, nbt);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.fluidStorage.readFromNBT(registryLookup, nbt);
    }
}

