/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.misc;

import java.util.List;
import me.luligabi.coxinhautilities.common.CoxinhaUtilities;
import me.luligabi.coxinhautilities.common.item.ItemRegistry;
import me.luligabi.coxinhautilities.common.misc.TagRegistry;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderOrchidBlock
extends CropBlock
implements IWittyComment {
    private static final VoxelShape[] AGE_TO_SHAPE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.5, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.5, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.5, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.5, (double)11.0)};

    public EnderOrchidBlock() {
        super(BlockBehaviour.Properties.of().noCollission().randomTicks().instabreak().sound(SoundType.CROP));
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        if (CoxinhaUtilities.CONFIG.hasEnderOrchidStrictPlacement) {
            return floor.is(TagRegistry.ENDER_ORCHID_STRICT_PLACEMENT);
        }
        return true;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ItemRegistry.ENDER_ORCHID_SEEDS.get();
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int growthOdds;
        int age = this.getAge(state);
        if (age >= this.getMaxAge()) {
            return;
        }
        int n = growthOdds = world.getBlockState(pos.below()).is(TagRegistry.ENDER_ORCHID_STRICT_PLACEMENT) ? CoxinhaUtilities.CONFIG.enderOrchidRegularGrowthRate : CoxinhaUtilities.CONFIG.enderOrchidSpecialGrowthRate;
        if (random.nextInt(growthOdds) == 0) {
            world.setBlock(pos, this.getStateForAge(age + 1), 2);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        return this.mayPlaceOn(world.getBlockState(blockPos), (BlockGetter)world, blockPos);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
    }

    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int i = Math.max(this.getAge(state) - this.getBonemealAgeIncrease(world), 0);
        world.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(i)), 2);
    }

    protected int getBonemealAgeIncrease(Level world) {
        return Mth.nextInt((RandomSource)world.random, (int)1, (int)2);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) != 0 && (Integer)state.getValue((Property)this.getAgeProperty()) != 7;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)this.getAgeProperty()) != 7) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            int xMultiplier = random.nextInt(2) - 1;
            int zMultiplier = random.nextInt(2) - 1;
            double x = (double)pos.getX() + 0.5 + 0.25 * (double)xMultiplier;
            double y = (float)pos.getY() + random.nextFloat();
            double z = (double)pos.getZ() + 0.5 + 0.25 * (double)zMultiplier;
            double velocityX = random.nextFloat() * (float)random.nextInt(2) * 2.0f - 1.0f;
            double velocityY = ((double)random.nextFloat() - 0.5) * 0.125;
            double velocityZ = random.nextFloat() * (float)random.nextInt(2) * 2.0f - 1.0f;
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AGE_TO_SHAPE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.ender_orchid.1").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.ender_orchid.2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        this.addWittyComment(tooltip);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.ender_orchid.witty.1"), Component.translatable((String)"tooltip.coxinhautilities.ender_orchid.witty.2"));
    }
}

