/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.cardboardbox;

import me.luligabi.coxinhautilities.common.block.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CardboardBoxBlockEntity
extends BlockEntity {
    protected BlockState blockState = Blocks.AIR.defaultBlockState();
    protected ListTag nbtCopy = new ListTag();

    public CardboardBoxBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.CARDBOARD_BOX.get(), pos, state);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt.getCompound("BlockState"));
        this.nbtCopy = nbt.getList("NbtCopy", 10);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        nbt.put("NbtCopy", (Tag)this.nbtCopy);
    }

    public boolean hasWrittenNbt() {
        return !this.blockState.isAir() || !this.nbtCopy.isEmpty();
    }
}

