/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block.cardboardbox;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import me.luligabi.coxinhautilities.common.block.BlockRegistry;
import me.luligabi.coxinhautilities.common.block.cardboardbox.CardboardBoxBlockEntity;
import me.luligabi.coxinhautilities.common.util.IWittyComment;
import me.luligabi.coxinhautilities.common.util.Util;
import me.luligabi.coxinhautilities.mixin.BlockEntityInvoker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlock
extends BaseEntityBlock
implements IWittyComment {
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public CardboardBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CardboardBoxBlock.simpleCodec(CardboardBoxBlock::new);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown() || !player.getOffhandItem().isEmpty()) {
            BlockState blockState;
            Optional<BlockEntity> blockEntity = Optional.ofNullable(world.getBlockEntity(pos));
            BlockState blockState2 = blockState = blockEntity.isPresent() ? ((CardboardBoxBlockEntity)blockEntity.get()).blockState : state;
            if (state.isAir()) {
                return InteractionResult.FAIL;
            }
            if (world.isClientSide()) {
                return InteractionResult.CONSUME;
            }
            ListTag compound = blockEntity.map(entity -> ((CardboardBoxBlockEntity)entity).nbtCopy).orElse(null);
            world.setBlockAndUpdate(pos, this.getPlacementState(blockState, ((Direction)state.getValue((Property)FACING)).getOpposite()));
            blockEntity = Optional.ofNullable(world.getBlockEntity(pos));
            blockEntity.ifPresent(entity -> ((BlockEntityInvoker)entity).invokeLoadAdditional(compound.getCompound(0), (HolderLookup.Provider)world.registryAccess()));
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)BlockRegistry.CARDBOARD_BOX.get()));
            world.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        if (stack.get(DataComponents.BLOCK_ENTITY_DATA) != null) {
            CompoundTag data = Util.getBlockEntityData(stack);
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)data.getCompound("BlockState"));
            if (!blockState.is(Blocks.AIR)) {
                tooltip.add((Component)Component.translatable((String)blockState.getBlock().getDescriptionId()).withStyle(ChatFormatting.GOLD));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.empty").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.cardboard_box.1").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.cardboard_box.2").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.coxinhautilities.cardboard_box.3").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        this.addWittyComment(tooltip);
    }

    private BlockState getPlacementState(BlockState original, Direction cardboardDirection) {
        DirectionProperty property = original.getProperties().stream().filter(c -> c == BlockStateProperties.HORIZONTAL_FACING || c == BlockStateProperties.FACING).findFirst().orElse(null);
        if (property == null) {
            return original;
        }
        return (BlockState)original.trySetValue((Property)property, (Comparable)cardboardDirection);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void saveNbtToStack(BlockEntity blockEntity, ItemStack stack) {
        CardboardBoxBlockEntity cardboardBox;
        if (blockEntity instanceof CardboardBoxBlockEntity && (cardboardBox = (CardboardBoxBlockEntity)blockEntity).hasWrittenNbt()) {
            BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)cardboardBox.getType(), (CompoundTag)cardboardBox.saveWithoutMetadata((HolderLookup.Provider)cardboardBox.getLevel().registryAccess()));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CardboardBoxBlockEntity(pos, state);
    }

    @Override
    public List<Component> wittyComments() {
        return List.of(Component.translatable((String)"tooltip.coxinhautilities.cardboard_box.witty"));
    }
}

