/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.block;

import com.google.common.base.Preconditions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class ClientSyncedBlockEntity
extends BlockEntity {
    private boolean shouldClientRemesh = true;

    public ClientSyncedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void sync(boolean shouldRemesh) {
        Preconditions.checkNotNull((Object)this.level);
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("Cannot call sync() on the logical client! Did you check world.isClient first?");
        }
        ServerLevel serverWorld = (ServerLevel)level;
        this.shouldClientRemesh = shouldRemesh | this.shouldClientRemesh;
        serverWorld.getChunkSource().blockChanged(this.worldPosition);
    }

    public void sync() {
        this.sync(true);
    }

    public abstract void toTag(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void fromTag(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void toClientTag(CompoundTag var1, HolderLookup.Provider var2);

    public abstract void fromClientTag(CompoundTag var1, HolderLookup.Provider var2);

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = super.getUpdateTag(registryLookup);
        this.toClientTag(nbt, registryLookup);
        nbt.putBoolean("#c", this.shouldClientRemesh);
        this.shouldClientRemesh = false;
        return nbt;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.toTag(nbt, registryLookup);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        if (nbt.contains("#c")) {
            this.fromClientTag(nbt, registryLookup);
            if (nbt.getBoolean("#c")) {
                this.remesh();
            }
        } else {
            this.fromTag(nbt, registryLookup);
        }
    }

    public final void remesh() {
        Preconditions.checkNotNull((Object)this.level);
        if (!(this.level instanceof ClientLevel)) {
            throw new IllegalStateException("Cannot call remesh() on the server!");
        }
        this.level.sendBlockUpdated(this.worldPosition, null, null, 0);
    }

    protected final boolean isClientSide() {
        if (this.level == null) {
            throw new IllegalStateException("Cannot determine if the BE is client-side if it has no level yet");
        }
        return this.level.isClientSide();
    }
}

