/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.client.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import me.luligabi.coxinhautilities.client.compat.emi.CoxinhaEmiPlugin;
import me.luligabi.coxinhautilities.common.recipe.drying.DryingRecipe;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class DryingEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<DryingRecipe> entry;
    private final EmiIngredient input;
    private final EmiStack output;

    public DryingEmiRecipe(RecipeHolder<DryingRecipe> entry) {
        this.entry = entry;
        this.input = EmiIngredient.of((Ingredient)((DryingRecipe)entry.value()).getIngredient());
        this.output = EmiStack.of((ItemStack)((DryingRecipe)entry.value()).getOutput());
    }

    public EmiRecipeCategory getCategory() {
        return CoxinhaEmiPlugin.DRYING_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.entry.id();
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, ((DryingRecipe)this.entry.value()).getDryingTime() * 50).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)((DryingRecipe)this.entry.value()).getDryingTime() / 20.0f)}).getVisualOrderText())));
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot((EmiIngredient)this.output, 56, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

