/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.LenientHolderSetCodec;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.mehvahdjukaar.moonlight.api.util.neoforge.UtilsImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Codec<Boolean> MOD_LOADED_CODEC = Codec.STRING.xmap(PlatHelper::isModLoaded, b -> "");
    public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(i -> i.group((App)Vec3.CODEC.fieldOf("from").forGetter(AABB::getMinPosition), (App)Vec3.CODEC.fieldOf("to").forGetter(AABB::getMaxPosition)).apply((Applicative)i, AABB::new));

    @Deprecated(forRemoval=true)
    public static boolean openGuiIfPossible(BlockEntity be, ServerPlayer player, ItemStack stack, Direction hitFace) {
        return Utils.openGuiIfPossible(be, player, stack, hitFace, new Vec3(0.5, 0.5, 0.5));
    }

    public static boolean openGuiIfPossible(BlockEntity be, ServerPlayer player, ItemStack stack, Direction hitFace, Vec3 hitPos) {
        IOneUserInteractable ci;
        BlockPos pos = be.getBlockPos();
        if (!Utils.mayPerformBlockAction((Player)player, pos, stack)) {
            return false;
        }
        if (be instanceof IOneUserInteractable && !(ci = (IOneUserInteractable)be).canBeUsedBy(pos, (Entity)player)) {
            return false;
        }
        if (be instanceof IScreenProvider) {
            IScreenProvider sp = (IScreenProvider)be;
            if (be instanceof IOneUserInteractable) {
                IOneUserInteractable ci2 = (IOneUserInteractable)be;
                ci2.setCurrentUser(player.getUUID());
            }
            sp.sendOpenGuiPacket(player, hitFace, hitPos);
            return false;
        }
        if (be instanceof MenuProvider) {
            MenuProvider mp = (MenuProvider)be;
            if (be instanceof IOneUserInteractable) {
                IOneUserInteractable ci3 = (IOneUserInteractable)be;
                ci3.setCurrentUser(player.getUUID());
            }
            TileOrEntityTarget target = TileOrEntityTarget.of(be);
            PlatHelper.openCustomMenu(player, mp, target::write);
            return true;
        }
        return false;
    }

    public static void spawnItemWithTileData(Player player, RandomizableContainerBlockEntity tile) {
        Level level = player.level();
        if (!level.isClientSide && player.isCreative() && !tile.isEmpty()) {
            BlockPos pos = tile.getBlockPos();
            ItemStack itemstack = Utils.saveTileToItem((BlockEntity)tile);
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        } else {
            tile.unpackLootTable(player);
        }
    }

    public static ItemStack saveTileToItem(BlockEntity tile) {
        Block block = tile.getBlockState().getBlock();
        ItemStack stack = new ItemStack((ItemLike)block.asItem());
        tile.saveToItem(stack, (HolderLookup.Provider)tile.getLevel().registryAccess());
        return stack;
    }

    public static void loadTileFromItem(BlockEntity tile, ItemStack stack) {
        CustomData comp = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (comp != null) {
            tile.loadWithComponents(comp.copyTag(), (HolderLookup.Provider)tile.getLevel().registryAccess());
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.level().isClientSide || bothSides) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)oldItem.copy(), (Player)player, (ItemStack)newItem, (boolean)player.isCreative()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        Utils.swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.level().isClientSide) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)oldItem.copy(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        Utils.swapItem(player, hand, player.getItemInHand(hand), newItem);
    }

    @Deprecated(forRemoval=true)
    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidEmptyHands) {
        Utils.addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(InteractionHand.MAIN_HAND) : InvPlacer.handOrExistingOrAny(InteractionHand.MAIN_HAND));
    }

    public static void addItemOrDrop(Player player, ItemStack stack, InvPlacer placer) {
        Inventory inv = player.getInventory();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(Player player, ItemStack stack) {
        Utils.addItemOrDrop(player, stack, InvPlacer.existingOrAny());
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.nextInt(5) + rand.nextInt(5);
        }
        return xp;
    }

    public static ResourceLocation getId(Holder<?> object) {
        return ((ResourceKey)object.unwrapKey().get()).location();
    }

    public static ResourceLocation getID(@NotNull Block object) {
        return BuiltInRegistries.BLOCK.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull EntityType<?> object) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(object);
    }

    public static ResourceLocation getID(@NotNull Biome object) {
        return Utils.hackyGetRegistry(Registries.BIOME).getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull DamageType type) {
        return Utils.hackyGetRegistry(Registries.DAMAGE_TYPE).getKey((Object)type);
    }

    public static ResourceLocation getID(@NotNull ConfiguredFeature<?, ?> object) {
        return Utils.hackyGetRegistry(Registries.CONFIGURED_FEATURE).getKey(object);
    }

    public static ResourceLocation getID(@NotNull Item object) {
        return BuiltInRegistries.ITEM.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull Fluid object) {
        return BuiltInRegistries.FLUID.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull BlockEntityType<?> object) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(object);
    }

    public static ResourceLocation getID(@NotNull RecipeSerializer<?> object) {
        return BuiltInRegistries.RECIPE_SERIALIZER.getKey(object);
    }

    @Deprecated(forRemoval=true)
    public static ResourceLocation getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().getKey((Object)object);
    }

    @Deprecated(forRemoval=true)
    public static ResourceLocation getID(@NotNull MLMapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().getKey(object);
    }

    public static ResourceLocation getID(@NotNull Potion object) {
        return BuiltInRegistries.POTION.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull MobEffect object) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull CreativeModeTab object) {
        return BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)object);
    }

    public static ResourceLocation getID(@NotNull StatType<?> object) {
        return BuiltInRegistries.STAT_TYPE.getKey(object);
    }

    public static ResourceLocation getID(@NotNull Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, Item.class, EntityType.class, BlockEntityType.class, Biome.class, Fluid.class, RecipeSerializer.class, ConfiguredFeature.class, Potion.class, MobEffect.class, Supplier.class, SoftFluid.class, MLMapDecorationType.class, CreativeModeTab.class, DamageType.class, StatType.class, Holder.class}, (Object)object3, n)) {
            case 0 -> {
                Block b = (Block)object3;
                yield Utils.getID(b);
            }
            case 1 -> {
                Item b = (Item)object3;
                yield Utils.getID(b);
            }
            case 2 -> {
                EntityType b = (EntityType)object3;
                yield Utils.getID(b);
            }
            case 3 -> {
                BlockEntityType b = (BlockEntityType)object3;
                yield Utils.getID(b);
            }
            case 4 -> {
                Biome b = (Biome)object3;
                yield Utils.getID(b);
            }
            case 5 -> {
                Fluid b = (Fluid)object3;
                yield Utils.getID(b);
            }
            case 6 -> {
                RecipeSerializer b = (RecipeSerializer)object3;
                yield Utils.getID(b);
            }
            case 7 -> {
                ConfiguredFeature c = (ConfiguredFeature)object3;
                yield Utils.getID(c);
            }
            case 8 -> {
                Potion c = (Potion)object3;
                yield Utils.getID(c);
            }
            case 9 -> {
                MobEffect c = (MobEffect)object3;
                yield Utils.getID(c);
            }
            case 10 -> {
                Supplier s = (Supplier)object3;
                yield Utils.getID(s.get());
            }
            case 11 -> {
                SoftFluid s = (SoftFluid)object3;
                yield Utils.getID(s);
            }
            case 12 -> {
                MLMapDecorationType s = (MLMapDecorationType)object3;
                yield Utils.getID(s);
            }
            case 13 -> {
                CreativeModeTab t = (CreativeModeTab)object3;
                yield Utils.getID(t);
            }
            case 14 -> {
                DamageType t = (DamageType)object3;
                yield Utils.getID(t);
            }
            case 15 -> {
                StatType t = (StatType)object3;
                yield Utils.getID(t);
            }
            case 16 -> {
                Holder h = (Holder)object3;
                yield Utils.getId(h);
            }
            default -> throw new UnsupportedOperationException("Unsupported class type " + String.valueOf(object.getClass()) + ". Expected a registry entry for a call to Utils.getID()");
        };
    }

    @Deprecated(forRemoval=true)
    public static <T> boolean isTagged(T entry, Registry<T> registry, TagKey<T> tag) {
        return registry.wrapAsHolder(entry).is(tag);
    }

    public static <T> HolderLookup.RegistryLookup<T> hackyFindRegistryOf(Holder<T> holder, ResourceKey<Registry<T>> registryKey) {
        RegistryAccess.Frozen serverRa;
        RegistryAccess clientRa;
        Registry r;
        ClientLevel level;
        if (holder instanceof Holder.Reference) {
            Holder.Reference ref = (Holder.Reference)holder;
            HolderOwner holderOwner = ref.owner;
            if (holderOwner instanceof HolderLookup.RegistryLookup) {
                HolderLookup.RegistryLookup ra = (HolderLookup.RegistryLookup)holderOwner;
                return ra;
            }
        }
        if (PlatHelper.getPhysicalSide().isClient() && (level = Minecraft.getInstance().level) != null && holder.canSerializeIn((r = (clientRa = level.registryAccess()).registryOrThrow(registryKey)).holderOwner())) {
            return clientRa.lookupOrThrow(registryKey);
        }
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (s != null && holder.canSerializeIn((r = (serverRa = s.registryAccess()).registryOrThrow(registryKey)).holderOwner())) {
            return serverRa.lookupOrThrow(registryKey);
        }
        throw new UnsupportedOperationException("Failed to find registry access for " + String.valueOf(holder));
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.isSameThread() || !MoonlightClient.isClientThread())) {
                return s.registryAccess();
            }
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                return level.registryAccess();
            }
            WeakReference<RegistryAccess> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) {
                return (RegistryAccess)hack2.get();
            }
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) {
            return s.registryAccess();
        }
        WeakReference<RegistryAccess> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) {
            return (RegistryAccess)hack2.get();
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> Registry<T> hackyGetRegistry(ResourceKey<Registry<T>> key) {
        return Utils.hackyGetRegistryAccess().registryOrThrow(key);
    }

    public static BlockBehaviour.Properties copyPropertySafe(Block blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)blockBehaviour);
        BlockState state = blockBehaviour.defaultBlockState();
        p.lightLevel(s -> state.getLightEmission());
        p.offsetType(BlockBehaviour.OffsetType.NONE);
        p.isValidSpawn((blockState, blockGetter, pos, entityType) -> blockState.isFaceSturdy(blockGetter, pos, Direction.UP) && blockState.getLightEmission() < 14);
        p.mapColor(blockBehaviour.defaultMapColor());
        p.emissiveRendering((blockState, blockGetter, blockPos) -> false);
        return p;
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name) {
        Utils.awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name, String unlockProp) {
        PlayerAdvancements advancements;
        AdvancementHolder advancement = sp.getServer().getAdvancements().get(name);
        if (advancement != null && !(advancements = sp.getAdvancements()).getOrStartProgress(advancement).isDone()) {
            advancements.award(advancement, unlockProp);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, Consumer<A> tickFunc) {
        return targetType == type ? (level, blockPos, blockState, blockEntity) -> tickFunc.accept(blockEntity) : null;
    }

    public static BlockState readBlockState(CompoundTag compound, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        return NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)compound);
    }

    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.hasProperty(property)) {
            return (BlockState)to.setValue(property, from.getValue(property));
        }
        return to;
    }

    public static boolean mayPerformBlockAction(Player player, BlockPos pos, ItemStack stack) {
        boolean result;
        GameType gameMode;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            gameMode = sp.gameMode.getGameModeForPlayer();
        } else {
            gameMode = Minecraft.getInstance().gameMode.getPlayerMode();
        }
        boolean bl = result = !player.blockActionRestricted(player.level(), pos, gameMode);
        if (!result && gameMode == GameType.ADVENTURE && !stack.isEmpty() && stack.canPlaceOnBlockInAdventureMode(new BlockInWorld((LevelReader)player.level(), pos, false))) {
            return true;
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = Utils.findMethodWithMatchingName(subclass, name);
        Method modMethod = Utils.findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static <A> MapCodec<A> safeOptFieldOf(Codec<A> c, String name, Supplier<A> defaultValue) {
        return Codec.optionalField((String)name, c, (boolean)false).xmap(o -> o.orElse(defaultValue.get()), a -> Objects.equals(a, defaultValue.get()) ? Optional.empty() : Optional.of(a));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        void var1_1;
        return UtilsImpl.optionalMapCodec(keyCodec, var1_1);
    }

    public static <T> Codec<T> optionalRegistryCodec(Registry<T> reg, T defaultValue) {
        return ResourceLocation.CODEC.xmap(rl -> {
            Object value = reg.get(rl);
            return value == null ? defaultValue : value;
        }, arg_0 -> reg.getKey(arg_0));
    }

    public static <T> Codec<List<T>> optionalRegistryListCodec(Registry<T> reg) {
        return ResourceLocation.CODEC.listOf().xmap(l -> l.stream().filter(arg_0 -> ((Registry)reg).containsKey(arg_0)).map(arg_0 -> ((Registry)reg).get(arg_0)).toList(), a -> a.stream().map(arg_0 -> ((Registry)reg).getKey(arg_0)).toList());
    }

    public static <A> Codec<List<A>> lenientListOrSingleCodec(Codec<A> elementCodec) {
        return Codec.either(Utils.lenientListCodec(elementCodec), elementCodec).xmap(either -> (List)either.map(Function.identity(), List::of), Either::left);
    }

    public static <A> LenientListCodec<A> lenientListCodec(Codec<A> elementCodec) {
        return new LenientListCodec<A>(elementCodec);
    }

    public static <E> Codec<HolderSet<E>> lenientHomogeneousList(ResourceKey<? extends Registry<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, RegistryFixedCodec.create(registryKey), false);
    }

    public static <T extends Enum<T>> StreamCodec<FriendlyByteBuf, T> enumStreamCodec(Class<T> enumClass) {
        return new EnumStreamCodec<T>(enumClass);
    }

    public static ResourceLocation idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return ResourceLocation.parse((String)id);
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id);
    }

    @Nullable
    public static <T> T findFirstInRegistry(Registry<T> registry, ResourceLocation ... ids) {
        for (ResourceLocation r : ids) {
            Optional optional = registry.getOptional(r);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    @Nullable
    public static <T> T findFirstInRegistry(Registry<T> registry, Iterable<ResourceLocation> ids) {
        for (ResourceLocation r : ids) {
            Optional optional = registry.getOptional(r);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    public static <T, U, D, R> TriFunction<T, U, D, R> memoize(final TriFunction<T, U, D, R> memoBiFunction) {
        return new TriFunction<T, U, D, R>(){
            private final Map<Triplet<T, U, D>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object, U object2, D object3) {
                return this.cache.computeIfAbsent(Triplet.of(object, object2, object3), pair -> memoBiFunction.apply(pair.left(), pair.middle(), pair.right()));
            }

            public String toString() {
                String var10000 = String.valueOf(memoBiFunction);
                return "memoize/3[function=" + var10000 + ", size=" + this.cache.size() + "]";
            }
        };
    }

    private record EnumStreamCodec<T extends Enum<T>>(Class<T> enumClass) implements StreamCodec<FriendlyByteBuf, T>
    {
        public T decode(FriendlyByteBuf buf) {
            return (T)buf.readEnum(this.enumClass);
        }

        public void encode(FriendlyByteBuf buf, T e) {
            buf.writeEnum(e);
        }
    }
}

