/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.broadcastvoice;

import com.lucasmellof.broadcastvoice.platform.Services;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public class BroadcastVoicePlugin
implements VoicechatPlugin {
    public String getPluginId() {
        return "simple_voice_broadcast";
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onVoicePacket);
    }

    private void onVoicePacket(MicrophonePacketEvent event) {
        if (event.getSenderConnection() == null) {
            return;
        }
        if (event.getSenderConnection().getPlayer() == null) {
            return;
        }
        Object object = event.getSenderConnection().getPlayer().getPlayer();
        if (!(object instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)object;
        Group group = event.getSenderConnection().getGroup();
        if (group == null) {
            return;
        }
        if (!player.hasPermissions(Services.PLATFORM.getPermissionLevel())) {
            return;
        }
        if (!group.getName().strip().equals(Services.PLATFORM.getBroadcastGroupName())) {
            return;
        }
        event.cancel();
        VoicechatServerApi api = event.getVoicechat();
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        PlayerList playerManager = server.getPlayerList();
        StaticSoundPacket packet = (StaticSoundPacket)((MicrophonePacket)event.getPacket()).staticSoundPacketBuilder().build();
        for (ServerPlayer onlinePlayer : playerManager.getPlayers()) {
            VoicechatConnection connection;
            if (onlinePlayer.equals((Object)player) || (connection = api.getConnectionOf(onlinePlayer.getUUID())) == null) continue;
            api.sendStaticSoundPacketTo(connection, packet);
        }
    }
}

