/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.multipart.api.MultipartType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.transmission.TransmissionAPI;
import mrtjp.projectred.transmission.data.TransmissionBlockTagsProvider;
import mrtjp.projectred.transmission.data.TransmissionItemModelProvider;
import mrtjp.projectred.transmission.data.TransmissionItemTagsProvider;
import mrtjp.projectred.transmission.data.TransmissionLanguageProvider;
import mrtjp.projectred.transmission.data.TransmissionRecipeProvider;
import mrtjp.projectred.transmission.init.TransmissionClientInit;
import mrtjp.projectred.transmission.init.TransmissionCreativeModeTabs;
import mrtjp.projectred.transmission.init.TransmissionParts;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_transmission")
public class ProjectRedTransmission {
    public static final String MOD_ID = "projectred_transmission";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_transmission");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_transmission");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_transmission");
    @Nullable
    private static ModContainer container;

    public ProjectRedTransmission(ModContainer container, IEventBus modEventBus) {
        ProjectRedTransmission.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        if (FMLEnvironment.dist.isClient()) {
            TransmissionClientInit.init(modEventBus);
        }
        ITEMS.register(modEventBus);
        PART_TYPES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::onServerStartEvent);
    }

    public static ModContainer getContainer() {
        return Objects.requireNonNull(container);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new TransmissionItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new TransmissionLanguageProvider(output));
        TransmissionBlockTagsProvider blockTagsProvider = new TransmissionBlockTagsProvider(output, provider, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new TransmissionItemTagsProvider(output, provider, blockTagsProvider.contentsGetter(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TransmissionRecipeProvider(provider, output));
    }

    private void onServerStartEvent(ServerAboutToStartEvent event) {
        RedstonePropagator.resetPowerFlags();
    }

    static {
        ProjectRedAPI.transmissionAPI = TransmissionAPI.INSTANCE;
        TransmissionParts.register();
        TransmissionCreativeModeTabs.register();
    }
}

