/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.RavenVariant;
import net.z2six.featheredfriend.entity.raven.modules.RavenSoundEngine;
import net.z2six.featheredfriend.entity.raven.modules.TamedRaven;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import net.z2six.featheredfriend.registry.FFNeoForgeEntities;
import net.z2six.featheredfriend.world.FeatheredFriendSettingsData;
import net.z2six.featheredfriend.world.RavenCourierData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TamedRavenScrollWatcher {
    private static final Logger LOG = LogUtils.getLogger();
    private static final ResourceLocation SEALED_SCROLL_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"scroll_sealed");
    private static final String TAG_SCROLL_SUMMONED = "ff_scroll_summoned";
    private static final Map<UUID, Boolean> LAST_HOLDING_SEALED_SCROLL = new ConcurrentHashMap<UUID, Boolean>();
    private static final long SCROLL_SUMMON_LIFETIME_TICKS = 1200L;
    private static final String NBT_RECALL_ACTIVE = "ScrollRecallActive";
    private static final String NBT_RECALL_JOB_ID = "ScrollRecallJobId";
    private static final String NBT_RECALL_RECIPIENT_UUID = "ScrollRecallRecipientUUID";
    private static final String NBT_RECALL_SEALED_SCROLL = "ScrollRecallSealedScroll";

    private TamedRavenScrollWatcher() {
    }

    public static void register() {
        try {
            NeoForge.EVENT_BUS.addListener(TamedRavenScrollWatcher::onPlayerTick);
            NeoForge.EVENT_BUS.addListener(TamedRavenScrollWatcher::onEntityInteract);
            LOG.info("[TamedRavenScrollWatcher] Registered PlayerTickEvent.Post + EntityInteract listeners");
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] Failed to register event listeners", t);
        }
    }

    private static void onPlayerTick(@NotNull PlayerTickEvent.Post event) {
        try {
            ServerLevel serverLevel;
            Player player;
            block51: {
                block50: {
                    player = event.getEntity();
                    if (player == null) {
                        return;
                    }
                    Level level = player.level();
                    if (!(level instanceof ServerLevel)) break block50;
                    serverLevel = (ServerLevel)level;
                    if (!level.isClientSide()) break block51;
                }
                return;
            }
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            UUID playerId = player.getUUID();
            boolean holdingNow = TamedRavenScrollWatcher.isHoldingSealedScroll(player);
            boolean wasHoldingPrev = LAST_HOLDING_SEALED_SCROLL.getOrDefault(playerId, false);
            boolean wasHolding = player.tickCount == 0 ? false : wasHoldingPrev;
            LAST_HOLDING_SEALED_SCROLL.put(playerId, holdingNow);
            TamedRavenInfo info = TamedRavenScrollWatcher.readTamedRavenInfo(player);
            boolean hasTamedRaven = info != null && info.hasTamedRaven;
            String ravenName = info != null && info.ravenName != null && !info.ravenName.isEmpty() ? info.ravenName : "Raven";
            List<RavenEntity> scrollRavens = TamedRavenScrollWatcher.findScrollSummonedRavensForPlayer(serverLevel, serverPlayer);
            if (!scrollRavens.isEmpty()) {
                long nowGameTime = serverLevel.getGameTime();
                ArrayList<RavenEntity> expired = new ArrayList<RavenEntity>();
                for (RavenEntity ravenEntity : scrollRavens) {
                    try {
                        long despawnAt;
                        CompoundTag ffTag;
                        CompoundTag root = ravenEntity.getPersistentData();
                        if (root == null || (ffTag = root.getCompound("featheredfriend")) == null || ffTag.isEmpty() || (despawnAt = ffTag.getLong("ScrollSummonedDespawnAt")) <= 0L || nowGameTime < despawnAt) continue;
                        expired.add(ravenEntity);
                        LOG.info("[TamedRavenScrollWatcher] Lifetime expired for scroll raven id={} owner='{}' now={} despawnAt={}", new Object[]{ravenEntity.getId(), TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer), nowGameTime, despawnAt});
                    }
                    catch (Throwable t) {
                        LOG.warn("[TamedRavenScrollWatcher] Lifetime check failed safely for raven id={}: {}", (Object)ravenEntity.getId(), (Object)t.toString());
                    }
                }
                if (!expired.isEmpty()) {
                    for (RavenEntity ravenEntity : expired) {
                        try {
                            TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, ravenEntity, "scroll lifetime expired (60s)");
                        }
                        catch (Throwable t) {
                            LOG.error("[TamedRavenScrollWatcher] Failed safely while despawning expired scroll raven id={}: {}", (Object)ravenEntity.getId(), (Object)t.toString());
                        }
                        scrollRavens.remove((Object)ravenEntity);
                    }
                }
            }
            if (!player.isAlive() || player.isRemoved()) {
                if (!scrollRavens.isEmpty()) {
                    for (RavenEntity r : scrollRavens) {
                        TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "player dead/removed");
                    }
                }
                LAST_HOLDING_SEALED_SCROLL.remove(playerId);
                return;
            }
            if (!hasTamedRaven) {
                if (!scrollRavens.isEmpty()) {
                    for (RavenEntity r : scrollRavens) {
                        TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "no stored tamed raven");
                    }
                }
                return;
            }
            RavenCourierData courierData = RavenCourierData.get(serverLevel);
            boolean hasActiveNonFailedAsSender = courierData.hasActiveNonFailedJobsAsSender(playerId);
            boolean hasFailedAsSender = courierData.hasFailedJobsAsSender(playerId);
            if (hasActiveNonFailedAsSender && holdingNow) {
                if (!scrollRavens.isEmpty()) {
                    for (RavenEntity ravenEntity : scrollRavens) {
                        TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, ravenEntity, "courier-dispatch: sender has ACTIVE (non-failed) delivery job");
                    }
                }
                if (serverPlayer.tickCount % 80 == 0) {
                    LOG.info("[TamedRavenScrollWatcher] Player '{}' has ACTIVE courier job(s); disabling scroll-summoned raven while sealed scroll is held.", (Object)TamedRavenScrollWatcher.safePlayerName(player));
                }
                return;
            }
            if (!holdingNow) {
                if (!hasFailedAsSender) {
                    if (!scrollRavens.isEmpty()) {
                        for (RavenEntity ravenEntity : scrollRavens) {
                            TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, ravenEntity, "stopped holding sealed scroll");
                        }
                    }
                } else if (!scrollRavens.isEmpty()) {
                    if (scrollRavens.size() > 1) {
                        RavenEntity primary2 = TamedRavenScrollWatcher.pickClosestRaven(scrollRavens, serverPlayer);
                        for (Object r : scrollRavens) {
                            if (r == primary2) continue;
                            TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "deduplicate scroll ravens (failed-job recall)");
                        }
                        TamedRavenScrollWatcher.ensureRavenName(primary2, ravenName);
                    } else {
                        TamedRavenScrollWatcher.ensureRavenName(scrollRavens.get(0), ravenName);
                    }
                }
                return;
            }
            boolean autoSummonEnabled = true;
            try {
                FeatheredFriendSettingsData featheredFriendSettingsData = FeatheredFriendSettingsData.get(serverLevel);
                autoSummonEnabled = featheredFriendSettingsData.isAutoSummonOnScrollEnabled();
            }
            catch (Throwable throwable) {
                LOG.warn("[TamedRavenScrollWatcher] Failed to read autoSummonOnScroll setting; defaulting to enabled: {}", (Object)throwable.toString());
                autoSummonEnabled = true;
            }
            if (!autoSummonEnabled) {
                if (scrollRavens.isEmpty()) {
                    return;
                }
                if (scrollRavens.size() > 1) {
                    RavenEntity ravenEntity = TamedRavenScrollWatcher.pickClosestRaven(scrollRavens, serverPlayer);
                    for (RavenEntity r : scrollRavens) {
                        if (r == ravenEntity) continue;
                        TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "deduplicate scroll ravens (auto-summon disabled)");
                    }
                    TamedRavenScrollWatcher.ensureRavenName(ravenEntity, ravenName);
                    return;
                }
                TamedRavenScrollWatcher.ensureRavenName(scrollRavens.get(0), ravenName);
                return;
            }
            if (!wasHolding && holdingNow) {
                RavenEntity ravenEntity;
                if (!scrollRavens.isEmpty()) {
                    for (Object r : scrollRavens) {
                        TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "start holding scroll (respawn)");
                    }
                }
                if ((ravenEntity = TamedRavenScrollWatcher.spawnSummonedRaven(serverLevel, serverPlayer, ravenName)) != null) {
                    LOG.info("[TamedRavenScrollWatcher] Start-hold: spawned scroll-raven id={} for player='{}' at {}", new Object[]{ravenEntity.getId(), TamedRavenScrollWatcher.safePlayerName(player), ravenEntity.position()});
                }
                return;
            }
            if (scrollRavens.isEmpty()) {
                RavenEntity ravenEntity = TamedRavenScrollWatcher.spawnSummonedRaven(serverLevel, serverPlayer, ravenName);
                if (ravenEntity != null && serverPlayer.tickCount % 40 == 0) {
                    LOG.info("[TamedRavenScrollWatcher] Continuous-hold: respawned scroll-raven id={} for player='{}' at {}", new Object[]{ravenEntity.getId(), TamedRavenScrollWatcher.safePlayerName(player), ravenEntity.position()});
                }
                return;
            }
            if (scrollRavens.size() > 1) {
                RavenEntity ravenEntity = TamedRavenScrollWatcher.pickClosestRaven(scrollRavens, serverPlayer);
                for (RavenEntity r : scrollRavens) {
                    if (r == ravenEntity) continue;
                    TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "deduplicate scroll ravens");
                }
                TamedRavenScrollWatcher.ensureRavenName(ravenEntity, ravenName);
                return;
            }
            TamedRavenScrollWatcher.ensureRavenName(scrollRavens.get(0), ravenName);
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] onPlayerTick failed safely", t);
        }
    }

    private static List<RavenEntity> findScrollSummonedRavensForPlayer(@NotNull ServerLevel level, @NotNull ServerPlayer owner) {
        ArrayList<RavenEntity> out = new ArrayList<RavenEntity>();
        try {
            UUID ownerId = owner.getUUID();
            BlockPos center = owner.blockPosition();
            double radius = 256.0;
            AABB box = new AABB(center).inflate(radius);
            List candidates = level.getEntitiesOfClass(RavenEntity.class, box, e -> e != null && e.isAlive() && !e.isRemoved());
            for (RavenEntity raven : candidates) {
                UUID ravenOwner;
                boolean tagged;
                try {
                    tagged = raven.getTags().contains(TAG_SCROLL_SUMMONED);
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] findScrollSummoned: tag check failed for id={}: {}", (Object)raven.getId(), (Object)t.toString());
                    continue;
                }
                if (!tagged) continue;
                try {
                    ravenOwner = raven.getOwnerUUID();
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] findScrollSummoned: getOwnerUUID failed for id={}: {}", (Object)raven.getId(), (Object)t.toString());
                    continue;
                }
                if (ravenOwner == null || !ravenOwner.equals(ownerId)) continue;
                out.add(raven);
            }
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] findScrollSummonedRavensForPlayer failed safely", t);
        }
        return out;
    }

    @Nullable
    private static RavenEntity pickClosestRaven(@NotNull List<RavenEntity> ravens, @NotNull ServerPlayer owner) {
        if (ravens.isEmpty()) {
            return null;
        }
        try {
            Vec3 pos = owner.position();
            return ravens.stream().min(Comparator.comparingDouble(r -> r.position().distanceToSqr(pos))).orElse(ravens.get(0));
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] pickClosestRaven failed safely: {}", (Object)t.toString());
            return ravens.get(0);
        }
    }

    @Nullable
    private static RavenEntity spawnSummonedRaven(@NotNull ServerLevel level, @NotNull ServerPlayer owner, @NotNull String ravenName) {
        try {
            RavenEntity raven;
            block16: {
                raven = (RavenEntity)((EntityType)FFNeoForgeEntities.RAVEN.get()).create((Level)level);
                if (raven == null) {
                    LOG.error("[TamedRavenScrollWatcher] spawnSummonedRaven: entity factory returned null");
                    return null;
                }
                Vec3 spawnPos = TamedRavenScrollWatcher.findSafeSpawnAbovePlayer(level, owner, raven);
                if (spawnPos == null) {
                    LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: no valid spawn (or simulated path failed) for player='{}' -> not spawning.", (Object)TamedRavenScrollWatcher.safePlayerName((Player)owner));
                    return null;
                }
                raven.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, owner.getYRot(), 0.0f);
                try {
                    raven.setTame(true, true);
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: setTame(true, true) failed safely: {}", (Object)t.toString());
                }
                try {
                    raven.setOwnerUUID(owner.getUUID());
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: setOwnerUUID failed safely: {}", (Object)t.toString());
                }
                TamedRavenScrollWatcher.ensureRavenName(raven, ravenName);
                try {
                    RavenCourierData courierData = RavenCourierData.get(level);
                    RavenCourierData.DeliveryJob failedJob = courierData.getMostRecentFailedJobForSender(owner.getUUID());
                    if (failedJob == null || failedJob.sealedScrollNbt == null || failedJob.sealedScrollNbt.isEmpty()) break block16;
                    CompoundTag root = raven.getPersistentData();
                    CompoundTag ffTag = root.getCompound("featheredfriend");
                    ffTag.putBoolean(NBT_RECALL_ACTIVE, true);
                    ffTag.putLong(NBT_RECALL_JOB_ID, failedJob.jobId);
                    ffTag.putString(NBT_RECALL_RECIPIENT_UUID, failedJob.recipientUuid.toString());
                    ffTag.put(NBT_RECALL_SEALED_SCROLL, (Tag)failedJob.sealedScrollNbt.copy());
                    root.put("featheredfriend", (Tag)ffTag);
                    try {
                        raven.setRavenVariant(RavenVariant.SCROLL);
                    }
                    catch (Throwable t) {
                        LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: setRavenVariant(SCROLL) failed safely: {}", (Object)t.toString());
                    }
                    LOG.info("[TamedRavenScrollWatcher] spawnSummonedRaven: recall armed for player='{}' jobId={} recipient={} (failed).", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), failedJob.jobId, failedJob.recipientUuid});
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: failed-job recall arming failed safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName((Player)owner), (Object)t.toString());
                }
            }
            try {
                CompoundTag root = raven.getPersistentData();
                CompoundTag ffTag = root.getCompound("featheredfriend");
                long now = level.getGameTime();
                long despawnAt = now + 1200L;
                ffTag.putBoolean("ScrollSummoned", true);
                ffTag.putString("ScrollSummonedOwner", owner.getUUID().toString());
                ffTag.putLong("ScrollSummonedDespawnAt", despawnAt);
                root.put("featheredfriend", (Tag)ffTag);
                LOG.debug("[TamedRavenScrollWatcher] spawnSummonedRaven: lifetime set for id={} now={} despawnAt={}", new Object[]{raven.getId(), now, despawnAt});
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: persistent ScrollSummoned tag failed safely: {}", (Object)t.toString());
            }
            try {
                raven.addTag(TAG_SCROLL_SUMMONED);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] spawnSummonedRaven: addTag({}) failed safely: {}", (Object)TAG_SCROLL_SUMMONED, (Object)t.toString());
            }
            level.addFreshEntity((Entity)raven);
            TamedRavenScrollWatcher.playScrollSummonSpawnFx(level, owner, raven);
            LOG.info("[TamedRavenScrollWatcher] spawnSummonedRaven: spawned id={} name='{}' for player='{}' at {}", new Object[]{raven.getId(), ravenName, TamedRavenScrollWatcher.safePlayerName((Player)owner), raven.position()});
            return raven;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] spawnSummonedRaven failed safely", t);
            return null;
        }
    }

    private static void onEntityInteract(@NotNull PlayerInteractEvent.EntityInteract event) {
        try {
            boolean isOwner;
            ServerLevel serverLevel;
            block14: {
                block13: {
                    Level level = event.getLevel();
                    if (!(level instanceof ServerLevel)) break block13;
                    serverLevel = (ServerLevel)level;
                    if (!level.isClientSide()) break block14;
                }
                return;
            }
            Entity target = event.getTarget();
            if (!(target instanceof RavenEntity)) {
                return;
            }
            RavenEntity raven = (RavenEntity)target;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TamedRavenScrollWatcher.isScrollSummonedRaven(raven)) {
                return;
            }
            try {
                isOwner = raven.isTame() && raven.isOwnedBy((LivingEntity)serverPlayer);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] onEntityInteract: owner check failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
                return;
            }
            if (!isOwner) {
                return;
            }
            InteractionHand hand = event.getHand();
            InteractionResult result = TamedRavenScrollWatcher.handleScrollSummonedRavenInteract(serverLevel, serverPlayer, raven, hand);
            if (result.consumesAction()) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] onEntityInteract failed safely", t);
        }
    }

    @NotNull
    private static InteractionResult handleScrollSummonedRavenInteract(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull RavenEntity raven, @NotNull InteractionHand hand) {
        try {
            RecallPayload recall = TamedRavenScrollWatcher.readRecallPayload(raven);
            if (recall != null) {
                block20: {
                    LOG.info("[TamedRavenScrollWatcher] RecallInteract: player='{}' ravenId={} jobId={} recipient={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)player), raven.getId(), recall.jobId, recall.recipientUuidStr});
                    ItemStack returned = TamedRavenScrollWatcher.buildSealedScrollFromNbt(recall.sealedScrollNbt);
                    if (!returned.isEmpty()) {
                        TamedRavenScrollWatcher.giveOrDropFirstEmpty(player, returned);
                    } else {
                        LOG.warn("[TamedRavenScrollWatcher] RecallInteract: failed to reconstruct sealed scroll item for jobId={} player='{}'", (Object)recall.jobId, (Object)TamedRavenScrollWatcher.safePlayerName((Player)player));
                    }
                    try {
                        RavenCourierData data = RavenCourierData.get(level);
                        UUID recipientUuid = null;
                        try {
                            recipientUuid = UUID.fromString(recall.recipientUuidStr);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (recipientUuid != null) {
                            data.removeJob(recall.jobId, recipientUuid);
                            LOG.info("[TamedRavenScrollWatcher] RecallInteract: removed failed jobId={} recipient={} after return to sender='{}'", new Object[]{recall.jobId, recipientUuid, TamedRavenScrollWatcher.safePlayerName((Player)player)});
                        } else {
                            LOG.warn("[TamedRavenScrollWatcher] RecallInteract: could not parse recipient UUID '{}' for jobId={} (job not removed).", (Object)recall.recipientUuidStr, (Object)recall.jobId);
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("[TamedRavenScrollWatcher] RecallInteract: removeJob failed safely for jobId={} player='{}': {}", new Object[]{recall.jobId, TamedRavenScrollWatcher.safePlayerName((Player)player), t.toString()});
                    }
                    ItemStack inHand = player.getItemInHand(hand);
                    boolean holdingNewSealedScroll = TamedRavenScrollWatcher.isSealedScrollStack(inHand);
                    if (holdingNewSealedScroll) {
                        try {
                            RavenCourierData courierData = RavenCourierData.get(level);
                            RavenCourierData.DeliveryJob newJob = courierData.createJobFromSealedScroll(player, raven, inHand);
                            if (newJob != null) {
                                try {
                                    inHand.shrink(1);
                                }
                                catch (Throwable shrinkErr) {
                                    LOG.warn("[TamedRavenScrollWatcher] RecallInteract: shrink(1) failed safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName((Player)player), (Object)shrinkErr.toString());
                                }
                                LOG.info("[TamedRavenScrollWatcher] RecallInteract: created NEW courier jobId={} after recall return (player='{}')", (Object)newJob.jobId, (Object)TamedRavenScrollWatcher.safePlayerName((Player)player));
                                break block20;
                            }
                            LOG.warn("[TamedRavenScrollWatcher] RecallInteract: failed to create NEW job from held sealed scroll for player='{}'", (Object)TamedRavenScrollWatcher.safePlayerName((Player)player));
                        }
                        catch (Throwable t) {
                            LOG.warn("[TamedRavenScrollWatcher] RecallInteract: createJobFromSealedScroll threw safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName((Player)player), (Object)t.toString());
                        }
                    }
                }
                try {
                    TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(level, player, raven, "recall-complete");
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] RecallInteract: despawn failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
                }
                return InteractionResult.CONSUME;
            }
            ItemStack stack = player.getItemInHand(hand);
            if (!TamedRavenScrollWatcher.isSealedScrollStack(stack)) {
                return InteractionResult.PASS;
            }
            return TamedRavenScrollWatcher.handleSealedScrollInteract(raven, (Player)player, hand);
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] handleScrollSummonedRavenInteract failed safely", t);
            return InteractionResult.PASS;
        }
    }

    @Nullable
    private static RecallPayload readRecallPayload(@NotNull RavenEntity raven) {
        try {
            CompoundTag root = raven.getPersistentData();
            if (root == null) {
                return null;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            if (ffTag == null || ffTag.isEmpty()) {
                return null;
            }
            if (!ffTag.getBoolean(NBT_RECALL_ACTIVE)) {
                return null;
            }
            long jobId = ffTag.getLong(NBT_RECALL_JOB_ID);
            String recipientUuidStr = ffTag.getString(NBT_RECALL_RECIPIENT_UUID);
            CompoundTag sealed = ffTag.getCompound(NBT_RECALL_SEALED_SCROLL);
            if (jobId <= 0L || recipientUuidStr == null || recipientUuidStr.isEmpty() || sealed == null || sealed.isEmpty()) {
                LOG.warn("[TamedRavenScrollWatcher] readRecallPayload: malformed recall payload on raven id={} (jobId={} recipient='{}' sealedEmpty={})", new Object[]{raven.getId(), jobId, recipientUuidStr, sealed == null || sealed.isEmpty()});
                return null;
            }
            return new RecallPayload(jobId, recipientUuidStr, sealed.copy());
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] readRecallPayload failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
            return null;
        }
    }

    private static boolean isSealedScrollStack(@Nullable ItemStack stack) {
        try {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            return key != null && SEALED_SCROLL_ID.equals((Object)key);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @NotNull
    private static ItemStack buildSealedScrollFromNbt(@NotNull CompoundTag sealedScrollNbt) {
        try {
            Item item = (Item)BuiltInRegistries.ITEM.get(SEALED_SCROLL_ID);
            if (item == null) {
                LOG.warn("[TamedRavenScrollWatcher] buildSealedScrollFromNbt: sealed scroll item missing (id={})", (Object)SEALED_SCROLL_ID);
                return ItemStack.EMPTY;
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            CompoundTag customRoot = new CompoundTag();
            customRoot.put("SealedScroll", (Tag)sealedScrollNbt.copy());
            CustomData customData = CustomData.of((CompoundTag)customRoot);
            stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
            return stack;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] buildSealedScrollFromNbt failed safely: {}", (Object)t.toString());
            return ItemStack.EMPTY;
        }
    }

    private static void giveOrDropFirstEmpty(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return;
            }
            int size = player.getInventory().getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack existing = player.getInventory().getItem(i);
                if (existing != null && !existing.isEmpty()) continue;
                player.getInventory().setItem(i, stack);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[TamedRavenScrollWatcher] giveOrDropFirstEmpty: placed returned scroll in slot {} for player='{}'", (Object)i, (Object)TamedRavenScrollWatcher.safePlayerName((Player)player));
                }
                return;
            }
            player.drop(stack, false);
            LOG.info("[TamedRavenScrollWatcher] giveOrDropFirstEmpty: inventory full; dropped returned scroll for player='{}'", (Object)TamedRavenScrollWatcher.safePlayerName((Player)player));
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] giveOrDropFirstEmpty failed safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName((Player)player), (Object)t.toString());
            try {
                player.drop(stack, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void playScrollSummonSpawnFx(@NotNull ServerLevel level, @NotNull ServerPlayer owner, @NotNull RavenEntity raven) {
        try {
            Vec3 ravenPos = raven.position();
            Vec3 playerPos = owner.position();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, ravenPos.x, ravenPos.y + 0.4, ravenPos.z, 40, 0.3, 0.4, 0.3, 0.02);
            level.playSound(null, ravenPos.x, ravenPos.y, ravenPos.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - 0.5f) * 0.2f);
            RavenSoundEngine.playAt((Level)level, "featheredfriend:raven.whistle", SoundSource.NEUTRAL, playerPos, 0.35f, 1.0f);
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] playScrollSummonSpawnFx failed safely: {}", (Object)t.toString());
        }
    }

    private static void despawnOneScrollSummonedRaven(@NotNull ServerLevel level, @NotNull ServerPlayer owner, @NotNull RavenEntity raven, @NotNull String reason) {
        try {
            TamedRaven tamedModule = null;
            try {
                tamedModule = raven.getTamedRavenModule();
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: getTamedRavenModule failed safely: {}", (Object)t.toString());
            }
            String ravenName = "<unnamed>";
            try {
                if (raven.getCustomName() != null) {
                    ravenName = raven.getCustomName().getString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Vec3 fxPos = raven.position().add(0.0, 0.6, 0.0);
                long fxSeed = raven.getUUID().getLeastSignificantBits() ^ (long)raven.tickCount ^ 0x5C829867L;
                Teleportation teleportFx = new Teleportation(raven);
                teleportFx.spawnEnderpopBurst(level, fxPos.x, fxPos.y, fxPos.z, fxSeed, "scroll-despawn: " + reason, raven);
            }
            catch (Throwable fxErr) {
                LOG.warn("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: Teleportation FX failed safely for id={}: {}", (Object)raven.getId(), (Object)fxErr.toString());
            }
            if (tamedModule != null) {
                try {
                    tamedModule.beginDespawnWithFx(level, owner, ravenName);
                    LOG.info("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: triggered despawn FX for id={} name='{}' player='{}' reason={}", new Object[]{raven.getId(), ravenName, TamedRavenScrollWatcher.safePlayerName((Player)owner), reason});
                }
                catch (Throwable t) {
                    LOG.error("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: beginDespawnWithFx failed; discarding raven directly. err={}", (Object)t.toString());
                    raven.discard();
                }
            } else {
                LOG.warn("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: TamedRaven module null; discarding raven without FX. player='{}' id={} reason={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), raven.getId(), reason});
                raven.discard();
            }
            try {
                if (raven.getTags().contains(TAG_SCROLL_SUMMONED)) {
                    raven.removeTag(TAG_SCROLL_SUMMONED);
                }
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: removeTag({}) failed safely for id={}: {}", new Object[]{TAG_SCROLL_SUMMONED, raven.getId(), t.toString()});
            }
            try {
                CompoundTag ffTag;
                CompoundTag root = raven.getPersistentData();
                if (root != null && (ffTag = root.getCompound("featheredfriend")) != null && !ffTag.isEmpty()) {
                    ffTag.remove("ScrollSummoned");
                    ffTag.remove("ScrollSummonedOwner");
                    ffTag.remove("ScrollSummonedDespawnAt");
                    root.put("featheredfriend", (Tag)ffTag);
                }
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven: clearing ScrollSummoned NBT failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            }
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] despawnOneScrollSummonedRaven failed safely", t);
        }
    }

    @Nullable
    private static Vec3 findSafeSpawnAbovePlayer(@NotNull ServerLevel level, @NotNull ServerPlayer owner, @NotNull RavenEntity simRaven) {
        try {
            Vec3 pocket;
            int clampMax;
            BlockPos feet = owner.blockPosition();
            int cx = feet.getX();
            int cz = feet.getZ();
            int feetY = feet.getY();
            int minY = level.getMinBuildHeight();
            int maxY = level.getMaxBuildHeight() - 1;
            int ceilingY = TamedRavenScrollWatcher.scanFirstCeilingYWithin15(level, owner, cx, feetY, cz, minY, maxY);
            if (ceilingY > 0) {
                Vec3 pocketUnderCeiling;
                int baseYUnderCeiling = ceilingY - 3;
                if (baseYUnderCeiling < minY) {
                    baseYUnderCeiling = minY;
                }
                if (baseYUnderCeiling > maxY - 2) {
                    baseYUnderCeiling = maxY - 2;
                }
                if ((pocketUnderCeiling = TamedRavenScrollWatcher.findFirst3x3x2PocketNear(level, owner, cx, baseYUnderCeiling, cz, minY, maxY)) != null) {
                    LOG.info("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: CEILING FOUND at y={} -> pocketUnderCeiling={}", (Object)ceilingY, (Object)pocketUnderCeiling);
                    if (TamedRavenScrollWatcher.canSimulatePathToPlayer(level, owner, pocketUnderCeiling, simRaven)) {
                        return pocketUnderCeiling;
                    }
                    LOG.warn("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: simulated path FAILED -> not spawning. candidate={} player='{}'", (Object)pocketUnderCeiling, (Object)TamedRavenScrollWatcher.safePlayerName((Player)owner));
                    return null;
                }
                LOG.warn("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: CEILING FOUND at y={} but NO pocket-under-ceiling found (baseY={}) player='{}'", new Object[]{ceilingY, baseYUnderCeiling, TamedRavenScrollWatcher.safePlayerName((Player)owner)});
            }
            int preferredOffsetY = 15;
            int baseY = Mth.floor((double)(owner.getY() + 15.0 + 0.5));
            int clampMin = level.getMinBuildHeight() + 2;
            if ((baseY = Mth.clamp((int)baseY, (int)clampMin, (int)(clampMax = level.getMaxBuildHeight() - 2))) < minY) {
                baseY = minY;
            }
            if (baseY > maxY - 2) {
                baseY = maxY - 2;
            }
            if ((pocket = TamedRavenScrollWatcher.findFirst3x3x2PocketNear(level, owner, cx, baseY, cz, minY, maxY)) != null) {
                LOG.info("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: fallback +15 pocket={}", (Object)pocket);
                if (TamedRavenScrollWatcher.canSimulatePathToPlayer(level, owner, pocket, simRaven)) {
                    return pocket;
                }
                LOG.warn("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: simulated path FAILED -> not spawning. candidate={} player='{}'", (Object)pocket, (Object)TamedRavenScrollWatcher.safePlayerName((Player)owner));
                return null;
            }
            LOG.warn("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer: no pocket found (ceilingY={}, baseY={}) for player='{}' feet={}", new Object[]{ceilingY, baseY, TamedRavenScrollWatcher.safePlayerName((Player)owner), feet});
            return null;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] findSafeSpawnAbovePlayer failed safely", t);
            return null;
        }
    }

    private static int scanFirstCeilingYWithin15(@NotNull ServerLevel level, @NotNull ServerPlayer owner, int cx, int feetY, int cz, int minY, int maxY) {
        try {
            int y;
            for (int dy = 1; dy <= 15 && (y = feetY + dy) >= minY && y <= maxY; ++dy) {
                boolean isAir;
                BlockState st;
                BlockPos probe = new BlockPos(cx, y, cz);
                try {
                    st = level.getBlockState(probe);
                }
                catch (Throwable t) {
                    LOG.warn("[TamedRavenScrollWatcher] scanFirstCeilingYWithin15: getBlockState failed at {} for player='{}': {}", new Object[]{probe, TamedRavenScrollWatcher.safePlayerName((Player)owner), t.toString()});
                    continue;
                }
                try {
                    isAir = st.isAir();
                }
                catch (Throwable t) {
                    isAir = false;
                    LOG.warn("[TamedRavenScrollWatcher] scanFirstCeilingYWithin15: st.isAir() threw at {} st={} player='{}': {}", new Object[]{probe, st, TamedRavenScrollWatcher.safePlayerName((Player)owner), t.toString()});
                }
                if (isAir) continue;
                if (LOG.isInfoEnabled()) {
                    String key = "unknown";
                    try {
                        key = String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)st.getBlock()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LOG.info("[TamedRavenScrollWatcher] scanFirstCeilingYWithin15: HIT dy={} y={} block={} feetY={} player='{}'", new Object[]{dy, y, key, feetY, TamedRavenScrollWatcher.safePlayerName((Player)owner)});
                }
                return y;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("[TamedRavenScrollWatcher] scanFirstCeilingYWithin15: NONE within 15 (feetY={}) player='{}'", (Object)feetY, (Object)TamedRavenScrollWatcher.safePlayerName((Player)owner));
            }
            return -1;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] scanFirstCeilingYWithin15 failed safely", t);
            return -1;
        }
    }

    @Nullable
    private static Vec3 findFirst3x3x2PocketNear(@NotNull ServerLevel level, @NotNull ServerPlayer owner, int cx, int baseY, int cz, int minY, int maxY) {
        try {
            if (baseY < minY || baseY > maxY - 2) {
                LOG.warn("[TamedRavenScrollWatcher] findFirst3x3x2PocketNear: baseY out of bounds for 3-high pocket. baseY={} minY={} maxY={} player='{}'", new Object[]{baseY, minY, maxY, TamedRavenScrollWatcher.safePlayerName((Player)owner)});
                return null;
            }
            int maxR = 4;
            for (int r = 0; r <= 4; ++r) {
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        int tz;
                        int tx;
                        if (r > 0 && Math.abs(dx) != r && Math.abs(dz) != r || !TamedRavenScrollWatcher.is3x3x3Air(level, tx = cx + dx, baseY, tz = cz + dz)) continue;
                        Vec3 pocket = new Vec3((double)tx + 0.5, (double)baseY + 0.1, (double)tz + 0.5);
                        LOG.info("[TamedRavenScrollWatcher] findFirst3x3x2PocketNear: FOUND pocket={} baseY={} off=({}, {}) player='{}'", new Object[]{pocket, baseY, dx, dz, TamedRavenScrollWatcher.safePlayerName((Player)owner)});
                        return pocket;
                    }
                }
            }
            LOG.info("[TamedRavenScrollWatcher] findFirst3x3x2PocketNear: NONE baseY={} center=({}, {}) radius={} player='{}'", new Object[]{baseY, cx, cz, 4, TamedRavenScrollWatcher.safePlayerName((Player)owner)});
            return null;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] findFirst3x3x2PocketNear failed safely", t);
            return null;
        }
    }

    private static boolean is3x3x2Air(@NotNull ServerLevel level, int cx, int cy, int cz) {
        try {
            for (int dy = 0; dy <= 1; ++dy) {
                int y = cy + dy;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos pos = new BlockPos(cx + dx, y, cz + dz);
                        if (level.isEmptyBlock(pos)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] is3x3x2Air failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    private static boolean is3x3x3Air(@NotNull ServerLevel level, int cx, int cy, int cz) {
        try {
            for (int dy = 0; dy <= 2; ++dy) {
                int y = cy + dy;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos pos = new BlockPos(cx + dx, y, cz + dz);
                        if (level.isEmptyBlock(pos)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] is3x3x3Air failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    private static boolean canSimulatePathToPlayer(@NotNull ServerLevel level, @NotNull ServerPlayer owner, @NotNull Vec3 spawnPos, @NotNull RavenEntity simRaven) {
        try {
            boolean ok;
            long seed;
            try {
                simRaven.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, owner.getYRot(), 0.0f);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] canSimulatePathToPlayer: moveTo failed safely. player='{}' spawnPos={} err={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), spawnPos, t.toString()});
                return false;
            }
            Vec3 goal = owner.position();
            try {
                seed = owner.getUUID().getMostSignificantBits() ^ owner.getUUID().getLeastSignificantBits() ^ level.getGameTime() ^ 0x6D2B79F5A5A5A5A5L;
            }
            catch (Throwable t) {
                seed = level.getGameTime() ^ 0x6D2B79F5A5A5A5A5L;
            }
            try {
                ok = simRaven.simulateAStarPathTo(goal, 120, seed, "scroll-summon simulated path");
            }
            catch (Throwable t) {
                ok = false;
                LOG.warn("[TamedRavenScrollWatcher] canSimulatePathToPlayer: simulateAStarPathTo threw. player='{}' spawnPos={} goal={} err={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), spawnPos, goal, t.toString()});
            }
            if (ok) {
                LOG.info("[TamedRavenScrollWatcher] canSimulatePathToPlayer: A* simulation OK player='{}' spawnPos={} goal={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), spawnPos, goal});
            } else {
                LOG.info("[TamedRavenScrollWatcher] canSimulatePathToPlayer: A* simulation FAIL player='{}' spawnPos={} goal={}", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)owner), spawnPos, goal});
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] canSimulatePathToPlayer failed safely", t);
            return false;
        }
    }

    @Nullable
    private static TamedRavenInfo readTamedRavenInfo(@NotNull Player player) {
        try {
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                return null;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            if (ffTag == null || ffTag.isEmpty()) {
                return null;
            }
            if (!ffTag.contains("TamedRaven", 10)) {
                return null;
            }
            CompoundTag ravenTag = ffTag.getCompound("TamedRaven");
            if (ravenTag == null || ravenTag.isEmpty()) {
                return null;
            }
            boolean has = ravenTag.getBoolean("HasTamedRaven");
            String name = ravenTag.getString("RavenName");
            return new TamedRavenInfo(has, name);
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] readTamedRavenInfo failed safely: {}", (Object)t.toString());
            return null;
        }
    }

    public static InteractionResult handleSealedScrollInteract(@NotNull RavenEntity raven, @NotNull Player player, @NotNull InteractionHand hand) {
        try {
            Level level = raven.level();
            if (level == null) {
                return InteractionResult.PASS;
            }
            boolean clientSide = level.isClientSide;
            ItemStack stack = player.getItemInHand(hand);
            if (stack == null || stack.isEmpty()) {
                return InteractionResult.PASS;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (key == null || !SEALED_SCROLL_ID.equals((Object)key)) {
                return InteractionResult.PASS;
            }
            boolean isOwner = false;
            try {
                isOwner = raven.isTame() && raven.isOwnedBy((LivingEntity)player);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: owner check failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
            }
            if (!isOwner) {
                LOG.info("[TamedRavenScrollWatcher] handleSealedScrollInteract: player='{}' used scroll on raven id={} but is not owner (ignoring).", (Object)TamedRavenScrollWatcher.safePlayerName(player), (Object)raven.getId());
                return InteractionResult.PASS;
            }
            if (clientSide) {
                LOG.info("[TamedRavenScrollWatcher] handleSealedScrollInteract: CLIENT accepted sealed scroll use (player='{}', raven id={}, hand={}, stack={})", new Object[]{TamedRavenScrollWatcher.safePlayerName(player), raven.getId(), hand, stack});
                return InteractionResult.sidedSuccess((boolean)true);
            }
            if (!(player instanceof ServerPlayer)) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: player is not ServerPlayer on server side");
                return InteractionResult.PASS;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(level instanceof ServerLevel)) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: level is not ServerLevel on server side");
                return InteractionResult.PASS;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            RavenCourierData courierData = RavenCourierData.get(serverLevel);
            RavenCourierData.DeliveryJob job = courierData.createJobFromSealedScroll(serverPlayer, raven, stack);
            if (job == null) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: FAILED to create courier job (player='{}', raven id={}, hand={}, stack={})", new Object[]{TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer), raven.getId(), hand, stack});
                return InteractionResult.PASS;
            }
            LOG.info("[TamedRavenScrollWatcher] handleSealedScrollInteract: SERVER created courier jobId={} from sealed scroll (sender='{}', recipient='{}', ravenId={})", new Object[]{job.jobId, job.senderName, job.recipientName, raven.getId()});
            try {
                raven.setRavenVariant(RavenVariant.SCROLL);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: setRavenVariant(SCROLL) failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            }
            try {
                ItemStack inHand = serverPlayer.getItemInHand(hand);
                if (!inHand.isEmpty() && inHand.getItem() == stack.getItem()) {
                    inHand.shrink(1);
                } else {
                    LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: item in hand changed before consumption for player='{}'", (Object)TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer));
                }
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] handleSealedScrollInteract: shrink(1) failed safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer), (Object)t.toString());
            }
            try {
                TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, raven, "courier-dispatch: sealed scroll accepted");
            }
            catch (Throwable t) {
                LOG.error("[TamedRavenScrollWatcher] handleSealedScrollInteract: despawnOneScrollSummonedRaven failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            }
            return InteractionResult.CONSUME;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] handleSealedScrollInteract failed safely", t);
            return InteractionResult.PASS;
        }
    }

    public static void handleWhistleSummonRequest(@NotNull ServerPlayer serverPlayer) {
        try {
            String ravenName;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            UUID playerId = serverPlayer.getUUID();
            boolean holding = TamedRavenScrollWatcher.isHoldingSealedScroll((Player)serverPlayer);
            RavenCourierData courierData = RavenCourierData.get(serverLevel);
            boolean hasFailedAsSender = courierData.hasFailedJobsAsSender(playerId);
            if (!holding && !hasFailedAsSender) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"[FeatheredFriend] You must hold a sealed scroll to whistle for your raven."));
                LOG.info("[TamedRavenScrollWatcher] Whistle request denied: player='{}' not holding sealed scroll and no failed jobs.", (Object)TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer));
                return;
            }
            TamedRavenInfo info = TamedRavenScrollWatcher.readTamedRavenInfo((Player)serverPlayer);
            boolean hasTamedRaven = info != null && info.hasTamedRaven;
            String string = ravenName = info != null && info.ravenName != null && !info.ravenName.isEmpty() ? info.ravenName : "Raven";
            if (!hasTamedRaven) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"[FeatheredFriend] You do not have a tamed raven bound to you."));
                LOG.info("[TamedRavenScrollWatcher] Whistle request denied: player='{}' has no stored tamed raven.", (Object)TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer));
                return;
            }
            List<RavenEntity> scrollRavens = TamedRavenScrollWatcher.findScrollSummonedRavensForPlayer(serverLevel, serverPlayer);
            if (scrollRavens.isEmpty()) {
                RavenEntity spawned = TamedRavenScrollWatcher.spawnSummonedRaven(serverLevel, serverPlayer, ravenName);
                if (spawned != null) {
                    LOG.info("[TamedRavenScrollWatcher] Whistle: spawned scroll-raven id={} for player='{}' at {}", new Object[]{spawned.getId(), TamedRavenScrollWatcher.safePlayerName((Player)serverPlayer), spawned.position()});
                }
                return;
            }
            if (scrollRavens.size() > 1) {
                RavenEntity primary = TamedRavenScrollWatcher.pickClosestRaven(scrollRavens, serverPlayer);
                for (RavenEntity r : scrollRavens) {
                    if (r == primary) continue;
                    TamedRavenScrollWatcher.despawnOneScrollSummonedRaven(serverLevel, serverPlayer, r, "deduplicate scroll ravens (whistle)");
                }
                TamedRavenScrollWatcher.ensureRavenName(primary, ravenName);
                return;
            }
            TamedRavenScrollWatcher.ensureRavenName(scrollRavens.get(0), ravenName);
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenScrollWatcher] handleWhistleSummonRequest failed safely", t);
        }
    }

    private static void ensureRavenName(@NotNull RavenEntity raven, @NotNull String ravenName) {
        try {
            String curStr;
            Component cur = raven.getCustomName();
            String string = curStr = cur == null ? "" : cur.getString();
            if (!ravenName.equals(curStr)) {
                raven.setCustomName((Component)Component.literal((String)ravenName));
            }
            raven.setCustomNameVisible(true);
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] ensureRavenName failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
        }
    }

    public static boolean isHoldingSealedScroll(@NotNull Player player) {
        try {
            ItemStack main = player.getMainHandItem();
            if (main == null || main.isEmpty()) {
                return false;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)main.getItem());
            if (key == null) {
                return false;
            }
            return SEALED_SCROLL_ID.equals((Object)key);
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] isHoldingSealedScroll failed safely for player='{}': {}", (Object)TamedRavenScrollWatcher.safePlayerName(player), (Object)t.toString());
            return false;
        }
    }

    public static boolean isScrollSummonedRaven(@NotNull RavenEntity raven) {
        try {
            return raven.getTags().contains(TAG_SCROLL_SUMMONED);
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] isScrollSummonedRaven failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            return false;
        }
    }

    @Nullable
    public static ServerPlayer getScrollSummonOwnerIfHoldingScroll(@NotNull ServerLevel level, @NotNull RavenEntity raven) {
        try {
            ServerPlayer owner;
            UUID ownerId;
            if (!TamedRavenScrollWatcher.isScrollSummonedRaven(raven)) {
                return null;
            }
            try {
                ownerId = raven.getOwnerUUID();
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] getScrollSummonOwnerIfHoldingScroll: getOwnerUUID failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
                return null;
            }
            if (ownerId == null) {
                return null;
            }
            try {
                owner = level.getServer().getPlayerList().getPlayer(ownerId);
            }
            catch (Throwable t) {
                LOG.warn("[TamedRavenScrollWatcher] getScrollSummonOwnerIfHoldingScroll: player lookup failed safely for ownerId={}: {}", (Object)ownerId, (Object)t.toString());
                return null;
            }
            if (owner == null) {
                return null;
            }
            if (!TamedRavenScrollWatcher.isHoldingSealedScroll((Player)owner)) {
                return null;
            }
            return owner;
        }
        catch (Throwable t) {
            LOG.warn("[TamedRavenScrollWatcher] getScrollSummonOwnerIfHoldingScroll failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
            return null;
        }
    }

    private static String safePlayerName(@NotNull Player player) {
        try {
            return player.getGameProfile().getName();
        }
        catch (Throwable ignored) {
            try {
                return player.getName().getString();
            }
            catch (Throwable ignored2) {
                return "<unknown>";
            }
        }
    }

    private static final class TamedRavenInfo {
        final boolean hasTamedRaven;
        final String ravenName;

        TamedRavenInfo(boolean hasTamedRaven, String ravenName) {
            this.hasTamedRaven = hasTamedRaven;
            this.ravenName = ravenName;
        }
    }

    private static final class RecallPayload {
        final long jobId;
        final String recipientUuidStr;
        final CompoundTag sealedScrollNbt;

        private RecallPayload(long jobId, @NotNull String recipientUuidStr, @NotNull CompoundTag sealedScrollNbt) {
            this.jobId = jobId;
            this.recipientUuidStr = recipientUuidStr;
            this.sealedScrollNbt = sealedScrollNbt;
        }
    }
}

