/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public final class TamedRavenPlayerData {
    private static final Logger LOG = LogUtils.getLogger();

    private TamedRavenPlayerData() {
    }

    public static TamedRavenInfo getTamedRavenInfo(ServerPlayer player) {
        try {
            if (player == null) {
                return TamedRavenInfo.empty();
            }
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                return TamedRavenInfo.empty();
            }
            if (!root.contains("featheredfriend", 10)) {
                return TamedRavenInfo.empty();
            }
            CompoundTag modTag = root.getCompound("featheredfriend");
            if (modTag == null || !modTag.contains("TamedRaven", 10)) {
                return TamedRavenInfo.empty();
            }
            CompoundTag tamed = modTag.getCompound("TamedRaven");
            if (tamed == null || tamed.isEmpty()) {
                return TamedRavenInfo.empty();
            }
            boolean has = tamed.getBoolean("HasTamedRaven");
            String name = "";
            if (tamed.contains("RavenName", 8)) {
                name = tamed.getString("RavenName");
            }
            return new TamedRavenInfo(has, name);
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenPlayerData] getTamedRavenInfo failed for player={}", (Object)(player == null ? "null" : player.getGameProfile().getName()), (Object)t);
            return TamedRavenInfo.empty();
        }
    }

    public static boolean clearPlayerTamedRavenData(ServerPlayer player) {
        try {
            if (player == null) {
                return false;
            }
            CompoundTag root = player.getPersistentData();
            if (root == null) {
                LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: no persistent data for player={}", (Object)player.getGameProfile().getName());
                return false;
            }
            if (!root.contains("featheredfriend", 10)) {
                LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: no '{}' tag for player={}", (Object)"featheredfriend", (Object)player.getGameProfile().getName());
                return false;
            }
            CompoundTag modTag = root.getCompound("featheredfriend");
            if (modTag == null || !modTag.contains("TamedRaven", 10)) {
                LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: no TamedRaven compound for player={}", (Object)player.getGameProfile().getName());
                return false;
            }
            CompoundTag tamed = modTag.getCompound("TamedRaven");
            if (tamed == null || tamed.isEmpty()) {
                LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: empty TamedRaven compound for player={}", (Object)player.getGameProfile().getName());
                return false;
            }
            boolean had = tamed.getBoolean("HasTamedRaven");
            LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: BEFORE clear player={} tag={}", (Object)player.getGameProfile().getName(), (Object)tamed);
            tamed.putBoolean("HasTamedRaven", false);
            tamed.remove("RavenName");
            tamed.remove("OwnerUUID");
            tamed.remove("OwnerDimension");
            if (tamed.isEmpty()) {
                modTag.remove("TamedRaven");
            } else {
                modTag.put("TamedRaven", (Tag)tamed);
            }
            if (modTag.isEmpty()) {
                root.remove("featheredfriend");
            } else {
                root.put("featheredfriend", (Tag)modTag);
            }
            LOG.info("[TamedRavenPlayerData] clearPlayerTamedRavenData: AFTER clear player={} had={} nowTag={}", new Object[]{player.getGameProfile().getName(), had, tamed});
            return had;
        }
        catch (Throwable t) {
            LOG.error("[TamedRavenPlayerData] clearPlayerTamedRavenData failed for player={}", (Object)(player == null ? "null" : player.getGameProfile().getName()), (Object)t);
            return false;
        }
    }

    public record TamedRavenInfo(boolean hasTamedRaven, String ravenName) {
        public static TamedRavenInfo empty() {
            return new TamedRavenInfo(false, "");
        }
    }
}

