/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

public final class RavenSpawnEvents {
    private static final Logger LOG = LogUtils.getLogger();
    private static final boolean ENABLE_SPAWNING = true;
    private static volatile boolean REGISTERED = false;
    private static final int CHECK_INTERVAL_TICKS = 200;
    private static final int CLEANUP_INTERVAL_TICKS = 100;
    private static final double LOCAL_RAVEN_RADIUS = 96.0;
    private static final int HARD_MAX_WILD_RAVENS_IN_RADIUS = 2;
    private static final double SPAWN_CHANCE_EMPTY_AREA = 0.02;
    private static final double SPAWN_CHANCE_WITH_ONE_RAVEN = 0.001;
    private static final int SEARCH_RADIUS_BLOCKS = 64;
    private static final int CANDIDATE_COLUMNS_PER_CHECK = 64;
    private static final int MAX_DOWNWARD_SCAN = 96;
    private static final int REQUIRED_AIR_ABOVE = 2;
    private static final ResourceLocation RAVEN_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven");
    private static final int DEBUG_LOG_INTERVAL_TICKS = 100;
    private static final int SPAWN_LOG_INTERVAL_TICKS = 200;
    private static final int MAX_PLAYER_HEIGHT_ABOVE_SURFACE = 128;
    private static final int GLOBAL_WILD_RAVEN_BUFFER = 6;

    private RavenSpawnEvents() {
    }

    public static void register() {
        try {
            if (REGISTERED) {
                LOG.warn("[RavenSpawnEvents] register() called but listener is already registered. Skipping duplicate registration.");
                return;
            }
            REGISTERED = true;
            NeoForge.EVENT_BUS.addListener(RavenSpawnEvents::onLevelTickPost);
            LOG.info("[RavenSpawnEvents] Registered LevelTickEvent.Post listener. ENABLE_SPAWNING={}", (Object)true);
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] Failed to register listeners", t);
        }
    }

    private static void onLevelTickPost(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        try {
            long gameTime = level2.getGameTime();
            EntityType ravenType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(RAVEN_ID);
            if (ravenType == null) {
                if (gameTime % 100L == 0L) {
                    LOG.warn("[RavenSpawnEvents] Raven EntityType not found for id {}", (Object)RAVEN_ID);
                }
                return;
            }
            List players = level2.players();
            if (players.isEmpty()) {
                return;
            }
            if (gameTime % 100L == 0L) {
                RavenSpawnEvents.enforceGlobalWildRavenCapNearPlayers(level2, players, ravenType, gameTime);
            }
            if (gameTime % 100L == 0L) {
                for (Player player : players) {
                    if (player == null || player.isSpectator()) continue;
                    RavenSpawnEvents.cullExtraWildRavensNearPlayer(level2, player, ravenType, gameTime);
                }
            }
            if (gameTime % 200L != 0L) {
                return;
            }
            int effectiveSearchRadius = RavenSpawnEvents.computeEffectiveSearchRadius();
            if (effectiveSearchRadius <= 0) {
                if (gameTime % 100L == 0L) {
                    LOG.warn("[RavenSpawnEvents] effectiveSearchRadius <= 0 (SEARCH_RADIUS_BLOCKS={}, LOCAL_RAVEN_RADIUS={}). Spawning disabled.", (Object)64, (Object)96.0);
                }
                return;
            }
            for (Player player : players) {
                double spawnChance;
                int wildCount;
                if (player == null || player.isSpectator() || RavenSpawnEvents.isPlayerTooHighAboveSurface(level2, player, gameTime) || (wildCount = RavenSpawnEvents.countWildRavensNearPlayer(level2, player, ravenType, gameTime)) >= 2) continue;
                double d = spawnChance = wildCount <= 0 ? 0.02 : 0.001;
                RandomSource rnd = level2.getRandom();
                if (rnd.nextDouble() >= spawnChance) continue;
                BlockPos spawnPos = RavenSpawnEvents.findLeavesTopSpawnPos(level2, player, rnd, effectiveSearchRadius);
                if (spawnPos == null) {
                    if (gameTime % 100L != 0L) continue;
                    LOG.debug("[RavenSpawnEvents] No valid leaves-top spawn found near player {} (effectiveRadius={} blocks).", (Object)RavenSpawnEvents.safeName(player), (Object)effectiveSearchRadius);
                    continue;
                }
                int wildCountPreSpawn = RavenSpawnEvents.countWildRavensNearPlayer(level2, player, ravenType, gameTime);
                if (wildCountPreSpawn >= 2) {
                    if (gameTime % 100L != 0L) continue;
                    LOG.debug("[RavenSpawnEvents] Spawn aborted: cap already reached near player {} (wildCountPreSpawn={}).", (Object)RavenSpawnEvents.safeName(player), (Object)wildCountPreSpawn);
                    continue;
                }
                if (!RavenSpawnEvents.spawnRaven(level2, ravenType, spawnPos, gameTime)) continue;
                if (gameTime % 200L == 0L) {
                    LOG.info("[RavenSpawnEvents] Spawned WILD raven at {} near player {} (wildCountBeforeSpawn={})", new Object[]{spawnPos, RavenSpawnEvents.safeName(player), wildCountPreSpawn});
                    continue;
                }
                if (gameTime % 100L != 0L) continue;
                LOG.debug("[RavenSpawnEvents] Spawned WILD raven at {} near player {} (wildCountBeforeSpawn={})", new Object[]{spawnPos, RavenSpawnEvents.safeName(player), wildCountPreSpawn});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] onLevelTickPost failed", t);
        }
    }

    private static int computeEffectiveSearchRadius() {
        try {
            int maxInsideLocal = (int)Math.floor(96.0) - 8;
            if (maxInsideLocal <= 0) {
                return 0;
            }
            return Math.max(1, Math.min(64, maxInsideLocal));
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] computeEffectiveSearchRadius failed", t);
            return 0;
        }
    }

    private static boolean isPlayerTooHighAboveSurface(ServerLevel level, Player player, long gameTime) {
        try {
            int surfaceY;
            BlockPos p = player.blockPosition();
            try {
                surfaceY = level.getHeight(Heightmap.Types.WORLD_SURFACE, p.getX(), p.getZ());
            }
            catch (Throwable t) {
                if (gameTime % 100L == 0L) {
                    LOG.debug("[RavenSpawnEvents] Surface height query failed for player {} at xz=({},{}). Spawning skipped.", new Object[]{RavenSpawnEvents.safeName(player), p.getX(), p.getZ()});
                }
                return true;
            }
            int above = p.getY() - surfaceY;
            if (above > 128) {
                if (gameTime % 100L == 0L) {
                    LOG.info("[RavenSpawnEvents] Player {} is too high above surface (playerY={}, surfaceY={}, delta={} > {}). Spawning disabled for this player.", new Object[]{RavenSpawnEvents.safeName(player), p.getY(), surfaceY, above, 128});
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] isPlayerTooHighAboveSurface failed", t);
            return true;
        }
    }

    private static String safeName(Player player) {
        try {
            if (player.getGameProfile() != null && player.getGameProfile().getName() != null) {
                return player.getGameProfile().getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<unknown>";
    }

    private static boolean isRavenEntity(Entity e, EntityType<?> ravenType) {
        try {
            return e != null && e.getType() == ravenType;
        }
        catch (Throwable t) {
            LOG.debug("[RavenSpawnEvents] isRavenEntity check failed", t);
            return false;
        }
    }

    private static boolean isWildRaven(Entity e, EntityType<?> ravenType) {
        try {
            TamableAnimal ta;
            if (!RavenSpawnEvents.isRavenEntity(e, ravenType)) {
                return false;
            }
            return !(e instanceof TamableAnimal) || !(ta = (TamableAnimal)e).isTame();
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] isWildRaven failed (defaulting to NOT wild to avoid accidental culling)", t);
            return false;
        }
    }

    private static int countWildRavensNearPlayer(ServerLevel level, Player player, EntityType<?> ravenType, long gameTime) {
        try {
            int count;
            AABB box = player.getBoundingBox().inflate(96.0);
            List matches = level.getEntitiesOfClass(Entity.class, box, e -> RavenSpawnEvents.isWildRaven(e, ravenType));
            int n = count = matches == null ? 0 : matches.size();
            if (gameTime % 100L == 0L) {
                LOG.debug("[RavenSpawnEvents] countWildRavensNearPlayer: player={} wildCount={} radius={}", new Object[]{RavenSpawnEvents.safeName(player), count, 96.0});
            }
            return count;
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] countWildRavensNearPlayer failed", t);
            return 2;
        }
    }

    private static void cullExtraWildRavensNearPlayer(ServerLevel level, Player player, EntityType<?> ravenType, long gameTime) {
        try {
            AABB box = player.getBoundingBox().inflate(96.0);
            List wildRavens = level.getEntitiesOfClass(Entity.class, box, e -> RavenSpawnEvents.isWildRaven(e, ravenType));
            if (wildRavens == null || wildRavens.size() <= 2) {
                return;
            }
            wildRavens.sort(Comparator.comparingDouble(e -> {
                try {
                    return e.distanceToSqr((Entity)player);
                }
                catch (Throwable t) {
                    return Double.MAX_VALUE;
                }
            }).reversed());
            int removed = 0;
            for (int i = 2; i < wildRavens.size(); ++i) {
                Entity e2 = (Entity)wildRavens.get(i);
                if (e2 == null || !e2.isAlive()) continue;
                try {
                    e2.discard();
                    ++removed;
                    continue;
                }
                catch (Throwable t) {
                    LOG.warn("[RavenSpawnEvents] Failed to discard extra wild raven {}", (Object)e2, (Object)t);
                }
            }
            if (removed > 0 && gameTime % 100L == 0L) {
                LOG.warn("[RavenSpawnEvents] CULLED extra wild ravens near player {}: before={} removed={} kept={}", new Object[]{RavenSpawnEvents.safeName(player), wildRavens.size(), removed, 2});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] cullExtraWildRavensNearPlayer failed", t);
        }
    }

    private static void enforceGlobalWildRavenCapNearPlayers(ServerLevel level, List<? extends Player> players, EntityType<?> ravenType, long gameTime) {
        try {
            int nonSpectators = 0;
            for (Player player : players) {
                if (player == null || player.isSpectator()) continue;
                ++nonSpectators;
            }
            if (nonSpectators <= 0) {
                return;
            }
            int globalCap = nonSpectators * 2 + 6;
            ArrayList arrayList = new ArrayList();
            for (Player player : players) {
                Object box;
                List local;
                if (player == null || player.isSpectator() || (local = level.getEntitiesOfClass(Entity.class, (AABB)(box = player.getBoundingBox().inflate(96.0)), e -> RavenSpawnEvents.isWildRaven(e, ravenType))) == null || local.isEmpty()) continue;
                arrayList.addAll(local);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            ArrayList<Entity> unique = new ArrayList<Entity>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Entity e2 : arrayList) {
                int id;
                if (e2 == null) continue;
                try {
                    id = e2.getId();
                }
                catch (Throwable t) {
                    continue;
                }
                if (!hashSet.add(id)) continue;
                unique.add(e2);
            }
            if (unique.size() <= globalCap) {
                if (gameTime % 100L == 0L) {
                    LOG.debug("[RavenSpawnEvents] Global wild raven count near players OK: count={} cap={}", (Object)unique.size(), (Object)globalCap);
                }
                return;
            }
            unique.sort(Comparator.comparingDouble(e -> {
                double best = Double.MIN_VALUE;
                try {
                    double nearest = Double.POSITIVE_INFINITY;
                    for (Player p : players) {
                        double d;
                        if (p == null || p.isSpectator() || !((d = e.distanceToSqr((Entity)p)) < nearest)) continue;
                        nearest = d;
                    }
                    best = nearest;
                }
                catch (Throwable ignored) {
                    best = Double.NEGATIVE_INFINITY;
                }
                return best;
            }).reversed());
            int toRemove = unique.size() - globalCap;
            int removed = 0;
            for (Entity e3 : unique) {
                if (removed >= toRemove) break;
                if (e3 == null || !e3.isAlive()) continue;
                try {
                    e3.discard();
                    ++removed;
                }
                catch (Throwable t) {
                    LOG.warn("[RavenSpawnEvents] Failed to discard wild raven during global cap enforcement {}", (Object)e3, (Object)t);
                }
            }
            if (removed > 0) {
                LOG.warn("[RavenSpawnEvents] GLOBAL CULL: wild ravens near players exceeded cap. countBefore={} cap={} removed={}", new Object[]{unique.size(), globalCap, removed});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] enforceGlobalWildRavenCapNearPlayers failed", t);
        }
    }

    private static BlockPos findLeavesTopSpawnPos(ServerLevel level, Player player, RandomSource rnd, int effectiveSearchRadius) {
        BlockPos origin = player.blockPosition();
        for (int attempt = 0; attempt < 64; ++attempt) {
            int topY;
            int dx = rnd.nextInt(effectiveSearchRadius * 2 + 1) - effectiveSearchRadius;
            int dz = rnd.nextInt(effectiveSearchRadius * 2 + 1) - effectiveSearchRadius;
            int x = origin.getX() + dx;
            int z = origin.getZ() + dz;
            ChunkPos cp = new ChunkPos(x >> 4, z >> 4);
            if (!level.hasChunk(cp.x, cp.z)) continue;
            try {
                topY = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
            }
            catch (Throwable t) {
                continue;
            }
            int minY = Math.max(level.getMinBuildHeight(), topY - 96);
            for (int y = topY; y >= minY; --y) {
                BlockPos spawnPos;
                BlockPos leavesPos = new BlockPos(x, y, z);
                BlockState state = level.getBlockState(leavesPos);
                if (state == null || !state.is(BlockTags.LEAVES) || !RavenSpawnEvents.isAirColumn(level, spawnPos = leavesPos.above(), 2) || !level.getWorldBorder().isWithinBounds(spawnPos) || !level.isEmptyBlock(spawnPos)) continue;
                double dxp = (double)spawnPos.getX() + 0.5 - ((double)origin.getX() + 0.5);
                double dzp = (double)spawnPos.getZ() + 0.5 - ((double)origin.getZ() + 0.5);
                double distSq = dxp * dxp + dzp * dzp;
                double maxDist = 95.0;
                if (distSq > 9025.0) continue;
                return spawnPos;
            }
        }
        return null;
    }

    private static boolean isAirColumn(ServerLevel level, BlockPos start, int airBlocksNeeded) {
        try {
            BlockPos pos = start;
            for (int i = 0; i < airBlocksNeeded; ++i) {
                if (!level.isEmptyBlock(pos)) {
                    return false;
                }
                pos = pos.above();
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] isAirColumn failed", t);
            return false;
        }
    }

    private static boolean spawnRaven(ServerLevel level, EntityType<?> type, BlockPos pos, long gameTime) {
        try {
            boolean ok;
            BlockState belowState;
            BlockPos below = pos.below();
            try {
                belowState = level.getBlockState(below);
            }
            catch (Throwable t) {
                LOG.warn("[RavenSpawnEvents] Spawn aborted: failed to read block below {}.", (Object)pos, (Object)t);
                return false;
            }
            if (belowState == null || !belowState.is(BlockTags.LEAVES)) {
                if (gameTime % 100L == 0L) {
                    LOG.warn("[RavenSpawnEvents] Spawn aborted: position {} is NOT above leaves (below={} state={}). If you're seeing ravens spawn on ground, they are likely coming from biome spawn lists, not this handler.", new Object[]{pos, below, belowState});
                }
                return false;
            }
            if (!level.isEmptyBlock(pos)) {
                if (gameTime % 100L == 0L) {
                    LOG.debug("[RavenSpawnEvents] Spawn aborted: {} is not empty.", (Object)pos);
                }
                return false;
            }
            Entity created = type.create((Level)level);
            if (created == null) {
                LOG.warn("[RavenSpawnEvents] EntityType.create() returned null for {}", (Object)RAVEN_ID);
                return false;
            }
            created.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, level.getRandom().nextFloat() * 360.0f, 0.0f);
            if (created instanceof Mob) {
                Mob mob = (Mob)created;
                try {
                    mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.NATURAL, null);
                }
                catch (Throwable t) {
                    LOG.warn("[RavenSpawnEvents] finalizeSpawn failed for raven at {} \u2013 continuing with spawned entity", (Object)pos, (Object)t);
                }
            }
            if (!(ok = level.addFreshEntity(created))) {
                LOG.warn("[RavenSpawnEvents] addFreshEntity returned false at {}", (Object)pos);
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[RavenSpawnEvents] spawnRaven failed at {}", (Object)pos, (Object)t);
            return false;
        }
    }
}

