/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.RavenVariant;
import net.z2six.featheredfriend.entity.raven.modules.TamedRaven;
import net.z2six.featheredfriend.entity.raven.modules.Teleportation;
import net.z2six.featheredfriend.registry.FFNeoForgeEntities;
import net.z2six.featheredfriend.world.RavenCourierData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class RavenCourierRuntime {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String TAG_COURIER_RAVEN = "ff_courier_raven";
    private static final ResourceLocation SEALED_SCROLL_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"scroll_sealed");
    private static final long COURIER_LIFETIME_TICKS = 1200L;
    private static final String NBT_COURIER_DESPAWN_AT = "CourierDespawnAt";
    private static final int DISPATCH_INTERVAL_TICKS = 20;
    private static final int MAX_NEW_DISPATCHES_PER_PASS = 4;
    private static int serverTickCounter = 0;

    private RavenCourierRuntime() {
    }

    public static void register() {
        try {
            NeoForge.EVENT_BUS.addListener(RavenCourierRuntime::onServerTick);
            NeoForge.EVENT_BUS.addListener(RavenCourierRuntime::onEntityInteract);
            NeoForge.EVENT_BUS.addListener(RavenCourierRuntime::onRavenDeath);
            LOG.info("[RavenCourierRuntime] Registered server tick + interaction + death listeners");
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] Failed to register event listeners", t);
        }
    }

    public static boolean requestRetryDelivery(@NotNull MinecraftServer server, @NotNull UUID senderUuid, long jobId) {
        try {
            if (server == null) {
                return false;
            }
            ServerLevel overworld = server.overworld();
            if (overworld == null) {
                LOG.warn("[RavenCourierRuntime] requestRetryDelivery: overworld is null (jobId={})", (Object)jobId);
                return false;
            }
            RavenCourierData data = RavenCourierData.get(overworld);
            boolean ok = data.clearFailedForRetry(jobId, senderUuid);
            if (ok) {
                LOG.info("[RavenCourierRuntime] requestRetryDelivery: sender={} requested retry for jobId={}", (Object)senderUuid, (Object)jobId);
                try {
                    RavenCourierRuntime.dispatchPendingDeliveries(server);
                }
                catch (Throwable dispatchErr) {
                    LOG.warn("[RavenCourierRuntime] requestRetryDelivery: immediate dispatch failed safely: {}", (Object)dispatchErr.toString());
                }
            } else {
                LOG.warn("[RavenCourierRuntime] requestRetryDelivery: retry rejected (sender={} jobId={})", (Object)senderUuid, (Object)jobId);
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] requestRetryDelivery failed safely (sender={} jobId={})", new Object[]{senderUuid, jobId, t});
            return false;
        }
    }

    private static void onServerTick(@NotNull ServerTickEvent.Post event) {
        try {
            MinecraftServer server = event.getServer();
            if (server == null) {
                return;
            }
            if (++serverTickCounter % 20 != 0) {
                return;
            }
            RavenCourierRuntime.dispatchPendingDeliveries(server);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] onServerTick failed safely", t);
        }
    }

    private static void dispatchPendingDeliveries(@NotNull MinecraftServer server) {
        try {
            ServerLevel overworld = server.overworld();
            if (overworld == null) {
                LOG.warn("[RavenCourierRuntime] dispatchPendingDeliveries: overworld is null; aborting dispatch.");
                return;
            }
            RavenCourierData data = RavenCourierData.get(overworld);
            List<RavenCourierData.DeliveryJob> allJobs = data.getAllJobsFlat();
            HashSet<UUID> busySenders = new HashSet<UUID>();
            HashSet<UUID> busyRecipients = new HashSet<UUID>();
            RavenCourierRuntime.reconcileJobsWithExistingCourierRavens(server, overworld, data, allJobs, busySenders, busyRecipients);
            for (RavenCourierData.DeliveryJob job : allJobs) {
                RavenCourierData.DeliveryJob liveJob;
                if (job == null || (liveJob = data.getJobById(job.jobId)) == null || !liveJob.inFlight) continue;
                if (liveJob.senderUuid != null) {
                    busySenders.add(liveJob.senderUuid);
                }
                if (liveJob.recipientUuid == null) continue;
                busyRecipients.add(liveJob.recipientUuid);
            }
            if (allJobs.isEmpty()) {
                return;
            }
            int dispatchedCount = 0;
            for (RavenCourierData.DeliveryJob job : allJobs) {
                ServerLevel targetLevel;
                ServerPlayer recipient;
                RavenCourierData.DeliveryJob liveJob;
                if (job == null || (liveJob = data.getJobById(job.jobId)) == null) continue;
                job = liveJob;
                if (job.failed) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("[RavenCourierRuntime] dispatch: jobId={} is failed; skipping until retry.", (Object)job.jobId);
                    continue;
                }
                if (job.inFlight) continue;
                UUID senderId = job.senderUuid;
                UUID recipientId = job.recipientUuid;
                if (recipientId == null || senderId != null && busySenders.contains(senderId) || busyRecipients.contains(recipientId) || (recipient = server.getPlayerList().getPlayer(recipientId)) == null || (targetLevel = recipient.serverLevel()) == null || targetLevel.isClientSide()) continue;
                if (RavenCourierRuntime.hasActiveCourierRavenForJob(server, job.jobId)) {
                    job.inFlight = true;
                    data.setDirty();
                    if (senderId != null) {
                        busySenders.add(senderId);
                    }
                    busyRecipients.add(recipientId);
                    LOG.warn("[RavenCourierRuntime] dispatch: jobId={} already has an active courier raven; skipping duplicate spawn.", (Object)job.jobId);
                    continue;
                }
                RavenEntity raven = RavenCourierRuntime.spawnCourierRavenForJob(targetLevel, recipient, job);
                if (raven == null) continue;
                job.inFlight = true;
                data.setDirty();
                if (senderId != null) {
                    busySenders.add(senderId);
                }
                busyRecipients.add(recipientId);
                if (++dispatchedCount < 4) continue;
                break;
            }
            if (dispatchedCount > 0 && LOG.isInfoEnabled()) {
                LOG.info("[RavenCourierRuntime] Dispatched {} courier raven(s) this tick.", (Object)dispatchedCount);
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] dispatchPendingDeliveries failed safely", t);
        }
    }

    private static boolean hasActiveCourierRavenForJob(@NotNull MinecraftServer server, long jobId) {
        try {
            if (jobId <= 0L) {
                return false;
            }
            for (ServerLevel level : server.getAllLevels()) {
                try {
                    double minX = level.getWorldBorder().getMinX() - 16.0;
                    double minZ = level.getWorldBorder().getMinZ() - 16.0;
                    double maxX = level.getWorldBorder().getMaxX() + 16.0;
                    double maxZ = level.getWorldBorder().getMaxZ() + 16.0;
                    double minY = level.getMinBuildHeight() - 1;
                    double maxY = level.getMaxBuildHeight() + 1;
                    AABB worldBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                    List ravens = level.getEntitiesOfClass(RavenEntity.class, worldBox, e -> e != null && e.isAlive() && !e.isRemoved());
                    for (RavenEntity raven : ravens) {
                        long ravenJobId;
                        if (!RavenCourierRuntime.isCourierRaven(raven) || (ravenJobId = RavenCourierRuntime.getCourierJobIdFromRaven(raven)) != jobId) continue;
                        return true;
                    }
                }
                catch (Throwable levelErr) {
                    LOG.warn("[RavenCourierRuntime] hasActiveCourierRavenForJob: level scan failed safely: {}", (Object)levelErr.toString());
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] hasActiveCourierRavenForJob failed safely for jobId={}: {}", (Object)jobId, (Object)t.toString());
        }
        return false;
    }

    private static void handleCourierRavenTimeout(@NotNull ServerLevel level, @NotNull RavenCourierData data, @NotNull RavenEntity raven, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            ServerPlayer contextPlayer;
            long now = level.getGameTime();
            boolean marked = data.markJobFailed(job.jobId, job.recipientUuid, "timeout", now);
            if (!marked) {
                LOG.warn("[RavenCourierRuntime] handleCourierRavenTimeout: failed to mark jobId={} as failed (still despawning raven).", (Object)job.jobId);
            }
            if ((contextPlayer = RavenCourierRuntime.findBestContextPlayer(level.getServer(), job.senderUuid, job.recipientUuid)) != null) {
                RavenCourierRuntime.despawnCourierRaven(level, contextPlayer, raven, "timeout (job marked failed)");
            } else {
                LOG.warn("[RavenCourierRuntime] handleCourierRavenTimeout: no context player; discarding raven id={} silently.", (Object)raven.getId());
                RavenCourierRuntime.clearCourierFlags(raven);
                raven.discard();
            }
            LOG.info("[RavenCourierRuntime] handleCourierRavenTimeout: jobId={} marked failed; courier raven id={} despawned.", (Object)job.jobId, (Object)raven.getId());
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] handleCourierRavenTimeout failed safely for jobId={}", (Object)job.jobId, (Object)t);
            try {
                RavenCourierRuntime.clearCourierFlags(raven);
                raven.discard();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static ServerPlayer findBestContextPlayer(@Nullable MinecraftServer server, @Nullable UUID senderUuid, @Nullable UUID recipientUuid) {
        try {
            ServerPlayer p;
            if (server == null) {
                return null;
            }
            if (recipientUuid != null && (p = server.getPlayerList().getPlayer(recipientUuid)) != null) {
                return p;
            }
            if (senderUuid != null && (p = server.getPlayerList().getPlayer(senderUuid)) != null) {
                return p;
            }
            List players = server.getPlayerList().getPlayers();
            if (!players.isEmpty()) {
                return (ServerPlayer)players.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void reconcileJobsWithExistingCourierRavens(@NotNull MinecraftServer server, @NotNull ServerLevel overworld, @NotNull RavenCourierData data, @NotNull List<RavenCourierData.DeliveryJob> allJobs, @NotNull Set<UUID> busySenders, @NotNull Set<UUID> busyRecipients) {
        try {
            HashMap<Long, RavenCourierData.DeliveryJob> jobsById = new HashMap<Long, RavenCourierData.DeliveryJob>();
            for (RavenCourierData.DeliveryJob job : allJobs) {
                if (job == null) continue;
                jobsById.put(job.jobId, job);
            }
            for (ServerLevel level : server.getAllLevels()) {
                try {
                    double minX = level.getWorldBorder().getMinX() - 16.0;
                    double minZ = level.getWorldBorder().getMinZ() - 16.0;
                    double maxX = level.getWorldBorder().getMaxX() + 16.0;
                    double maxZ = level.getWorldBorder().getMaxZ() + 16.0;
                    double minY = level.getMinBuildHeight() - 1;
                    double maxY = level.getMaxBuildHeight() + 1;
                    AABB worldBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                    List ravens = level.getEntitiesOfClass(RavenEntity.class, worldBox, e -> e != null && e.isAlive() && !e.isRemoved());
                    for (RavenEntity raven : ravens) {
                        if (!RavenCourierRuntime.isCourierRaven(raven)) continue;
                        long jobId = RavenCourierRuntime.getCourierJobIdFromRaven(raven);
                        if (jobId <= 0L) {
                            LOG.warn("[RavenCourierRuntime] reconcile: courier raven id={} has no valid CourierJobId; discarding stray courier.", (Object)raven.getId());
                            RavenCourierRuntime.clearCourierFlags(raven);
                            raven.discard();
                            continue;
                        }
                        RavenCourierData.DeliveryJob job = (RavenCourierData.DeliveryJob)jobsById.get(jobId);
                        if (job == null) {
                            LOG.warn("[RavenCourierRuntime] reconcile: courier raven id={} refers to unknown jobId={}; discarding stray courier.", (Object)raven.getId(), (Object)jobId);
                            RavenCourierRuntime.clearCourierFlags(raven);
                            raven.discard();
                            continue;
                        }
                        if (job.failed) {
                            ServerPlayer ctx = RavenCourierRuntime.findBestContextPlayer(level.getServer(), job.senderUuid, job.recipientUuid);
                            if (ctx != null) {
                                LOG.warn("[RavenCourierRuntime] reconcile: jobId={} is failed but courier raven id={} exists; despawning raven.", (Object)job.jobId, (Object)raven.getId());
                                job.inFlight = false;
                                data.setDirty();
                                RavenCourierRuntime.despawnCourierRaven(level, ctx, raven, "job already failed (cleanup)");
                                continue;
                            }
                            LOG.warn("[RavenCourierRuntime] reconcile: jobId={} failed; discarding courier raven id={} silently (no context player).", (Object)job.jobId, (Object)raven.getId());
                            RavenCourierRuntime.clearCourierFlags(raven);
                            raven.discard();
                            continue;
                        }
                        try {
                            CompoundTag root = raven.getPersistentData();
                            CompoundTag ffTag = root.getCompound("featheredfriend");
                            long now = level.getGameTime();
                            long despawnAt = ffTag.getLong(NBT_COURIER_DESPAWN_AT);
                            if (despawnAt <= 0L) {
                                despawnAt = now + 1200L;
                                ffTag.putLong(NBT_COURIER_DESPAWN_AT, despawnAt);
                                root.put("featheredfriend", (Tag)ffTag);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("[RavenCourierRuntime] reconcile: initializing lifetime for courier raven id={} jobId={} now={} despawnAt={}", new Object[]{raven.getId(), job.jobId, now, despawnAt});
                                }
                            }
                            if (now >= despawnAt) {
                                LOG.info("[RavenCourierRuntime] reconcile: lifetime expired for courier raven id={} jobId={} now={} despawnAt={}", new Object[]{raven.getId(), job.jobId, now, despawnAt});
                                RavenCourierRuntime.handleCourierRavenTimeout(level, data, raven, job);
                                continue;
                            }
                        }
                        catch (Throwable lifetimeErr) {
                            LOG.warn("[RavenCourierRuntime] reconcile: lifetime check failed safely for raven id={} jobId={}: {}", new Object[]{raven.getId(), job.jobId, lifetimeErr.toString()});
                        }
                        job.inFlight = true;
                        if (job.senderUuid != null) {
                            busySenders.add(job.senderUuid);
                        }
                        if (job.recipientUuid == null) continue;
                        busyRecipients.add(job.recipientUuid);
                    }
                }
                catch (Throwable levelErr) {
                    LOG.warn("[RavenCourierRuntime] reconcile: level scan failed safely: {}", (Object)levelErr.toString());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] reconcileJobsWithExistingCourierRavens failed safely", t);
        }
    }

    @Nullable
    private static RavenEntity spawnCourierRavenForJob(@NotNull ServerLevel level, @NotNull ServerPlayer recipient, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            RavenEntity raven = (RavenEntity)((EntityType)FFNeoForgeEntities.RAVEN.get()).create((Level)level);
            if (raven == null) {
                LOG.error("[RavenCourierRuntime] spawnCourierRavenForJob: entity factory returned null for jobId={}", (Object)job.jobId);
                return null;
            }
            Vec3 spawnPos = RavenCourierRuntime.findCourierSpawnPos(level, recipient, raven, job.jobId);
            if (spawnPos == null) {
                LOG.warn("[RavenCourierRuntime] spawnCourierRavenForJob: no valid spawn (or simulated path failed) for recipient='{}' jobId={} -> not spawning.", (Object)RavenCourierRuntime.safePlayerName((Player)recipient), (Object)job.jobId);
                return null;
            }
            raven.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, recipient.getYRot(), 0.0f);
            try {
                raven.setTame(true, true);
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] spawnCourierRavenForJob: setTame(true,true) failed safely for jobId={}: {}", (Object)job.jobId, (Object)t.toString());
            }
            try {
                raven.setOwnerUUID(job.recipientUuid);
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] spawnCourierRavenForJob: setOwnerUUID failed safely for jobId={}: {}", (Object)job.jobId, (Object)t.toString());
            }
            try {
                raven.setRavenVariant(RavenVariant.SCROLL);
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] spawnCourierRavenForJob: setRavenVariant(SCROLL) failed safely for jobId={}: {}", (Object)job.jobId, (Object)t.toString());
            }
            String ravenName = job.ravenName != null && !job.ravenName.isEmpty() ? job.ravenName : "Raven";
            RavenCourierRuntime.ensureRavenName(raven, ravenName);
            RavenCourierRuntime.attachCourierJobToRaven(level, raven, job);
            level.addFreshEntity((Entity)raven);
            RavenCourierRuntime.playCourierSpawnFx(level, recipient, raven);
            LOG.info("[RavenCourierRuntime] spawnCourierRavenForJob: spawned courier raven id={} for jobId={} recipient='{}' at {} name='{}'", new Object[]{raven.getId(), job.jobId, job.recipientName, raven.position(), ravenName});
            return raven;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] spawnCourierRavenForJob failed safely for jobId={}", (Object)job.jobId, (Object)t);
            return null;
        }
    }

    private static void attachCourierJobToRaven(@NotNull ServerLevel level, @NotNull RavenEntity raven, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            CompoundTag root = raven.getPersistentData();
            CompoundTag ffTag = root.getCompound("featheredfriend");
            ffTag.putBoolean("CourierActive", true);
            ffTag.putLong("CourierJobId", job.jobId);
            if (job.senderUuid != null) {
                ffTag.putUUID("CourierSenderUUID", job.senderUuid);
            }
            if (job.recipientUuid != null) {
                ffTag.putUUID("CourierRecipientUUID", job.recipientUuid);
            }
            long now = level.getGameTime();
            long despawnAt = now + 1200L;
            ffTag.putLong(NBT_COURIER_DESPAWN_AT, despawnAt);
            root.put("featheredfriend", (Tag)ffTag);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[RavenCourierRuntime] attachCourierJobToRaven: lifetime set for raven id={} jobId={} now={} despawnAt={}", new Object[]{raven.getId(), job.jobId, now, despawnAt});
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] attachCourierJobToRaven: NBT write failed safely for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
        }
        try {
            raven.addTag(TAG_COURIER_RAVEN);
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] attachCourierJobToRaven: addTag({}) failed safely for raven id={}: {}", new Object[]{TAG_COURIER_RAVEN, raven.getId(), t.toString()});
        }
    }

    private static void playCourierSpawnFx(@NotNull ServerLevel level, @NotNull ServerPlayer recipient, @NotNull RavenEntity raven) {
        try {
            Vec3 ravenPos = raven.position();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, ravenPos.x, ravenPos.y + 0.4, ravenPos.z, 40, 0.3, 0.4, 0.3, 0.02);
            level.playSound(null, ravenPos.x, ravenPos.y, ravenPos.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - 0.5f) * 0.2f);
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] playCourierSpawnFx failed safely: {}", (Object)t.toString());
        }
    }

    @Nullable
    private static Vec3 findCourierSpawnPos(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull RavenEntity simRaven, long jobId) {
        try {
            Vec3 pocket;
            int clampMax;
            BlockPos feet = player.blockPosition();
            int cx = feet.getX();
            int cz = feet.getZ();
            int feetY = feet.getY();
            int minY = level.getMinBuildHeight();
            int maxY = level.getMaxBuildHeight() - 1;
            int ceilingY = RavenCourierRuntime.scanFirstCeilingYWithin15(level, player, cx, feetY, cz, minY, maxY);
            if (ceilingY > 0) {
                Vec3 pocketUnderCeiling;
                int baseYUnderCeiling = ceilingY - 3;
                if (baseYUnderCeiling < minY) {
                    baseYUnderCeiling = minY;
                }
                if (baseYUnderCeiling > maxY - 2) {
                    baseYUnderCeiling = maxY - 2;
                }
                if ((pocketUnderCeiling = RavenCourierRuntime.findFirst3x3x3PocketNear(level, player, cx, baseYUnderCeiling, cz, minY, maxY)) != null) {
                    LOG.info("[RavenCourierRuntime] findCourierSpawnPos: CEILING FOUND at y={} -> pocketUnderCeiling={} jobId={} player='{}'", new Object[]{ceilingY, pocketUnderCeiling, jobId, RavenCourierRuntime.safePlayerName((Player)player)});
                    if (RavenCourierRuntime.canSimulatePathToPlayer(level, player, pocketUnderCeiling, simRaven, jobId, "courier-under-ceiling")) {
                        return pocketUnderCeiling;
                    }
                    LOG.warn("[RavenCourierRuntime] findCourierSpawnPos: simulated path FAILED -> not spawning. candidate={} jobId={} player='{}'", new Object[]{pocketUnderCeiling, jobId, RavenCourierRuntime.safePlayerName((Player)player)});
                    return null;
                }
                LOG.warn("[RavenCourierRuntime] findCourierSpawnPos: CEILING FOUND at y={} but NO pocket-under-ceiling found (baseY={}) jobId={} player='{}'", new Object[]{ceilingY, baseYUnderCeiling, jobId, RavenCourierRuntime.safePlayerName((Player)player)});
            }
            int preferredOffsetY = 15;
            int baseY = Mth.floor((double)(player.getY() + 15.0 + 0.5));
            int clampMin = level.getMinBuildHeight() + 2;
            if ((baseY = Mth.clamp((int)baseY, (int)clampMin, (int)(clampMax = level.getMaxBuildHeight() - 2))) < minY) {
                baseY = minY;
            }
            if (baseY > maxY - 2) {
                baseY = maxY - 2;
            }
            if ((pocket = RavenCourierRuntime.findFirst3x3x3PocketNear(level, player, cx, baseY, cz, minY, maxY)) != null) {
                LOG.info("[RavenCourierRuntime] findCourierSpawnPos: fallback +15 pocket={} jobId={} player='{}'", new Object[]{pocket, jobId, RavenCourierRuntime.safePlayerName((Player)player)});
                if (RavenCourierRuntime.canSimulatePathToPlayer(level, player, pocket, simRaven, jobId, "courier-fallback+15")) {
                    return pocket;
                }
                LOG.warn("[RavenCourierRuntime] findCourierSpawnPos: simulated path FAILED -> not spawning. candidate={} jobId={} player='{}'", new Object[]{pocket, jobId, RavenCourierRuntime.safePlayerName((Player)player)});
                return null;
            }
            LOG.warn("[RavenCourierRuntime] findCourierSpawnPos: no pocket found (ceilingY={}, baseY={}) jobId={} player='{}' feet={}", new Object[]{ceilingY, baseY, jobId, RavenCourierRuntime.safePlayerName((Player)player), feet});
            return null;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] findCourierSpawnPos failed safely (jobId={})", (Object)jobId, (Object)t);
            return null;
        }
    }

    private static int scanFirstCeilingYWithin15(@NotNull ServerLevel level, @NotNull ServerPlayer player, int x, int feetY, int z, int minY, int maxY) {
        try {
            int y;
            try {
                BlockPos feet = new BlockPos(x, feetY, z);
                if (!level.hasChunkAt(feet)) {
                    level.getChunk(feet);
                }
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] scanFirstCeilingYWithin15: failed to force-load player chunk at ({},{},{}) player='{}': {}", new Object[]{x, feetY, z, RavenCourierRuntime.safePlayerName((Player)player), t.toString()});
            }
            for (int dy = 1; dy <= 15 && (y = feetY + dy) >= minY && y <= maxY; ++dy) {
                boolean isAir;
                BlockState st;
                BlockPos probe = new BlockPos(x, y, z);
                try {
                    if (!level.hasChunkAt(probe)) {
                        level.getChunk(probe);
                    }
                }
                catch (Throwable t) {
                    LOG.warn("[RavenCourierRuntime] scanFirstCeilingYWithin15: chunk load failed at {} (dy={}) player='{}': {}", new Object[]{probe, dy, RavenCourierRuntime.safePlayerName((Player)player), t.toString()});
                }
                try {
                    st = level.getBlockState(probe);
                }
                catch (Throwable t) {
                    LOG.warn("[RavenCourierRuntime] scanFirstCeilingYWithin15: getBlockState failed at {} (dy={}) player='{}': {}", new Object[]{probe, dy, RavenCourierRuntime.safePlayerName((Player)player), t.toString()});
                    continue;
                }
                try {
                    isAir = st == null || st.isAir();
                }
                catch (Throwable t) {
                    isAir = false;
                }
                if (isAir) continue;
                String key = "unknown";
                try {
                    key = String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)st.getBlock()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOG.info("[RavenCourierRuntime] scanFirstCeilingYWithin15: HIT dy={} y={} block={} feetY={} player='{}'", new Object[]{dy, y, key, feetY, RavenCourierRuntime.safePlayerName((Player)player)});
                return y;
            }
            return -1;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] scanFirstCeilingYWithin15 failed safely for player='{}'", (Object)RavenCourierRuntime.safePlayerName((Player)player), (Object)t);
            return -1;
        }
    }

    @Nullable
    private static Vec3 findFirst3x3x3PocketNear(@NotNull ServerLevel level, @NotNull ServerPlayer player, int cx, int baseY, int cz, int minY, int maxY) {
        try {
            if (baseY < minY || baseY > maxY - 2) {
                LOG.warn("[RavenCourierRuntime] findFirst3x3x3PocketNear: baseY out of bounds for 3-high pocket. baseY={} minY={} maxY={} player='{}'", new Object[]{baseY, minY, maxY, RavenCourierRuntime.safePlayerName((Player)player)});
                return null;
            }
            int maxR = 4;
            for (int r = 0; r <= 4; ++r) {
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        int tz;
                        int tx;
                        if (r > 0 && Math.abs(dx) != r && Math.abs(dz) != r || !RavenCourierRuntime.is3x3x3Air(level, tx = cx + dx, baseY, tz = cz + dz)) continue;
                        Vec3 pocket = new Vec3((double)tx + 0.5, (double)baseY + 0.1, (double)tz + 0.5);
                        LOG.info("[RavenCourierRuntime] findFirst3x3x3PocketNear: FOUND pocket={} baseY={} off=({}, {}) player='{}'", new Object[]{pocket, baseY, dx, dz, RavenCourierRuntime.safePlayerName((Player)player)});
                        return pocket;
                    }
                }
            }
            LOG.info("[RavenCourierRuntime] findFirst3x3x3PocketNear: NONE baseY={} center=({}, {}) radius={} player='{}'", new Object[]{baseY, cx, cz, 4, RavenCourierRuntime.safePlayerName((Player)player)});
            return null;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] findFirst3x3x3PocketNear failed safely", t);
            return null;
        }
    }

    private static boolean is3x3x3Air(@NotNull ServerLevel level, int cx, int cy, int cz) {
        try {
            for (int dy = 0; dy <= 2; ++dy) {
                int y = cy + dy;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos pos = new BlockPos(cx + dx, y, cz + dz);
                        if (level.isEmptyBlock(pos)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] is3x3x3Air failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    private static boolean canSimulatePathToPlayer(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull Vec3 spawnPos, @NotNull RavenEntity simRaven, long jobId, @NotNull String reasonTag) {
        try {
            boolean ok;
            long seed;
            try {
                simRaven.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, player.getYRot(), 0.0f);
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] canSimulatePathToPlayer: moveTo failed safely. player='{}' spawnPos={} jobId={} err={}", new Object[]{RavenCourierRuntime.safePlayerName((Player)player), spawnPos, jobId, t.toString()});
                return false;
            }
            Vec3 goal = player.position();
            try {
                seed = player.getUUID().getMostSignificantBits() ^ player.getUUID().getLeastSignificantBits() ^ level.getGameTime() ^ jobId ^ 0xFFFFFFFFC0092813L;
            }
            catch (Throwable t) {
                seed = level.getGameTime() ^ jobId ^ 0xFFFFFFFFC0092813L;
            }
            try {
                ok = simRaven.simulateAStarPathTo(goal, 120, seed, "courier(" + jobId + "): " + reasonTag);
            }
            catch (Throwable t) {
                ok = false;
                LOG.warn("[RavenCourierRuntime] canSimulatePathToPlayer: simulateAStarPathTo threw. player='{}' spawnPos={} goal={} jobId={} err={}", new Object[]{RavenCourierRuntime.safePlayerName((Player)player), spawnPos, goal, jobId, t.toString()});
            }
            if (ok) {
                LOG.info("[RavenCourierRuntime] canSimulatePathToPlayer: A* simulation OK player='{}' spawnPos={} goal={} jobId={}", new Object[]{RavenCourierRuntime.safePlayerName((Player)player), spawnPos, goal, jobId});
            } else {
                LOG.info("[RavenCourierRuntime] canSimulatePathToPlayer: A* simulation FAIL player='{}' spawnPos={} goal={} jobId={}", new Object[]{RavenCourierRuntime.safePlayerName((Player)player), spawnPos, goal, jobId});
            }
            return ok;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] canSimulatePathToPlayer failed safely (jobId={})", (Object)jobId, (Object)t);
            return false;
        }
    }

    private static void onEntityInteract(@NotNull PlayerInteractEvent.EntityInteract event) {
        try {
            ServerLevel serverLevel;
            block12: {
                block11: {
                    Level level = event.getLevel();
                    if (!(level instanceof ServerLevel)) break block11;
                    serverLevel = (ServerLevel)level;
                    if (!level.isClientSide()) break block12;
                }
                return;
            }
            Entity target = event.getTarget();
            if (!(target instanceof RavenEntity)) {
                return;
            }
            RavenEntity raven = (RavenEntity)target;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!RavenCourierRuntime.isCourierRaven(raven)) {
                return;
            }
            long jobId = RavenCourierRuntime.getCourierJobIdFromRaven(raven);
            if (jobId <= 0L) {
                LOG.warn("[RavenCourierRuntime] onEntityInteract: courier raven id={} has no valid CourierJobId; ignoring.", (Object)raven.getId());
                return;
            }
            RavenCourierData data = RavenCourierData.get(serverLevel);
            RavenCourierData.DeliveryJob job = data.getJobById(jobId);
            if (job == null) {
                LOG.warn("[RavenCourierRuntime] onEntityInteract: no job found for CourierJobId={} (raven id={})", (Object)jobId, (Object)raven.getId());
                RavenCourierRuntime.despawnCourierRaven(serverLevel, serverPlayer, raven, "orphaned courier (no job)");
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            boolean delivered = RavenCourierRuntime.giveSealedScrollToPlayerFromJob(serverLevel, serverPlayer, job);
            if (!delivered) {
                event.setCancellationResult(InteractionResult.PASS);
                return;
            }
            data.removeJob(job.jobId, job.recipientUuid);
            RavenCourierRuntime.despawnCourierRaven(serverLevel, serverPlayer, raven, "delivery complete: scroll retrieved");
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] onEntityInteract failed safely", t);
        }
    }

    private static boolean isCourierRaven(@NotNull RavenEntity raven) {
        try {
            if (raven.getTags().contains(TAG_COURIER_RAVEN)) {
                return true;
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] isCourierRaven: tag check failed for id={}: {}", (Object)raven.getId(), (Object)t.toString());
        }
        try {
            CompoundTag root = raven.getPersistentData();
            if (root == null) {
                return false;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            return ffTag != null && ffTag.getBoolean("CourierActive");
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] isCourierRaven: NBT check failed for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            return false;
        }
    }

    private static long getCourierJobIdFromRaven(@NotNull RavenEntity raven) {
        try {
            CompoundTag root = raven.getPersistentData();
            if (root == null) {
                return -1L;
            }
            CompoundTag ffTag = root.getCompound("featheredfriend");
            if (ffTag == null || !ffTag.contains("CourierJobId", 4)) {
                return -1L;
            }
            return ffTag.getLong("CourierJobId");
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] getCourierJobIdFromRaven failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
            return -1L;
        }
    }

    @NotNull
    private static ItemStack buildDeliveredScrollStack(@NotNull Item sealedScrollItem, @NotNull RavenCourierData.DeliveryJob job, @Nullable String deliveredName, @Nullable UUID deliveredUuid, boolean successfulDelivery) {
        ItemStack stack = new ItemStack((ItemLike)sealedScrollItem);
        try {
            CompoundTag sealedCopy = job.sealedScrollNbt == null ? new CompoundTag() : job.sealedScrollNbt.copy();
            int successCount = 0;
            int failedCount = 0;
            try {
                if (sealedCopy.contains("SuccessfulDeliveries", 3)) {
                    successCount = sealedCopy.getInt("SuccessfulDeliveries");
                }
                if (sealedCopy.contains("FailedDeliveries", 3)) {
                    failedCount = sealedCopy.getInt("FailedDeliveries");
                }
            }
            catch (Throwable counterReadErr) {
                LOG.warn("[RavenCourierRuntime] buildDeliveredScrollStack: failed to read existing delivery counters for jobId={}: {}", (Object)job.jobId, (Object)counterReadErr.toString());
            }
            if (successfulDelivery) {
                ++successCount;
            } else {
                ++failedCount;
            }
            sealedCopy.putInt("SuccessfulDeliveries", successCount);
            sealedCopy.putInt("FailedDeliveries", failedCount);
            String dName = deliveredName == null ? "" : deliveredName;
            String dUuidStr = deliveredUuid == null ? "" : deliveredUuid.toString();
            boolean unknown = dName.isEmpty();
            boolean hasFirst = false;
            try {
                String firstName = sealedCopy.getString("FirstDeliveredToName");
                String firstUuid = sealedCopy.getString("FirstDeliveredToUUID");
                boolean firstUnknown = sealedCopy.getBoolean("FirstDeliveredToUnknown");
                hasFirst = !firstName.isEmpty() || !firstUuid.isEmpty() || firstUnknown;
            }
            catch (Throwable firstReadErr) {
                LOG.warn("[RavenCourierRuntime] buildDeliveredScrollStack: failed to read FirstDelivered* for jobId={}: {}", (Object)job.jobId, (Object)firstReadErr.toString());
            }
            if (!hasFirst) {
                sealedCopy.putString("FirstDeliveredToName", dName);
                sealedCopy.putString("FirstDeliveredToUUID", dUuidStr);
                sealedCopy.putBoolean("FirstDeliveredToUnknown", unknown);
            }
            sealedCopy.putString("LastDeliveredToName", dName);
            sealedCopy.putString("LastDeliveredToUUID", dUuidStr);
            sealedCopy.putBoolean("LastDeliveredToUnknown", unknown);
            sealedCopy.putString("DeliveredToName", dName);
            sealedCopy.putString("DeliveredToUUID", dUuidStr);
            sealedCopy.putBoolean("DeliveredToUnknown", unknown);
            CompoundTag customRoot = new CompoundTag();
            customRoot.put("SealedScroll", (Tag)sealedCopy);
            CustomData customData = CustomData.of((CompoundTag)customRoot);
            stack.set(DataComponents.CUSTOM_DATA, (Object)customData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[RavenCourierRuntime] buildDeliveredScrollStack: jobId={} success={} first='{}' last='{}' succCnt={} failCnt={}", new Object[]{job.jobId, successfulDelivery, sealedCopy.getString("FirstDeliveredToName"), sealedCopy.getString("LastDeliveredToName"), successCount, failedCount});
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] buildDeliveredScrollStack failed safely for jobId={}: {}", (Object)job.jobId, (Object)t.toString());
        }
        return stack;
    }

    private static boolean giveSealedScrollToPlayerFromJob(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            boolean handled;
            Item sealedScrollItem = (Item)BuiltInRegistries.ITEM.get(SEALED_SCROLL_ID);
            if (sealedScrollItem == null) {
                LOG.error("[RavenCourierRuntime] giveSealedScrollToPlayerFromJob: sealed scroll item not found (id={})", (Object)SEALED_SCROLL_ID);
                return false;
            }
            boolean hasSpace = RavenCourierRuntime.hasEmptyInventorySlot(player);
            ItemStack stack = RavenCourierRuntime.buildDeliveredScrollStack(sealedScrollItem, job, RavenCourierRuntime.safePlayerName((Player)player), player.getUUID(), hasSpace);
            if (hasSpace) {
                handled = RavenCourierRuntime.insertIntoFirstEmptySlot(player, stack);
                if (!handled) {
                    LOG.warn("[RavenCourierRuntime] giveSealedScrollToPlayerFromJob: insertion failed despite hasSpace=true for player='{}'; dropping instead.", (Object)RavenCourierRuntime.safePlayerName((Player)player));
                    handled = true;
                    player.drop(stack, false);
                }
            } else {
                handled = true;
                player.drop(stack, false);
            }
            if (!handled) {
                LOG.warn("[RavenCourierRuntime] giveSealedScrollToPlayerFromJob: scroll not handled for player='{}' (jobId={})", (Object)RavenCourierRuntime.safePlayerName((Player)player), (Object)job.jobId);
                return false;
            }
            String senderName = job.senderName == null ? "" : job.senderName;
            String recipientName = job.recipientName == null ? "" : job.recipientName;
            MutableComponent msg = Component.literal((String)("[FeatheredFriend] You retrieved a sealed scroll" + (String)(senderName.isEmpty() ? "" : " from " + senderName) + (String)(recipientName.isEmpty() ? "" : " addressed to " + recipientName) + (hasSpace ? "." : " (your inventory was full, so it was dropped nearby).")));
            player.sendSystemMessage((Component)msg);
            LOG.info("[RavenCourierRuntime] giveSealedScrollToPlayerFromJob: {} delivery of sealed scroll for jobId={} to player='{}'", new Object[]{hasSpace ? "successful" : "failed (dropped)", job.jobId, RavenCourierRuntime.safePlayerName((Player)player)});
            return true;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] giveSealedScrollToPlayerFromJob failed safely for jobId={}", (Object)job.jobId, (Object)t);
            return false;
        }
    }

    private static void onRavenDeath(@NotNull LivingDeathEvent event) {
        try {
            ServerLevel serverLevel;
            RavenEntity raven;
            block10: {
                block9: {
                    LivingEntity living = event.getEntity();
                    if (!(living instanceof RavenEntity)) {
                        return;
                    }
                    raven = (RavenEntity)living;
                    Level level = raven.level();
                    if (!(level instanceof ServerLevel)) break block9;
                    serverLevel = (ServerLevel)level;
                    if (!level.isClientSide()) break block10;
                }
                return;
            }
            if (!RavenCourierRuntime.isCourierRaven(raven)) {
                return;
            }
            long jobId = RavenCourierRuntime.getCourierJobIdFromRaven(raven);
            if (jobId <= 0L) {
                LOG.warn("[RavenCourierRuntime] onRavenDeath: courier raven id={} has no valid CourierJobId; dropping nothing.", (Object)raven.getId());
                return;
            }
            RavenCourierData data = RavenCourierData.get(serverLevel);
            RavenCourierData.DeliveryJob job = data.getJobById(jobId);
            if (job == null) {
                LOG.warn("[RavenCourierRuntime] onRavenDeath: no job found for CourierJobId={} (raven id={})", (Object)jobId, (Object)raven.getId());
                return;
            }
            RavenCourierRuntime.dropSealedScrollAtRaven(serverLevel, raven, job);
            RavenCourierRuntime.notifySenderOfRavenDeath(serverLevel, raven, job);
            data.removeJob(job.jobId, job.recipientUuid);
            RavenCourierRuntime.clearCourierFlags(raven);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] onRavenDeath failed safely", t);
        }
    }

    private static void dropSealedScrollAtRaven(@NotNull ServerLevel level, @NotNull RavenEntity raven, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            Item sealedScrollItem = (Item)BuiltInRegistries.ITEM.get(SEALED_SCROLL_ID);
            if (sealedScrollItem == null) {
                LOG.error("[RavenCourierRuntime] dropSealedScrollAtRaven: sealed scroll item not found (id={})", (Object)SEALED_SCROLL_ID);
                return;
            }
            ItemStack stack = RavenCourierRuntime.buildDeliveredScrollStack(sealedScrollItem, job, null, null, false);
            raven.spawnAtLocation(stack, 0.2f);
            LOG.info("[RavenCourierRuntime] dropSealedScrollAtRaven: dropped sealed scroll for jobId={} at pos={}", (Object)job.jobId, (Object)raven.position());
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] dropSealedScrollAtRaven failed safely for jobId={}", (Object)job.jobId, (Object)t);
        }
    }

    private static boolean hasEmptyInventorySlot(@NotNull ServerPlayer player) {
        try {
            int size = player.getInventory().getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack existing = player.getInventory().getItem(i);
                if (existing != null && !existing.isEmpty()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[RavenCourierRuntime] hasEmptyInventorySlot: found empty slot {} for player='{}'", (Object)i, (Object)RavenCourierRuntime.safePlayerName((Player)player));
                }
                return true;
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] hasEmptyInventorySlot failed safely for player='{}': {}", (Object)RavenCourierRuntime.safePlayerName((Player)player), (Object)t.toString());
        }
        return false;
    }

    private static boolean insertIntoFirstEmptySlot(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        try {
            if (stack.isEmpty()) {
                return false;
            }
            int size = player.getInventory().getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack existing = player.getInventory().getItem(i);
                if (existing != null && !existing.isEmpty()) continue;
                player.getInventory().setItem(i, stack);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[RavenCourierRuntime] insertIntoFirstEmptySlot: placed scroll in slot {} for player='{}'", (Object)i, (Object)RavenCourierRuntime.safePlayerName((Player)player));
                }
                return true;
            }
            LOG.warn("[RavenCourierRuntime] insertIntoFirstEmptySlot: no empty slot found for player='{}' despite hasEmptyInventorySlot=true", (Object)RavenCourierRuntime.safePlayerName((Player)player));
            return false;
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] insertIntoFirstEmptySlot failed safely for player='{}': {}", (Object)RavenCourierRuntime.safePlayerName((Player)player), (Object)t.toString());
            return false;
        }
    }

    private static void notifySenderOfRavenDeath(@NotNull ServerLevel anyLevel, @NotNull RavenEntity raven, @NotNull RavenCourierData.DeliveryJob job) {
        try {
            MinecraftServer server = anyLevel.getServer();
            if (server == null) {
                return;
            }
            if (job.senderUuid == null) {
                return;
            }
            ServerPlayer sender = server.getPlayerList().getPlayer(job.senderUuid);
            if (sender == null) {
                return;
            }
            String ravenName = "<your raven>";
            try {
                String n;
                if (raven.getCustomName() != null && (n = raven.getCustomName().getString()) != null && !n.isEmpty()) {
                    ravenName = n;
                }
            }
            catch (Throwable n) {
                // empty catch block
            }
            String recipientPart = job.recipientName == null || job.recipientName.isEmpty() ? "" : " while delivering a scroll to " + job.recipientName;
            MutableComponent msg = Component.literal((String)("[FeatheredFriend] Your raven, " + ravenName + ", has perished" + recipientPart + ". The scroll was dropped where it fell."));
            sender.sendSystemMessage((Component)msg);
            LOG.info("[RavenCourierRuntime] notifySenderOfRavenDeath: notified sender='{}' of raven death (jobId={})", (Object)RavenCourierRuntime.safePlayerName((Player)sender), (Object)job.jobId);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] notifySenderOfRavenDeath failed safely for jobId={}", (Object)job.jobId, (Object)t);
        }
    }

    private static void clearCourierFlags(@NotNull RavenEntity raven) {
        try {
            if (raven.getTags().contains(TAG_COURIER_RAVEN)) {
                raven.removeTag(TAG_COURIER_RAVEN);
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] clearCourierFlags: removeTag({}) failed safely for id={}: {}", new Object[]{TAG_COURIER_RAVEN, raven.getId(), t.toString()});
        }
        try {
            CompoundTag ffTag;
            CompoundTag root = raven.getPersistentData();
            if (root != null && (ffTag = root.getCompound("featheredfriend")) != null && !ffTag.isEmpty()) {
                ffTag.remove("CourierActive");
                ffTag.remove("CourierJobId");
                ffTag.remove("CourierSenderUUID");
                ffTag.remove("CourierRecipientUUID");
                ffTag.remove(NBT_COURIER_DESPAWN_AT);
                root.put("featheredfriend", (Tag)ffTag);
            }
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] clearCourierFlags: NBT cleanup failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
        }
    }

    private static void despawnCourierRaven(@NotNull ServerLevel level, @NotNull ServerPlayer contextPlayer, @NotNull RavenEntity raven, @NotNull String reason) {
        try {
            TamedRaven tamedModule = null;
            try {
                tamedModule = raven.getTamedRavenModule();
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierRuntime] despawnCourierRaven: getTamedRavenModule failed safely: {}", (Object)t.toString());
            }
            String ravenName = "<unnamed>";
            try {
                if (raven.getCustomName() != null) {
                    ravenName = raven.getCustomName().getString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Vec3 fxPos = raven.position().add(0.0, 0.6, 0.0);
                long fxSeed = raven.getUUID().getLeastSignificantBits() ^ (long)raven.tickCount ^ 0x9F42C3B1L;
                Teleportation teleportFx = new Teleportation(raven);
                teleportFx.spawnEnderpopBurst(level, fxPos.x, fxPos.y, fxPos.z, fxSeed, "courier-despawn: " + reason, raven);
            }
            catch (Throwable fxErr) {
                LOG.warn("[RavenCourierRuntime] despawnCourierRaven: Teleportation FX failed safely for id={}: {}", (Object)raven.getId(), (Object)fxErr.toString());
            }
            if (tamedModule != null) {
                try {
                    tamedModule.beginDespawnWithFx(level, contextPlayer, ravenName);
                    LOG.info("[RavenCourierRuntime] despawnCourierRaven: triggered despawn FX for id={} name='{}' player='{}' reason={}", new Object[]{raven.getId(), ravenName, RavenCourierRuntime.safePlayerName((Player)contextPlayer), reason});
                }
                catch (Throwable t) {
                    LOG.error("[RavenCourierRuntime] despawnCourierRaven: beginDespawnWithFx failed; discarding raven directly. err={}", (Object)t.toString());
                    raven.discard();
                }
            } else {
                LOG.warn("[RavenCourierRuntime] despawnCourierRaven: TamedRaven module null; discarding raven without FX. player='{}' id={} reason={}", new Object[]{RavenCourierRuntime.safePlayerName((Player)contextPlayer), raven.getId(), reason});
                raven.discard();
            }
            RavenCourierRuntime.clearCourierFlags(raven);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierRuntime] despawnCourierRaven failed safely", t);
        }
    }

    private static void ensureRavenName(@NotNull RavenEntity raven, @NotNull String ravenName) {
        try {
            String curStr;
            Component cur = raven.getCustomName();
            String string = curStr = cur == null ? "" : cur.getString();
            if (!ravenName.equals(curStr)) {
                raven.setCustomName((Component)Component.literal((String)ravenName));
            }
            raven.setCustomNameVisible(true);
        }
        catch (Throwable t) {
            LOG.warn("[RavenCourierRuntime] ensureRavenName failed safely for id={}: {}", (Object)raven.getId(), (Object)t.toString());
        }
    }

    private static String safePlayerName(@NotNull Player player) {
        try {
            return player.getGameProfile().getName();
        }
        catch (Throwable ignored) {
            try {
                return player.getName().getString();
            }
            catch (Throwable ignored2) {
                return "<unknown>";
            }
        }
    }
}

