/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RavenCourierData
extends SavedData {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String DATA_NAME = "featheredfriend_raven_courier";
    private static final ResourceLocation SEALED_SCROLL_ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"scroll_sealed");
    private long nextJobId = 1L;
    private final Map<UUID, List<DeliveryJob>> jobsByRecipient = new HashMap<UUID, List<DeliveryJob>>();

    public static RavenCourierData create() {
        return new RavenCourierData();
    }

    public static RavenCourierData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        RavenCourierData data = new RavenCourierData();
        data.readFromNbt(tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        try {
            this.writeToNbt(tag);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] save failed safely: {}", (Object)t.toString());
        }
        return tag;
    }

    private void readFromNbt(@NotNull CompoundTag tag) {
        try {
            this.jobsByRecipient.clear();
            if (tag.contains("NextJobId", 4)) {
                this.nextJobId = tag.getLong("NextJobId");
                if (this.nextJobId <= 0L) {
                    this.nextJobId = 1L;
                }
            } else {
                this.nextJobId = 1L;
            }
            if (!tag.contains("Jobs", 9)) {
                return;
            }
            ListTag jobsList = tag.getList("Jobs", 10);
            for (int i = 0; i < jobsList.size(); ++i) {
                Tag element = jobsList.get(i);
                if (!(element instanceof CompoundTag)) continue;
                CompoundTag jobTag = (CompoundTag)element;
                try {
                    String lastFailureReason;
                    long jobId = jobTag.getLong("JobId");
                    UUID senderUuid = jobTag.hasUUID("SenderUUID") ? jobTag.getUUID("SenderUUID") : RavenCourierData.parseUuidSafe(jobTag.getString("SenderUUIDStr"));
                    String senderName = jobTag.getString("SenderName");
                    UUID recipientUuid = jobTag.hasUUID("RecipientUUID") ? jobTag.getUUID("RecipientUUID") : RavenCourierData.parseUuidSafe(jobTag.getString("RecipientUUIDStr"));
                    String recipientName = jobTag.getString("RecipientName");
                    CompoundTag sealedScrollNbt = jobTag.getCompound("SealedScroll");
                    String ravenName = jobTag.getString("RavenName");
                    if (ravenName == null) {
                        ravenName = "";
                    }
                    boolean inFlight = false;
                    boolean failed = jobTag.getBoolean("Failed");
                    int failureCount = jobTag.contains("FailureCount", 3) ? jobTag.getInt("FailureCount") : 0;
                    long lastFailureGameTime = jobTag.contains("LastFailureGameTime", 4) ? jobTag.getLong("LastFailureGameTime") : 0L;
                    String string = lastFailureReason = jobTag.contains("LastFailureReason", 8) ? jobTag.getString("LastFailureReason") : "";
                    if (senderUuid == null || recipientUuid == null || sealedScrollNbt.isEmpty()) {
                        LOG.warn("[RavenCourierData] Skipping malformed job entry at index {} (missing UUIDs or SealedScroll).", (Object)i);
                        continue;
                    }
                    DeliveryJob job = new DeliveryJob(jobId, senderUuid, senderName == null ? "" : senderName, recipientUuid, recipientName == null ? "" : recipientName, sealedScrollNbt.copy(), inFlight, ravenName, failed, Math.max(0, failureCount), Math.max(0L, lastFailureGameTime), lastFailureReason == null ? "" : lastFailureReason);
                    this.jobsByRecipient.computeIfAbsent(recipientUuid, k -> new ArrayList()).add(job);
                    if (jobId < this.nextJobId) continue;
                    this.nextJobId = jobId + 1L;
                    continue;
                }
                catch (Throwable jobErr) {
                    LOG.warn("[RavenCourierData] Failed to read job entry at index {}: {}", (Object)i, (Object)jobErr.toString());
                }
            }
            LOG.info("[RavenCourierData] Loaded {} recipients with pending jobs (nextJobId={})", (Object)this.jobsByRecipient.size(), (Object)this.nextJobId);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] readFromNbt failed safely: {}", (Object)t.toString());
            this.jobsByRecipient.clear();
            this.nextJobId = 1L;
        }
    }

    private void writeToNbt(@NotNull CompoundTag tag) {
        try {
            tag.putLong("NextJobId", this.nextJobId);
            ListTag jobsList = new ListTag();
            for (Map.Entry<UUID, List<DeliveryJob>> entry : this.jobsByRecipient.entrySet()) {
                UUID recipientUuid = entry.getKey();
                List<DeliveryJob> jobs = entry.getValue();
                if (jobs == null || jobs.isEmpty()) continue;
                for (DeliveryJob job : jobs) {
                    if (job == null) continue;
                    CompoundTag jobTag = new CompoundTag();
                    jobTag.putLong("JobId", job.jobId);
                    if (job.senderUuid != null) {
                        jobTag.putUUID("SenderUUID", job.senderUuid);
                        jobTag.putString("SenderUUIDStr", job.senderUuid.toString());
                    }
                    jobTag.putString("SenderName", job.senderName == null ? "" : job.senderName);
                    if (recipientUuid != null) {
                        jobTag.putUUID("RecipientUUID", recipientUuid);
                        jobTag.putString("RecipientUUIDStr", recipientUuid.toString());
                    }
                    jobTag.putString("RecipientName", job.recipientName == null ? "" : job.recipientName);
                    if (job.sealedScrollNbt != null) {
                        jobTag.put("SealedScroll", (Tag)job.sealedScrollNbt.copy());
                    }
                    jobTag.putBoolean("InFlight", job.inFlight);
                    jobTag.putString("RavenName", job.ravenName == null ? "" : job.ravenName);
                    jobTag.putBoolean("Failed", job.failed);
                    jobTag.putInt("FailureCount", Math.max(0, job.failureCount));
                    jobTag.putLong("LastFailureGameTime", Math.max(0L, job.lastFailureGameTime));
                    jobTag.putString("LastFailureReason", job.lastFailureReason == null ? "" : job.lastFailureReason);
                    jobsList.add((Object)jobTag);
                }
            }
            tag.put("Jobs", (Tag)jobsList);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] writeToNbt failed safely: {}", (Object)t.toString());
        }
    }

    @Nullable
    private static UUID parseUuidSafe(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @NotNull
    public static RavenCourierData get(@NotNull ServerLevel level) {
        try {
            ServerLevel overworld = level.getServer().overworld();
            if (overworld == null) {
                overworld = level;
            }
            DimensionDataStorage storage = overworld.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(RavenCourierData::create, RavenCourierData::load);
            return (RavenCourierData)storage.computeIfAbsent(factory, DATA_NAME);
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] get(...) failed safely, returning empty volatile instance: {}", (Object)t.toString());
            return new RavenCourierData();
        }
    }

    @Nullable
    public DeliveryJob createJobFromSealedScroll(@NotNull ServerPlayer sender, @NotNull RavenEntity raven, @NotNull ItemStack scrollStack) {
        try {
            String ravenName;
            UUID recipientUuid;
            if (scrollStack.isEmpty()) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: stack is empty for player='{}'.", (Object)sender.getGameProfile().getName());
                return null;
            }
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)scrollStack.getItem());
            if (key == null || !SEALED_SCROLL_ID.equals((Object)key)) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: item is not a sealed scroll (key={} player='{}').", (Object)key, (Object)sender.getGameProfile().getName());
                return null;
            }
            CustomData customData = (CustomData)scrollStack.get(DataComponents.CUSTOM_DATA);
            if (customData == null) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: CUSTOM_DATA missing on sealed scroll (player='{}').", (Object)sender.getGameProfile().getName());
                return null;
            }
            CompoundTag customRoot = customData.getUnsafe();
            if (customRoot == null || !customRoot.contains("SealedScroll", 10)) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: SealedScroll compound missing in CUSTOM_DATA (player='{}').", (Object)sender.getGameProfile().getName());
                return null;
            }
            CompoundTag sealed = customRoot.getCompound("SealedScroll");
            if (sealed.isEmpty()) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: SealedScroll compound empty (player='{}').", (Object)sender.getGameProfile().getName());
                return null;
            }
            String recipientUuidStr = sealed.getString("RecipientUUID");
            if (recipientUuidStr == null || recipientUuidStr.isEmpty()) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: RecipientUUID missing in SealedScroll (player='{}').", (Object)sender.getGameProfile().getName());
                return null;
            }
            try {
                recipientUuid = UUID.fromString(recipientUuidStr);
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: RecipientUUID malformed '{}' (player='{}').", (Object)recipientUuidStr, (Object)sender.getGameProfile().getName());
                return null;
            }
            String recipientName = sealed.getString("RecipientName");
            if (recipientName == null) {
                recipientName = "";
            }
            UUID senderUuid = sender.getUUID();
            String senderName = sender.getGameProfile().getName();
            try {
                String n;
                ravenName = raven.getCustomName() != null ? ((n = raven.getCustomName().getString()) != null && !n.isEmpty() ? n : "Raven") : "Raven";
            }
            catch (Throwable t) {
                LOG.warn("[RavenCourierData] createJobFromSealedScroll: failed to read raven custom name for raven id={}: {}", (Object)raven.getId(), (Object)t.toString());
                ravenName = "Raven";
            }
            long jobId = this.nextJobId++;
            if (jobId <= 0L) {
                jobId = 1L;
                this.nextJobId = 2L;
            }
            DeliveryJob job = new DeliveryJob(jobId, senderUuid, senderName == null ? "" : senderName, recipientUuid, recipientName, sealed.copy(), false, ravenName, false, 0, 0L, "");
            this.jobsByRecipient.computeIfAbsent(recipientUuid, k -> new ArrayList()).add(job);
            this.setDirty();
            LOG.info("[RavenCourierData] Created delivery job id={} (sender='{}' [{}], recipient='{}' [{}], ravenId={} ravenName='{}')", new Object[]{jobId, senderName, senderUuid, recipientName, recipientUuid, raven.getId(), ravenName});
            return job;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] createJobFromSealedScroll failed safely: {}", (Object)t.toString());
            return null;
        }
    }

    public boolean markJobFailed(long jobId, @NotNull UUID recipientUuid, @NotNull String reason, long gameTime) {
        try {
            DeliveryJob job = this.getJobById(jobId);
            if (job == null) {
                LOG.warn("[RavenCourierData] markJobFailed: jobId={} not found", (Object)jobId);
                return false;
            }
            if (!recipientUuid.equals(job.recipientUuid)) {
                LOG.warn("[RavenCourierData] markJobFailed: recipient mismatch for jobId={} expected={} got={}", new Object[]{jobId, job.recipientUuid, recipientUuid});
                return false;
            }
            job.failed = true;
            job.inFlight = false;
            job.failureCount = Math.max(0, job.failureCount) + 1;
            job.lastFailureGameTime = Math.max(0L, gameTime);
            job.lastFailureReason = reason == null ? "" : reason;
            this.setDirty();
            LOG.info("[RavenCourierData] markJobFailed: jobId={} recipient={} reason='{}' failureCount={}", new Object[]{jobId, recipientUuid, job.lastFailureReason, job.failureCount});
            return true;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] markJobFailed failed safely (jobId={}): {}", (Object)jobId, (Object)t.toString());
            return false;
        }
    }

    public boolean clearFailedForRetry(long jobId, @NotNull UUID senderUuid) {
        try {
            DeliveryJob job = this.getJobById(jobId);
            if (job == null) {
                LOG.warn("[RavenCourierData] clearFailedForRetry: jobId={} not found", (Object)jobId);
                return false;
            }
            if (job.senderUuid == null || !senderUuid.equals(job.senderUuid)) {
                LOG.warn("[RavenCourierData] clearFailedForRetry: sender mismatch for jobId={} expected={} got={}", new Object[]{jobId, job.senderUuid, senderUuid});
                return false;
            }
            if (!job.failed) {
                LOG.warn("[RavenCourierData] clearFailedForRetry: jobId={} is not failed; nothing to retry", (Object)jobId);
                return false;
            }
            if (job.inFlight) {
                LOG.warn("[RavenCourierData] clearFailedForRetry: jobId={} is inFlight; cannot retry while active", (Object)jobId);
                return false;
            }
            job.failed = false;
            job.lastFailureReason = "";
            job.lastFailureGameTime = 0L;
            this.setDirty();
            LOG.info("[RavenCourierData] clearFailedForRetry: cleared failed state for jobId={} sender={}", (Object)jobId, (Object)senderUuid);
            return true;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] clearFailedForRetry failed safely (jobId={}): {}", (Object)jobId, (Object)t.toString());
            return false;
        }
    }

    @NotNull
    public List<DeliveryJob> getJobsForRecipient(@NotNull UUID recipientUuid) {
        List<DeliveryJob> list = this.jobsByRecipient.get(recipientUuid);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(list);
    }

    @NotNull
    public List<DeliveryJob> getAllJobsFlat() {
        ArrayList<DeliveryJob> out = new ArrayList<DeliveryJob>();
        for (List<DeliveryJob> list : this.jobsByRecipient.values()) {
            if (list == null || list.isEmpty()) continue;
            out.addAll(list);
        }
        return List.copyOf(out);
    }

    @NotNull
    public List<DeliveryJob> getJobsForPlayer(@NotNull UUID playerUuid) {
        ArrayList<DeliveryJob> out = new ArrayList<DeliveryJob>();
        for (List<DeliveryJob> list : this.jobsByRecipient.values()) {
            if (list == null || list.isEmpty()) continue;
            for (DeliveryJob job : list) {
                if (job == null || !playerUuid.equals(job.senderUuid) && !playerUuid.equals(job.recipientUuid)) continue;
                out.add(job);
            }
        }
        return List.copyOf(out);
    }

    public void removeJob(long jobId, @NotNull UUID recipientUuid) {
        try {
            List<DeliveryJob> list = this.jobsByRecipient.get(recipientUuid);
            if (list == null || list.isEmpty()) {
                return;
            }
            boolean removed = list.removeIf(job -> job != null && job.jobId == jobId);
            if (removed) {
                if (list.isEmpty()) {
                    this.jobsByRecipient.remove(recipientUuid);
                }
                this.setDirty();
                LOG.info("[RavenCourierData] Removed job id={} for recipient={}", (Object)jobId, (Object)recipientUuid);
            }
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] removeJob failed safely: {}", (Object)t.toString());
        }
    }

    public boolean hasOpenJobsAsSender(@NotNull UUID senderUuid) {
        try {
            if (this.jobsByRecipient.isEmpty()) {
                return false;
            }
            for (List<DeliveryJob> jobs : this.jobsByRecipient.values()) {
                if (jobs == null || jobs.isEmpty()) continue;
                for (DeliveryJob job : jobs) {
                    if (job == null || !senderUuid.equals(job.senderUuid)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] hasOpenJobsAsSender failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    public int clearAllJobs() {
        try {
            int count = 0;
            for (List<DeliveryJob> list : this.jobsByRecipient.values()) {
                if (list == null) continue;
                count += list.size();
            }
            this.jobsByRecipient.clear();
            if (count > 0) {
                this.setDirty();
            }
            LOG.info("[RavenCourierData] clearAllJobs: removed {} job(s).", (Object)count);
            return count;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] clearAllJobs failed safely: {}", (Object)t.toString());
            return 0;
        }
    }

    public int clearJobsForPlayer(@NotNull UUID playerUuid) {
        try {
            int removed = 0;
            Iterator<Map.Entry<UUID, List<DeliveryJob>>> it = this.jobsByRecipient.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, List<DeliveryJob>> entry = it.next();
                List<DeliveryJob> list = entry.getValue();
                if (list == null || list.isEmpty()) continue;
                int before = list.size();
                list.removeIf(job -> job != null && (playerUuid.equals(job.senderUuid) || playerUuid.equals(job.recipientUuid)));
                int after = list.size();
                removed += before - after;
                if (!list.isEmpty()) continue;
                it.remove();
            }
            if (removed > 0) {
                this.setDirty();
            }
            LOG.info("[RavenCourierData] clearJobsForPlayer: removed {} job(s) for player={}", (Object)removed, (Object)playerUuid);
            return removed;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] clearJobsForPlayer failed safely: {}", (Object)t.toString());
            return 0;
        }
    }

    @Nullable
    public DeliveryJob getJobById(long jobId) {
        try {
            if (this.jobsByRecipient.isEmpty()) {
                return null;
            }
            for (List<DeliveryJob> list : this.jobsByRecipient.values()) {
                if (list == null || list.isEmpty()) continue;
                for (DeliveryJob job : list) {
                    if (job == null || job.jobId != jobId) continue;
                    return job;
                }
            }
            return null;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] getJobById failed safely: {}", (Object)t.toString());
            return null;
        }
    }

    public boolean hasFailedJobsAsSender(@NotNull UUID senderUuid) {
        try {
            if (this.jobsByRecipient.isEmpty()) {
                return false;
            }
            for (List<DeliveryJob> jobs : this.jobsByRecipient.values()) {
                if (jobs == null || jobs.isEmpty()) continue;
                for (DeliveryJob job : jobs) {
                    if (job == null || !senderUuid.equals(job.senderUuid) || !job.failed) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] hasFailedJobsAsSender failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    public boolean hasActiveNonFailedJobsAsSender(@NotNull UUID senderUuid) {
        try {
            if (this.jobsByRecipient.isEmpty()) {
                return false;
            }
            for (List<DeliveryJob> jobs : this.jobsByRecipient.values()) {
                if (jobs == null || jobs.isEmpty()) continue;
                for (DeliveryJob job : jobs) {
                    if (job == null || !senderUuid.equals(job.senderUuid) || job.failed) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] hasActiveNonFailedJobsAsSender failed safely: {}", (Object)t.toString());
            return false;
        }
    }

    @Nullable
    public DeliveryJob getMostRecentFailedJobForSender(@NotNull UUID senderUuid) {
        try {
            DeliveryJob best = null;
            if (this.jobsByRecipient.isEmpty()) {
                return null;
            }
            for (List<DeliveryJob> jobs : this.jobsByRecipient.values()) {
                if (jobs == null || jobs.isEmpty()) continue;
                for (DeliveryJob job : jobs) {
                    int fb;
                    long b;
                    if (job == null || !senderUuid.equals(job.senderUuid) || !job.failed) continue;
                    if (best == null) {
                        best = job;
                        continue;
                    }
                    long a = Math.max(0L, job.lastFailureGameTime);
                    if (a > (b = Math.max(0L, best.lastFailureGameTime))) {
                        best = job;
                        continue;
                    }
                    if (a != b) continue;
                    int fa = Math.max(0, job.failureCount);
                    if (fa > (fb = Math.max(0, best.failureCount))) {
                        best = job;
                        continue;
                    }
                    if (fa != fb || job.jobId <= best.jobId) continue;
                    best = job;
                }
            }
            return best;
        }
        catch (Throwable t) {
            LOG.error("[RavenCourierData] getMostRecentFailedJobForSender failed safely: {}", (Object)t.toString());
            return null;
        }
    }

    public static final class DeliveryJob {
        public final long jobId;
        public final UUID senderUuid;
        public final String senderName;
        public final UUID recipientUuid;
        public final String recipientName;
        public final CompoundTag sealedScrollNbt;
        public final String ravenName;
        public boolean inFlight;
        public boolean failed;
        public int failureCount;
        public long lastFailureGameTime;
        public String lastFailureReason;

        public DeliveryJob(long jobId, @NotNull UUID senderUuid, @NotNull String senderName, @NotNull UUID recipientUuid, @NotNull String recipientName, @NotNull CompoundTag sealedScrollNbt, boolean inFlight, @NotNull String ravenName, boolean failed, int failureCount, long lastFailureGameTime, @NotNull String lastFailureReason) {
            this.jobId = jobId;
            this.senderUuid = senderUuid;
            this.senderName = senderName;
            this.recipientUuid = recipientUuid;
            this.recipientName = recipientName;
            this.sealedScrollNbt = sealedScrollNbt;
            this.inFlight = inFlight;
            this.ravenName = ravenName;
            this.failed = failed;
            this.failureCount = failureCount;
            this.lastFailureGameTime = lastFailureGameTime;
            this.lastFailureReason = lastFailureReason;
        }
    }
}

