/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.world;

import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.z2six.featheredfriend.config.FFCalendarConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FeatheredFriendSettingsData
extends SavedData {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String DATA_NAME = "featheredfriend_settings";
    private static final String KEY_AUTO_SUMMON = "AutoSummonOnScroll";
    private static final String KEY_CHAT_DISABLED = "ChatDisabled";
    public static final boolean DEFAULT_AUTO_SUMMON = true;
    public static final boolean DEFAULT_CHAT_DISABLED = true;
    private boolean autoSummonOnScroll = true;
    private boolean chatDisabled = true;

    public static FeatheredFriendSettingsData create() {
        return new FeatheredFriendSettingsData();
    }

    public static FeatheredFriendSettingsData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        FeatheredFriendSettingsData data = new FeatheredFriendSettingsData();
        data.readFromNbt(tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        try {
            this.writeToNbt(tag);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] save failed safely: {}", (Object)t.toString());
        }
        return tag;
    }

    private void readFromNbt(@NotNull CompoundTag tag) {
        try {
            this.autoSummonOnScroll = tag.contains(KEY_AUTO_SUMMON, 1) ? tag.getBoolean(KEY_AUTO_SUMMON) : true;
            if (tag.contains(KEY_CHAT_DISABLED, 1)) {
                this.chatDisabled = tag.getBoolean(KEY_CHAT_DISABLED);
            } else {
                boolean cfgDefault = true;
                try {
                    cfgDefault = FFCalendarConfig.getChatDisabledDefault();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.chatDisabled = cfgDefault;
                LOG.info("[FeatheredFriendSettingsData] ChatDisabled missing in NBT; defaulting from config: {}", (Object)this.chatDisabled);
            }
            LOG.info("[FeatheredFriendSettingsData] Loaded settings: chatDisabled={}", (Object)this.chatDisabled);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] readFromNbt failed safely: {}", (Object)t.toString());
            this.autoSummonOnScroll = true;
            this.chatDisabled = true;
        }
    }

    private void writeToNbt(@NotNull CompoundTag tag) {
        try {
            tag.putBoolean(KEY_AUTO_SUMMON, this.autoSummonOnScroll);
            tag.putBoolean(KEY_CHAT_DISABLED, this.chatDisabled);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] writeToNbt failed safely: {}", (Object)t.toString());
        }
    }

    @NotNull
    public static FeatheredFriendSettingsData get(@NotNull ServerLevel level) {
        try {
            ServerLevel overworld = level.getServer().overworld();
            if (overworld == null) {
                overworld = level;
            }
            DimensionDataStorage storage = overworld.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(FeatheredFriendSettingsData::create, FeatheredFriendSettingsData::load);
            return (FeatheredFriendSettingsData)storage.computeIfAbsent(factory, DATA_NAME);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] get(...) failed safely, returning volatile defaults: {}", (Object)t.toString());
            return new FeatheredFriendSettingsData();
        }
    }

    public boolean isAutoSummonOnScrollEnabled() {
        return this.autoSummonOnScroll;
    }

    public boolean isChatDisabled() {
        return this.chatDisabled;
    }

    public void setAutoSummonOnScrollEnabled(boolean enabled) {
        try {
            if (this.autoSummonOnScroll == enabled) {
                return;
            }
            this.autoSummonOnScroll = enabled;
            this.setDirty();
            LOG.info("[FeatheredFriendSettingsData] (back-compat) autoSummonOnScroll set to {}", (Object)enabled);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] setAutoSummonOnScrollEnabled failed safely: {}", (Object)t.toString());
        }
    }

    public void setChatDisabled(boolean disabled) {
        try {
            if (this.chatDisabled == disabled) {
                return;
            }
            this.chatDisabled = disabled;
            this.setDirty();
            LOG.info("[FeatheredFriendSettingsData] chatDisabled set to {}", (Object)disabled);
        }
        catch (Throwable t) {
            LOG.error("[FeatheredFriendSettingsData] setChatDisabled failed safely: {}", (Object)t.toString());
        }
    }
}

