/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.util;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ScrollAttachmentNbtUtil {
    private static final Logger LOG = LogUtils.getLogger();
    public static final String ROOT_KEY = "SealedScroll";
    public static final String ATTACHMENTS_KEY = "Attachments";
    private static final String LEGACY_TAG_KEY = "tag";
    private static final String CUSTOM_DATA_KEY = "CustomData";

    private ScrollAttachmentNbtUtil() {
    }

    public static boolean hasAnyAttachments(@NotNull CompoundTag sealedScrollTag) {
        try {
            if (sealedScrollTag.isEmpty()) {
                return false;
            }
            if (!sealedScrollTag.contains(ATTACHMENTS_KEY, 9)) {
                return false;
            }
            ListTag list = sealedScrollTag.getList(ATTACHMENTS_KEY, 10);
            return list != null && !list.isEmpty();
        }
        catch (Throwable t) {
            LOG.error("[ScrollAttachmentNbtUtil] hasAnyAttachments failed", t);
            return false;
        }
    }

    @NotNull
    public static List<ItemStack> readAttachments(@NotNull CompoundTag sealedScrollTag, int max) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        try {
            if (max <= 0) {
                return out;
            }
            if (!sealedScrollTag.contains(ATTACHMENTS_KEY, 9)) {
                return out;
            }
            ListTag list = sealedScrollTag.getList(ATTACHMENTS_KEY, 10);
            if (list == null || list.isEmpty()) {
                return out;
            }
            int limit = Math.min(max, list.size());
            for (int i = 0; i < limit; ++i) {
                ResourceLocation id;
                Tag e = list.get(i);
                if (!(e instanceof CompoundTag)) continue;
                CompoundTag c = (CompoundTag)e;
                String idStr = "";
                try {
                    idStr = c.getString("id");
                }
                catch (Throwable ignored) {
                    idStr = "";
                }
                int count = 0;
                try {
                    count = c.getInt("Count");
                }
                catch (Throwable ignored) {
                    count = 0;
                }
                if (idStr == null || idStr.isBlank()) {
                    LOG.warn("[ScrollAttachmentNbtUtil] Missing item id in attachment index {}", (Object)i);
                    continue;
                }
                if (count <= 0) {
                    LOG.warn("[ScrollAttachmentNbtUtil] Invalid Count={} for attachment id='{}' index={}", new Object[]{count, idStr, i});
                    continue;
                }
                try {
                    id = ResourceLocation.tryParse((String)idStr);
                }
                catch (Throwable parseErr) {
                    LOG.warn("[ScrollAttachmentNbtUtil] Invalid item id '{}' in attachment index {}", (Object)idStr, (Object)i);
                    continue;
                }
                if (id == null) continue;
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                if (item == null || item == Items.AIR) {
                    LOG.warn("[ScrollAttachmentNbtUtil] Unknown/air item id '{}' in attachment index {}", (Object)id, (Object)i);
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)item, count);
                CompoundTag dataTag = null;
                try {
                    CompoundTag legacy;
                    if (c.contains(CUSTOM_DATA_KEY, 10)) {
                        CompoundTag cd = c.getCompound(CUSTOM_DATA_KEY);
                        if (cd != null && !cd.isEmpty()) {
                            dataTag = cd;
                        }
                    } else if (c.contains(LEGACY_TAG_KEY, 10) && (legacy = c.getCompound(LEGACY_TAG_KEY)) != null && !legacy.isEmpty()) {
                        dataTag = legacy;
                    }
                }
                catch (Throwable readDataErr) {
                    LOG.warn("[ScrollAttachmentNbtUtil] Failed reading optional data compound for {} at index {}", new Object[]{id, i, readDataErr});
                    dataTag = null;
                }
                if (dataTag != null && !dataTag.isEmpty()) {
                    try {
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag.copy()));
                    }
                    catch (Throwable applyErr) {
                        LOG.warn("[ScrollAttachmentNbtUtil] Failed applying CustomData component for {} at index {}", new Object[]{id, i, applyErr});
                    }
                }
                out.add(stack);
            }
        }
        catch (Throwable t) {
            LOG.error("[ScrollAttachmentNbtUtil] readAttachments failed", t);
        }
        return out;
    }

    public static void writeAttachments(@NotNull CompoundTag sealedScrollTag, @NotNull List<ItemStack> stacks) {
        try {
            ListTag list = new ListTag();
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack s = stacks.get(i);
                if (s == null || s.isEmpty()) continue;
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)s.getItem());
                if (id == null) {
                    LOG.warn("[ScrollAttachmentNbtUtil] writeAttachments: missing registry key for stack {}", (Object)s);
                    continue;
                }
                CompoundTag entry = new CompoundTag();
                entry.putString("id", id.toString());
                entry.putInt("Count", s.getCount());
                try {
                    CustomData cd = (CustomData)s.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                    CompoundTag tag = cd.copyTag();
                    if (tag != null && !tag.isEmpty()) {
                        entry.put(CUSTOM_DATA_KEY, (Tag)tag.copy());
                    }
                }
                catch (Throwable tagErr) {
                    LOG.warn("[ScrollAttachmentNbtUtil] writeAttachments: failed writing CustomData for {}", (Object)id, (Object)tagErr);
                }
                list.add((Object)entry);
            }
            sealedScrollTag.put(ATTACHMENTS_KEY, (Tag)list);
        }
        catch (Throwable t) {
            LOG.error("[ScrollAttachmentNbtUtil] writeAttachments failed", t);
        }
    }
}

