/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.sigil;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import net.minecraft.util.RandomSource;
import net.z2six.featheredfriend.sigil.SealSigilShapeSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class SealSigilShapeSetFloral2
implements SealSigilShapeSet {
    private static final Logger LOG = LogUtils.getLogger();
    private static final int MIN_MOTIF_PASSES = 1;
    private static final int MAX_MOTIF_PASSES = 3;
    private static final double BAND_INNER_FRACTION = 0.34;
    private static final double BAND_MID_FRACTION = 0.6;
    private static final double BAND_OUTER_FRACTION = 0.88;
    private static final double SLICE_ANGULAR_MARGIN = Math.toRadians(4.0);
    private static final int MIN_DETAIL_RADIUS = 1;

    @Override
    public void applyShapesInSlice(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, int slices, int sliceIndex, @NotNull RandomSource rng) {
        try {
            if (pixels == null || pixels.length == 0) {
                LOG.warn("[SealSigilShapeSetFloral2] applyShapesInSlice called with null/empty pixels");
                return;
            }
            if (slices <= 0) {
                LOG.warn("[SealSigilShapeSetFloral2] slices <= 0 ({}), nothing to do", (Object)slices);
                return;
            }
            if (sliceIndex < 0 || sliceIndex >= slices) {
                LOG.warn("[SealSigilShapeSetFloral2] sliceIndex {} out of [0, {}), aborting slice carving", (Object)sliceIndex, (Object)slices);
                return;
            }
            int size = pixels.length;
            double sliceAngleSpan = Math.PI * 2 / (double)slices;
            double sliceStart = (double)sliceIndex * sliceAngleSpan;
            double sliceEnd = sliceStart + sliceAngleSpan;
            if ((sliceEnd -= SLICE_ANGULAR_MARGIN) <= (sliceStart += SLICE_ANGULAR_MARGIN)) {
                LOG.debug("[SealSigilShapeSetFloral2] Degenerate slice after margin: start={} end={}", (Object)sliceStart, (Object)sliceEnd);
                return;
            }
            int passes = 1 + rng.nextInt(3);
            LOG.debug("[SealSigilShapeSetFloral2] Carving floral slice: sliceIndex={} slices={} passes={}", new Object[]{sliceIndex, slices, passes});
            this.carveCentralRosette(pixels, cx, cy, radius, radiusSq, rng);
            this.carveInnerPetalRing(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng);
            for (int pass = 0; pass < passes; ++pass) {
                try {
                    int recipe = rng.nextInt(3);
                    switch (recipe) {
                        case 0: {
                            this.carveCurvingVineArc(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng, pass);
                            break;
                        }
                        case 1: {
                            this.carveOuterLeafWreath(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng, pass);
                            break;
                        }
                        case 2: {
                            this.carveLeafClusterMotif(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng, pass);
                            break;
                        }
                        default: {
                            this.carveCurvingVineArc(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng, pass);
                            break;
                        }
                    }
                    continue;
                }
                catch (Throwable t) {
                    LOG.error("[SealSigilShapeSetFloral2] Motif pass {} failed in slice {}", new Object[]{pass, sliceIndex, t});
                }
            }
            this.carveBudField(pixels, cx, cy, radius, radiusSq, sliceStart, sliceEnd, rng);
            try {
                int count = 0;
                for (int y = 0; y < size; ++y) {
                    boolean[] row = pixels[y];
                    for (int x = 0; x < size; ++x) {
                        if (!row[x]) continue;
                        ++count;
                    }
                }
                LOG.debug("[SealSigilShapeSetFloral2] applyShapesInSlice: sliceIndex={} markedPixels={}", (Object)sliceIndex, (Object)count);
            }
            catch (Throwable t) {
                LOG.error("[SealSigilShapeSetFloral2] counting marked pixels failed", t);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] applyShapesInSlice failed", t);
        }
    }

    private void carveCentralRosette(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, @NotNull RandomSource rng) {
        try {
            double baseScale = 0.34 * (1.1 + rng.nextDouble() * 0.4);
            int outerR = Math.max(6, (int)Math.round((double)radius * baseScale));
            int innerR = Math.max(3, (int)Math.round((double)outerR * 0.45));
            int petals = 7 + rng.nextInt(3);
            this.carvePetalRosette(pixels, cx, cy, innerR, outerR, petals, cx, cy, radiusSq);
            int coreR = Math.max(3, outerR / 3);
            this.carveDisc(pixels, cx, cy, coreR, cx, cy, radiusSq);
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveCentralRosette failed", t);
        }
    }

    private void carvePetalRosette(boolean[][] pixels, int cxFlower, int cyFlower, int innerR, int outerR, int petals, int cx, int cy, double radiusSq) {
        try {
            if (petals < 3) {
                return;
            }
            double twoPi = Math.PI * 2;
            double step = twoPi / (double)petals;
            double startAngle = -1.5707963267948966;
            for (int i = 0; i < petals; ++i) {
                double angle = startAngle + (double)i * step;
                this.carveSinglePetal(pixels, cxFlower, cyFlower, innerR, outerR, angle, cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carvePetalRosette failed", t);
        }
    }

    private void carveSinglePetal(boolean[][] pixels, int cxFlower, int cyFlower, int innerR, int outerR, double angle, int cx, int cy, double radiusSq) {
        try {
            int samples = 12;
            int[] xsA = new int[samples];
            int[] ysA = new int[samples];
            int[] xsB = new int[samples];
            int[] ysB = new int[samples];
            double spreadAngle = Math.toRadians(16.0);
            double halfSpread = spreadAngle * 0.5;
            for (int i = 0; i < samples; ++i) {
                double width;
                double t = (double)i / (double)(samples - 1);
                double midR = (double)innerR + (double)(outerR - innerR) * t;
                double offset = width = (double)(outerR - innerR) * 0.4 * Math.sin(t * Math.PI);
                double angleLeft = angle - halfSpread;
                double angleRight = angle + halfSpread;
                double pxA = (double)cxFlower + Math.cos(angleLeft) * midR - Math.sin(angle) * offset;
                double pyA = (double)cyFlower + Math.sin(angleLeft) * midR + Math.cos(angle) * offset;
                double pxB = (double)cxFlower + Math.cos(angleRight) * midR + Math.sin(angle) * offset;
                double pyB = (double)cyFlower + Math.sin(angleRight) * midR - Math.cos(angle) * offset;
                xsA[i] = (int)Math.round(pxA);
                ysA[i] = (int)Math.round(pyA);
                xsB[i] = (int)Math.round(pxB);
                ysB[i] = (int)Math.round(pyB);
            }
            int count = samples * 2;
            int[] xs = new int[count];
            int[] ys = new int[count];
            for (int i = 0; i < samples; ++i) {
                xs[i] = xsA[i];
                ys[i] = ysA[i];
                xs[count - 1 - i] = xsB[i];
                ys[count - 1 - i] = ysB[i];
            }
            this.carvePolygon(pixels, xs, ys, count, cx, cy, radiusSq);
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveSinglePetal failed", t);
        }
    }

    private void carveInnerPetalRing(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double sliceStart, double sliceEnd, @NotNull RandomSource rng) {
        try {
            double span = sliceEnd - sliceStart;
            double baseR = (double)radius * 0.34 * (1.45 + rng.nextDouble() * 0.3);
            int petalCount = 2 + rng.nextInt(2);
            int innerR = Math.max(3, (int)Math.round((double)radius * 0.14));
            int outerR = innerR + Math.max(3, radius / 6);
            for (int i = 0; i < petalCount; ++i) {
                int centerY;
                double t = ((double)i + 0.5) / (double)petalCount;
                double angle = sliceStart + span * t;
                int centerX = cx + (int)Math.round(Math.cos(angle) * baseR);
                if (!this.insideCircle(centerX, centerY = cy + (int)Math.round(Math.sin(angle) * baseR), cx, cy, radiusSq)) continue;
                this.carveSinglePetal(pixels, centerX, centerY, innerR, outerR, angle, cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveInnerPetalRing failed", t);
        }
    }

    private void carveCurvingVineArc(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double sliceStart, double sliceEnd, @NotNull RandomSource rng, int passIndex) {
        try {
            double span = sliceEnd - sliceStart;
            double baseR = (double)radius * 0.6 * (1.0 + rng.nextDouble() * 0.15);
            double vineThickness = (double)radius * 0.045;
            double startAngle = sliceStart + span * (0.05 + rng.nextDouble() * 0.03);
            double endAngle = sliceEnd - span * (0.05 + rng.nextDouble() * 0.03);
            if (endAngle <= startAngle) {
                return;
            }
            this.carveThickArc(pixels, cx, cy, radiusSq, baseR, vineThickness, startAngle, endAngle, 11, cx, cy);
            if (rng.nextFloat() < 0.9f) {
                this.carveVineLeaves(pixels, cx, cy, radius, radiusSq, baseR, vineThickness, startAngle, endAngle, rng);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveCurvingVineArc failed", t);
        }
    }

    private void carveThickArc(boolean[][] pixels, int cx, int cy, double radiusSq, double ringR, double thickness, double angleStart, double angleEnd, int segments, int circleCx, int circleCy) {
        try {
            if (segments < 2) {
                segments = 2;
            }
            int size = pixels.length;
            double halfT = thickness * 0.5;
            double prevAngle = angleStart;
            for (int i = 1; i <= segments; ++i) {
                double t = (double)i / (double)segments;
                double angle = angleStart + (angleEnd - angleStart) * t;
                int sx0 = cx + (int)Math.round(Math.cos(prevAngle) * ringR);
                int sy0 = cy + (int)Math.round(Math.sin(prevAngle) * ringR);
                int sx1 = cx + (int)Math.round(Math.cos(angle) * ringR);
                int sy1 = cy + (int)Math.round(Math.sin(angle) * ringR);
                int lineThickness = Math.max(2, (int)Math.round(halfT));
                this.carveLine(pixels, sx0, sy0, sx1, sy1, lineThickness, circleCx, circleCy, radiusSq);
                prevAngle = angle;
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveThickArc failed", t);
        }
    }

    private void carveVineLeaves(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double baseR, double thickness, double angleStart, double angleEnd, @NotNull RandomSource rng) {
        try {
            int leafCount = 3 + rng.nextInt(3);
            double span = angleEnd - angleStart;
            double leafR = baseR + thickness * 0.8;
            int innerR = Math.max(3, radius / 10);
            int outerR = innerR + Math.max(3, radius / 7);
            for (int i = 0; i < leafCount; ++i) {
                int baseY;
                double t = ((double)i + 0.5) / (double)leafCount;
                double angle = angleStart + span * t;
                double normalAngle = angle + (rng.nextBoolean() ? 1.5707963267948966 : -1.5707963267948966);
                int baseX = cx + (int)Math.round(Math.cos(angle) * leafR);
                if (!this.insideCircle(baseX, baseY = cy + (int)Math.round(Math.sin(angle) * leafR), cx, cy, radiusSq)) continue;
                this.carveSinglePetal(pixels, baseX, baseY, innerR, outerR, normalAngle, cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveVineLeaves failed", t);
        }
    }

    private void carveOuterLeafWreath(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double sliceStart, double sliceEnd, @NotNull RandomSource rng, int passIndex) {
        try {
            double span = sliceEnd - sliceStart;
            double baseR = (double)radius * 0.88 * (0.96 + rng.nextDouble() * 0.08);
            int leafPairs = 2 + rng.nextInt(2);
            int innerR = Math.max(3, radius / 10);
            int outerR = innerR + Math.max(3, radius / 7);
            for (int i = 0; i < leafPairs; ++i) {
                int centerY;
                double t = ((double)i + 0.5) / (double)leafPairs;
                double angle = sliceStart + span * t;
                int centerX = cx + (int)Math.round(Math.cos(angle) * baseR);
                if (!this.insideCircle(centerX, centerY = cy + (int)Math.round(Math.sin(angle) * baseR), cx, cy, radiusSq)) continue;
                double dir = angle;
                this.carveSinglePetal(pixels, centerX, centerY, innerR, outerR, dir + Math.toRadians(20.0), cx, cy, radiusSq);
                this.carveSinglePetal(pixels, centerX, centerY, innerR, outerR, dir - Math.toRadians(20.0), cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveOuterLeafWreath failed", t);
        }
    }

    private void carveLeafClusterMotif(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double sliceStart, double sliceEnd, @NotNull RandomSource rng, int passIndex) {
        try {
            double span = sliceEnd - sliceStart;
            int clusterCount = 1 + rng.nextInt(2);
            for (int c = 0; c < clusterCount; ++c) {
                int baseY;
                double t = ((double)c + 0.5) / (double)clusterCount;
                double angle = sliceStart + span * t;
                double rNorm = 0.34 + rng.nextDouble() * 0.25999999999999995;
                double r = (double)radius * rNorm;
                int baseX = cx + (int)Math.round(Math.cos(angle) * r);
                if (!this.insideCircle(baseX, baseY = cy + (int)Math.round(Math.sin(angle) * r), cx, cy, radiusSq)) continue;
                this.carveLeafCluster(pixels, baseX, baseY, radius, radiusSq, angle, rng, cx, cy);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveLeafClusterMotif failed", t);
        }
    }

    private void carveLeafCluster(boolean[][] pixels, int baseX, int baseY, int radius, double radiusSq, double baseAngle, @NotNull RandomSource rng, int cx, int cy) {
        try {
            int leaves = 3 + rng.nextInt(2);
            int innerR = Math.max(3, radius / 11);
            int outerR = innerR + Math.max(3, radius / 7);
            for (int i = 0; i < leaves; ++i) {
                int cyLeaf;
                double offsetAngle = baseAngle + (rng.nextDouble() - 0.5) * Math.toRadians(32.0);
                double offsetDist = (double)radius * 0.06 * (0.6 + rng.nextDouble() * 0.8);
                int cxLeaf = baseX + (int)Math.round(Math.cos(offsetAngle) * offsetDist);
                if (!this.insideCircle(cxLeaf, cyLeaf = baseY + (int)Math.round(Math.sin(offsetAngle) * offsetDist), cx, cy, radiusSq)) continue;
                this.carveSinglePetal(pixels, cxLeaf, cyLeaf, innerR, outerR, offsetAngle, cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveLeafCluster failed", t);
        }
    }

    private void carveBudField(boolean[][] pixels, int cx, int cy, int radius, double radiusSq, double sliceStart, double sliceEnd, @NotNull RandomSource rng) {
        try {
            int budCount = 3 + rng.nextInt(3);
            double span = sliceEnd - sliceStart;
            for (int i = 0; i < budCount; ++i) {
                int y;
                double angle = sliceStart + span * rng.nextDouble();
                double rNorm = 0.34 + rng.nextDouble() * 0.54;
                double r = (double)radius * rNorm;
                int x = cx + (int)Math.round(Math.cos(angle) * r);
                if (!this.insideCircle(x, y = cy + (int)Math.round(Math.sin(angle) * r), cx, cy, radiusSq)) continue;
                int budR = 3;
                this.carveDisc(pixels, x, y, budR, cx, cy, radiusSq);
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveBudField failed", t);
        }
    }

    private boolean insideCircle(int x, int y, int cx, int cy, double radiusSq) {
        int dx = x - cx;
        int dy = y - cy;
        return (double)(dx * dx + dy * dy) <= radiusSq;
    }

    private void carveDisc(boolean[][] pixels, int centerX, int centerY, int r, int cx, int cy, double radiusSq) {
        try {
            if (r <= 0) {
                return;
            }
            int size = pixels.length;
            int minY = Math.max(0, centerY - r);
            int maxY = Math.min(size - 1, centerY + r);
            int minX = Math.max(0, centerX - r);
            int maxX = Math.min(size - 1, centerX + r);
            int rSq = r * r;
            for (int y = minY; y <= maxY; ++y) {
                int dy = y - centerY;
                int dySq = dy * dy;
                for (int x = minX; x <= maxX; ++x) {
                    int dx = x - centerX;
                    int d2 = dx * dx + dySq;
                    if (d2 > rSq || !this.insideCircle(x, y, cx, cy, radiusSq)) continue;
                    pixels[y][x] = true;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveDisc failed", t);
        }
    }

    private void carveRing(boolean[][] pixels, int centerX, int centerY, int innerRadius, int outerRadius, int cx, int cy, double radiusSq) {
        try {
            if (outerRadius <= 0 || innerRadius < 0 || outerRadius <= innerRadius) {
                return;
            }
            int size = pixels.length;
            int minY = Math.max(0, centerY - outerRadius);
            int maxY = Math.min(size - 1, centerY + outerRadius);
            int minX = Math.max(0, centerX - outerRadius);
            int maxX = Math.min(size - 1, centerX + outerRadius);
            int outerSq = outerRadius * outerRadius;
            int innerSq = innerRadius * innerRadius;
            for (int y = minY; y <= maxY; ++y) {
                int dy = y - centerY;
                int dySq = dy * dy;
                for (int x = minX; x <= maxX; ++x) {
                    int dx = x - centerX;
                    int d2 = dx * dx + dySq;
                    if (d2 > outerSq || d2 < innerSq || !this.insideCircle(x, y, cx, cy, radiusSq)) continue;
                    pixels[y][x] = true;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveRing failed", t);
        }
    }

    private void carveLine(boolean[][] pixels, int x0, int y0, int x1, int y1, int thickness, int cx, int cy, double radiusSq) {
        try {
            int dx = Math.abs(x1 - x0);
            int dy = Math.abs(y1 - y0);
            int sx = x0 < x1 ? 1 : -1;
            int sy = y0 < y1 ? 1 : -1;
            int err = dx - dy;
            int size = pixels.length;
            int r = Math.max(0, thickness - 1);
            while (true) {
                if (x0 >= 0 && y0 >= 0 && x0 < size && y0 < size && this.insideCircle(x0, y0, cx, cy, radiusSq)) {
                    if (r == 0) {
                        pixels[y0][x0] = true;
                    } else {
                        for (int oy = -r; oy <= r; ++oy) {
                            int ny = y0 + oy;
                            if (ny < 0 || ny >= size) continue;
                            for (int ox = -r; ox <= r; ++ox) {
                                int nx = x0 + ox;
                                if (nx < 0 || nx >= size || !this.insideCircle(nx, ny, cx, cy, radiusSq)) continue;
                                pixels[ny][nx] = true;
                            }
                        }
                    }
                }
                if (x0 != x1 || y0 != y1) {
                    int e2 = err * 2;
                    if (e2 > -dy) {
                        err -= dy;
                        x0 += sx;
                    }
                    if (e2 >= dx) continue;
                    err += dx;
                    y0 += sy;
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carveLine failed", t);
        }
    }

    private void carvePolygon(boolean[][] pixels, int[] xs, int[] ys, int count, int cx, int cy, double radiusSq) {
        try {
            int y;
            if (xs == null || ys == null || count <= 1) {
                return;
            }
            int size = pixels.length;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int i = 0; i < count; ++i) {
                y = ys[i];
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
            if ((minY = Math.max(0, Math.min(minY, size - 1))) > (maxY = Math.max(0, Math.min(maxY, size - 1)))) {
                return;
            }
            int[] xIntersections = new int[count];
            for (y = minY; y <= maxY; ++y) {
                int interCount = 0;
                for (int i = 0; i < count; ++i) {
                    int j = (i + 1) % count;
                    int x1 = xs[i];
                    int y1 = ys[i];
                    int x2 = xs[j];
                    int y2 = ys[j];
                    if ((y1 > y || y2 <= y) && (y2 > y || y1 <= y)) continue;
                    double t = (double)(y - y1) / (double)(y2 - y1);
                    int x = x1 + (int)Math.round(t * (double)(x2 - x1));
                    xIntersections[interCount++] = x;
                }
                if (interCount <= 0) continue;
                Arrays.sort(xIntersections, 0, interCount);
                for (int k = 0; k < interCount; k += 2) {
                    int xEnd;
                    int xStart = xIntersections[k];
                    int n = xEnd = k + 1 < interCount ? xIntersections[k + 1] : xStart;
                    if (xEnd < xStart) {
                        int tmp = xStart;
                        xStart = xEnd;
                        xEnd = tmp;
                    }
                    xStart = Math.max(0, xStart);
                    xEnd = Math.min(size - 1, xEnd);
                    for (int x = xStart; x <= xEnd; ++x) {
                        if (!this.insideCircle(x, y, cx, cy, radiusSq)) continue;
                        pixels[y][x] = true;
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[SealSigilShapeSetFloral2] carvePolygon failed", t);
        }
    }
}

