/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.sigil;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import net.minecraft.util.RandomSource;
import net.z2six.featheredfriend.sigil.SealSigilShapeSet;
import net.z2six.featheredfriend.sigil.SealSigilShapeSetFloral2;
import net.z2six.featheredfriend.sigil.SealSigilShapeSetHighFantasy1;
import net.z2six.featheredfriend.sigil.SealSigilShapeSetMedieval0;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class SealSigilGenerator {
    private static final Logger LOG = LogUtils.getLogger();
    public static final int DEFAULT_RADIUS = 64;
    public static final int DEFAULT_SIZE = 129;
    private static final int MAX_SECRET_LENGTH = 128;
    private static final int MIN_SLICES = 2;
    private static final int MAX_SLICES = 8;

    private SealSigilGenerator() {
    }

    @NotNull
    public static SigilPattern generateForPlayer(@NotNull UUID playerUuid, @NotNull String secret) {
        long seed = SealSigilGenerator.computeSeed(playerUuid, secret);
        int slices = 4;
        int shapeSetIndex = 0;
        return SealSigilGenerator.generateFromSeed(seed, 64, slices, shapeSetIndex);
    }

    public static long computeSeed(@NotNull UUID playerUuid, @NotNull String secret) {
        String trimmedSecret = secret;
        if (trimmedSecret.length() > 128) {
            trimmedSecret = trimmedSecret.substring(0, 128);
        }
        String input = playerUuid.toString() + "|" + trimmedSecret;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buf = ByteBuffer.wrap(hash);
            long seed = buf.getLong();
            LOG.debug("[SealSigilGenerator] computeSeed: uuid={} secretPreview='{}' len={} -> seed={}", new Object[]{playerUuid, SealSigilGenerator.safeSecretPreview(trimmedSecret), trimmedSecret.length(), seed});
            return seed;
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] computeSeed failed, falling back to String.hashCode()", t);
            return (playerUuid.toString() + "|" + trimmedSecret).hashCode();
        }
    }

    public static long computeSeedFromSecretOnly(@NotNull String secret) {
        String trimmed = secret;
        if (trimmed.length() > 128) {
            trimmed = trimmed.substring(0, 128);
        }
        String input = trimmed + "|featheredfriend_secret_v3";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buf = ByteBuffer.wrap(hash);
            long seed = buf.getLong();
            LOG.debug("[SealSigilGenerator] computeSeedFromSecretOnly(v3): secretPreview='{}' len={} -> seed={}", new Object[]{SealSigilGenerator.safeSecretPreview(trimmed), trimmed.length(), seed});
            return seed;
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] computeSeedFromSecretOnly(v3) failed, fallback to hashCode()", t);
            return input.hashCode();
        }
    }

    @NotNull
    public static SigilPattern generateFromSeed(long seed, int radius, int slices, int shapeSetIndex) {
        if (radius < 16) {
            radius = 16;
        }
        if (slices < 2) {
            LOG.warn("[SealSigilGenerator] Requested slices={} < MIN_SLICES={}, clamping", (Object)slices, (Object)2);
            slices = 2;
        } else if (slices > 8) {
            LOG.warn("[SealSigilGenerator] Requested slices={} > MAX_SLICES={}, clamping", (Object)slices, (Object)8);
            slices = 8;
        }
        int size = radius * 2 + 1;
        int cx = radius;
        int cy = radius;
        double radiusSq = radius * radius;
        boolean[][] discMask = new boolean[size][size];
        boolean[][] shapeMask = new boolean[size][size];
        RandomSource rng = RandomSource.create((long)seed);
        try {
            LOG.debug("[SealSigilGenerator] generateFromSeed: seed={} radius={} size={} slices={} shapeSetIndex={}", new Object[]{seed, radius, size, slices, shapeSetIndex});
            SealSigilGenerator.fillWavyBoundary(discMask, cx, cy, radius, rng);
            boolean[][] slicePixels = new boolean[size][size];
            SealSigilShapeSet shapeSet = SealSigilGenerator.resolveShapeSet(shapeSetIndex);
            try {
                shapeSet.applyShapesInSlice(slicePixels, cx, cy, radius, radiusSq, slices, 0, rng);
            }
            catch (Throwable t) {
                LOG.error("[SealSigilGenerator] ShapeSet generation failed for index={}", (Object)shapeSetIndex, (Object)t);
            }
            SealSigilGenerator.restrictToBaseSlice(slicePixels, cx, cy, slices);
            SealSigilGenerator.replicateSliceIntoAllSlices(slicePixels, shapeMask, cx, cy, slices);
            SealSigilGenerator.cleanupShapeMask(shapeMask);
            int carvedCount = 0;
            int insideBoundary = 0;
            for (int y = 0; y < size; ++y) {
                boolean[] discRow = discMask[y];
                boolean[] shapeRow = shapeMask[y];
                for (int x = 0; x < size; ++x) {
                    if (!discRow[x]) continue;
                    ++insideBoundary;
                    if (!shapeRow[x]) continue;
                    ++carvedCount;
                }
            }
            double coverage = insideBoundary == 0 ? 0.0 : (double)(insideBoundary - carvedCount) / (double)insideBoundary;
            LOG.debug("[SealSigilGenerator] conceptual coverage after extrusion: {} (inside={} carved={})", new Object[]{coverage, insideBoundary, carvedCount});
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] generateFromSeed failed (seed={}, radius={}, slices={}, shapeSetIndex={}), using fallback dot", new Object[]{seed, radius, slices, shapeSetIndex, t});
            try {
                int cxSafe = Math.max(0, Math.min(size - 1, cx));
                int cySafe = Math.max(0, Math.min(size - 1, cy));
                discMask[cySafe][cxSafe] = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new SigilPattern(size, discMask, shapeMask, seed, slices, shapeSetIndex);
    }

    @NotNull
    private static SealSigilShapeSet resolveShapeSet(int shapeSetIndex) {
        try {
            return switch (shapeSetIndex) {
                case 0 -> {
                    LOG.debug("[SealSigilGenerator] Using shape set 0: SealSigilShapeSetMedieval0");
                    yield new SealSigilShapeSetMedieval0();
                }
                case 1 -> {
                    LOG.debug("[SealSigilGenerator] Using shape set 1: SealSigilShapeSetHighFantasy1");
                    yield new SealSigilShapeSetHighFantasy1();
                }
                case 2 -> {
                    LOG.debug("[SealSigilGenerator] Using shape set 2: SealSigilShapeSetFloral2");
                    yield new SealSigilShapeSetFloral2();
                }
                default -> {
                    LOG.warn("[SealSigilGenerator] Unknown shapeSetIndex={} \u2014 falling back to Medieval0", (Object)shapeSetIndex);
                    yield new SealSigilShapeSetMedieval0();
                }
            };
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] resolveShapeSet failed for index={}, falling back to Medieval0", (Object)shapeSetIndex, (Object)t);
            return new SealSigilShapeSetMedieval0();
        }
    }

    private static void fillWavyBoundary(boolean[][] mask, int cx, int cy, int radius, @NotNull RandomSource rng) {
        try {
            int size = mask.length;
            int radialSamples = 3072;
            double[] radialR = new double[radialSamples];
            double twoPi = Math.PI * 2;
            double angleStep = twoPi / (double)radialSamples;
            double maxR = (double)radius - 1.0;
            double minR = (double)radius * 0.95;
            double currentR = (maxR + minR) * 0.5;
            double maxStep = 0.12;
            double minSeen = Double.POSITIVE_INFINITY;
            double maxSeen = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < radialSamples; ++i) {
                double delta = (rng.nextDouble() - 0.5) * 2.0 * maxStep;
                if ((currentR += delta) < minR) {
                    currentR = minR;
                }
                if (currentR > maxR) {
                    currentR = maxR;
                }
                radialR[i] = currentR;
                if (currentR < minSeen) {
                    minSeen = currentR;
                }
                if (!(currentR > maxSeen)) continue;
                maxSeen = currentR;
            }
            int smoothRadius = 9;
            int smoothPasses = 4;
            double[] temp = new double[radialSamples];
            for (int pass = 0; pass < smoothPasses; ++pass) {
                for (int i = 0; i < radialSamples; ++i) {
                    double sum = 0.0;
                    int count = 0;
                    for (int k = -smoothRadius; k <= smoothRadius; ++k) {
                        int j = i + k;
                        if (j < 0) {
                            j += radialSamples;
                        }
                        if (j >= radialSamples) {
                            j -= radialSamples;
                        }
                        sum += radialR[j];
                        ++count;
                    }
                    temp[i] = sum / (double)count;
                }
                double[] swap = radialR;
                radialR = temp;
                temp = swap;
            }
            for (int i = 0; i < radialSamples; ++i) {
                int i0 = (i - 1 + radialSamples) % radialSamples;
                int i1 = i;
                int i2 = (i + 1) % radialSamples;
                temp[i] = 0.25 * radialR[i0] + 0.5 * radialR[i1] + 0.25 * radialR[i2];
            }
            double[] swap = radialR;
            radialR = temp;
            temp = swap;
            double finalMin = Double.POSITIVE_INFINITY;
            double finalMax = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < radialSamples; ++i) {
                if (radialR[i] < finalMin) {
                    finalMin = radialR[i];
                }
                if (!(radialR[i] > finalMax)) continue;
                finalMax = radialR[i];
            }
            double maxRSq = maxR * maxR;
            int minY = Math.max(0, cy - radius);
            int maxY = Math.min(size - 1, cy + radius);
            int minX = Math.max(0, cx - radius);
            int maxX = Math.min(size - 1, cx + radius);
            for (int y = minY; y <= maxY; ++y) {
                int dy = y - cy;
                int dySq = dy * dy;
                for (int x = minX; x <= maxX; ++x) {
                    double r1;
                    double r0;
                    double allowedR;
                    double allowedRSq;
                    int idx1;
                    int dx = x - cx;
                    int dxSq = dx * dx;
                    int d2 = dxSq + dySq;
                    if ((double)d2 > maxRSq) continue;
                    double angle = Math.atan2(dy, dx);
                    if (angle < 0.0) {
                        angle += twoPi;
                    }
                    double sampleIndex = angle / angleStep;
                    int idx0 = (int)Math.floor(sampleIndex);
                    double frac = sampleIndex - (double)idx0;
                    if (idx0 < 0) {
                        idx0 = 0;
                        frac = 0.0;
                    }
                    if (idx0 >= radialSamples) {
                        idx0 = radialSamples - 1;
                        frac = 0.0;
                    }
                    if ((idx1 = idx0 + 1) >= radialSamples) {
                        idx1 = 0;
                    }
                    if (!((double)d2 <= (allowedRSq = (allowedR = (r0 = radialR[idx0]) + ((r1 = radialR[idx1]) - r0) * frac) * allowedR))) continue;
                    mask[y][x] = true;
                }
            }
            LOG.debug("[SealSigilGenerator] fillWavyBoundary: radius={} rawMinR={} rawMaxR={} finalMinR={} finalMaxR={} samples={} passes={} smoothRadius={}", new Object[]{radius, minSeen, maxSeen, finalMin, finalMax, radialSamples, smoothPasses, smoothRadius});
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] fillWavyBoundary failed, falling back to simple disc", t);
            try {
                SealSigilGenerator.fillFallbackDisc(mask, cx, cy, radius);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void fillFallbackDisc(boolean[][] mask, int cx, int cy, int radius) {
        int size = mask.length;
        int rSq = radius * radius;
        int minY = Math.max(0, cy - radius);
        int maxY = Math.min(size - 1, cy + radius);
        int minX = Math.max(0, cx - radius);
        int maxX = Math.min(size - 1, cx + radius);
        for (int y = minY; y <= maxY; ++y) {
            int dy = y - cy;
            int dySq = dy * dy;
            for (int x = minX; x <= maxX; ++x) {
                int dx = x - cx;
                int d2 = dx * dx + dySq;
                if (d2 > rSq) continue;
                mask[y][x] = true;
            }
        }
    }

    private static void restrictToBaseSlice(boolean[][] slicePixels, int cx, int cy, int slices) {
        try {
            int size = slicePixels.length;
            double twoPi = Math.PI * 2;
            double sliceAngle = twoPi / (double)Math.max(1, slices);
            int kept = 0;
            int cleared = 0;
            for (int y = 0; y < size; ++y) {
                boolean[] row = slicePixels[y];
                for (int x = 0; x < size; ++x) {
                    if (!row[x]) continue;
                    int dx = x - cx;
                    int dy = y - cy;
                    if (dx == 0 && dy == 0) {
                        ++kept;
                        continue;
                    }
                    double angle = Math.atan2(dy, dx);
                    if (angle < 0.0) {
                        angle += twoPi;
                    }
                    if (angle < 0.0 || angle >= sliceAngle) {
                        row[x] = false;
                        ++cleared;
                        continue;
                    }
                    ++kept;
                }
            }
            LOG.debug("[SealSigilGenerator] restrictToBaseSlice: slices={} kept={} cleared={}", new Object[]{slices, kept, cleared});
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] restrictToBaseSlice failed", t);
        }
    }

    private static void replicateSliceIntoAllSlices(boolean[][] slicePixels, boolean[][] targetMask, int cx, int cy, int slices) {
        try {
            int size = slicePixels.length;
            double twoPi = Math.PI * 2;
            double sliceAngle = twoPi / (double)Math.max(1, slices);
            int baseCount = 0;
            int writtenCount = 0;
            for (int y = 0; y < size; ++y) {
                boolean[] row = slicePixels[y];
                for (int x = 0; x < size; ++x) {
                    if (!row[x]) continue;
                    ++baseCount;
                    int dx = x - cx;
                    int dy = y - cy;
                    double r = Math.sqrt(dx * dx + dy * dy);
                    if (r < 0.001) {
                        for (int k = 0; k < slices; ++k) {
                            if (cx < 0 || cy < 0 || cx >= size || cy >= size || targetMask[cy][cx]) continue;
                            targetMask[cy][cx] = true;
                            ++writtenCount;
                        }
                        continue;
                    }
                    double angle = Math.atan2(dy, dx);
                    if (angle < 0.0) {
                        angle += twoPi;
                    }
                    for (int k = 0; k < slices; ++k) {
                        double a = angle + (double)k * sliceAngle;
                        if (a >= twoPi) {
                            a -= twoPi;
                        }
                        int tx = cx + (int)Math.round(Math.cos(a) * r);
                        int ty = cy + (int)Math.round(Math.sin(a) * r);
                        if (tx < 0 || ty < 0 || tx >= size || ty >= size || targetMask[ty][tx]) continue;
                        targetMask[ty][tx] = true;
                        ++writtenCount;
                    }
                }
            }
            LOG.debug("[SealSigilGenerator] replicateSliceIntoAllSlices: slices={} basePixels={} writtenPixels={}", new Object[]{slices, baseCount, writtenCount});
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] replicateSliceIntoAllSlices failed", t);
        }
    }

    private static void cleanupShapeMask(boolean[][] mask) {
        try {
            int size = mask.length;
            if (size == 0) {
                return;
            }
            boolean[][] original = new boolean[size][size];
            for (int y = 0; y < size; ++y) {
                System.arraycopy(mask[y], 0, original[y], 0, size);
            }
            int filled = 0;
            int removed = 0;
            for (int y = 0; y < size; ++y) {
                for (int x = 0; x < size; ++x) {
                    boolean cur = original[y][x];
                    int neighborsTrue = 0;
                    for (int oy = -1; oy <= 1; ++oy) {
                        int ny = y + oy;
                        if (ny < 0 || ny >= size) continue;
                        for (int ox = -1; ox <= 1; ++ox) {
                            int nx = x + ox;
                            if (nx < 0 || nx >= size || ox == 0 && oy == 0 || !original[ny][nx]) continue;
                            ++neighborsTrue;
                        }
                    }
                    if (cur) {
                        if (neighborsTrue > true) continue;
                        mask[y][x] = false;
                        ++removed;
                        continue;
                    }
                    if (neighborsTrue < 5) continue;
                    mask[y][x] = true;
                    ++filled;
                }
            }
            LOG.debug("[SealSigilGenerator] cleanupShapeMask: filledHoles={} removedSpecks={}", (Object)filled, (Object)removed);
        }
        catch (Throwable t) {
            LOG.error("[SealSigilGenerator] cleanupShapeMask failed", t);
        }
    }

    private static String safeSecretPreview(String secret) {
        if (secret == null) {
            return "<null>";
        }
        String trimmed = secret.trim();
        if (trimmed.length() <= 8) {
            return trimmed;
        }
        return trimmed.substring(0, 8) + "...";
    }

    public static final class SigilPattern {
        private final int size;
        private final boolean[][] discMask;
        private final boolean[][] shapeMask;
        private boolean[][] carvedMask;
        private final long seed;
        private final int slices;
        private final int shapeSetIndex;

        public SigilPattern(int size, boolean[][] pixels, long seed) {
            this(size, pixels, new boolean[pixels != null ? pixels.length : 0][pixels != null ? pixels.length : 0], seed, 0, 0);
            this.carvedMask = pixels;
        }

        public SigilPattern(int size, boolean[][] pixels, long seed, int slices, int shapeSetIndex) {
            this(size, pixels, new boolean[pixels != null ? pixels.length : 0][pixels != null ? pixels.length : 0], seed, slices, shapeSetIndex);
            this.carvedMask = pixels;
        }

        public SigilPattern(int size, boolean[][] discMask, boolean[][] shapeMask, long seed, int slices, int shapeSetIndex) {
            this.size = size;
            this.discMask = discMask;
            this.shapeMask = shapeMask;
            this.seed = seed;
            this.slices = slices;
            this.shapeSetIndex = shapeSetIndex;
            this.carvedMask = null;
        }

        public int getSize() {
            return this.size;
        }

        public boolean[][] getDiscMask() {
            return this.discMask;
        }

        public boolean[][] getShapeMask() {
            return this.shapeMask;
        }

        public boolean[][] getCarvedMask() {
            try {
                if (this.carvedMask != null) {
                    return this.carvedMask;
                }
                if (this.discMask == null) {
                    return null;
                }
                int h = this.discMask.length;
                if (h == 0) {
                    this.carvedMask = this.discMask;
                    return this.carvedMask;
                }
                int w = this.discMask[0].length;
                boolean[][] out = new boolean[h][w];
                if (this.shapeMask == null) {
                    for (int y = 0; y < h; ++y) {
                        boolean[] src = this.discMask[y];
                        boolean[] dst = out[y];
                        System.arraycopy(src, 0, dst, 0, Math.min(src.length, w));
                    }
                    this.carvedMask = out;
                    return this.carvedMask;
                }
                for (int y = 0; y < h; ++y) {
                    boolean[] discRow = this.discMask[y];
                    boolean[] shapeRow = this.shapeMask[y];
                    boolean[] outRow = out[y];
                    int rowLen = Math.min(Math.min(discRow.length, shapeRow.length), w);
                    for (int x = 0; x < rowLen; ++x) {
                        outRow[x] = discRow[x] && !shapeRow[x];
                    }
                }
                this.carvedMask = out;
                return this.carvedMask;
            }
            catch (Throwable t) {
                LOG.error("[SealSigilGenerator.SigilPattern] getCarvedMask() failed", t);
                return this.carvedMask != null ? this.carvedMask : this.discMask;
            }
        }

        public boolean[][] getPixels() {
            return this.getCarvedMask();
        }

        public long getSeed() {
            return this.seed;
        }

        public int getSlices() {
            return this.slices;
        }

        public int getShapeSetIndex() {
            return this.shapeSetIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SigilPattern{size=").append(this.size).append(", seed=").append(this.seed).append(", slices=").append(this.slices).append(", shapeSetIndex=").append(this.shapeSetIndex).append("}\n");
            try {
                boolean[][] mask = this.getCarvedMask();
                if (mask == null) {
                    sb.append("<null mask>\n");
                    return sb.toString();
                }
                for (boolean[] row : mask) {
                    int w = row.length;
                    for (int x = 0; x < w; ++x) {
                        sb.append(row[x] ? (char)'#' : '.');
                    }
                    sb.append('\n');
                }
            }
            catch (Throwable t) {
                LOG.error("[SealSigilGenerator.SigilPattern] toString() failed", t);
            }
            return sb.toString();
        }
    }
}

