/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.registry;

import com.mojang.logging.LogUtils;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public final class FFNeoForgeParticles {
    private static final Logger LOG = LogUtils.getLogger();
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"featheredfriend");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> ENDERPOP = PARTICLE_TYPES.register("enderpop", () -> {
        try {
            return new SimpleParticleType(true);
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeParticles] Failed creating SimpleParticleType(enderpop); falling back", t);
            return new SimpleParticleType(true);
        }
    });
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> FEATHER = PARTICLE_TYPES.register("feather", () -> {
        try {
            return new SimpleParticleType(true);
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeParticles] Failed creating SimpleParticleType(feather); falling back", t);
            return new SimpleParticleType(true);
        }
    });

    private FFNeoForgeParticles() {
    }

    public static void register(IEventBus modEventBus) {
        LOG.info("[FFNeoForgeParticles] Registering particle types");
        try {
            PARTICLE_TYPES.register(modEventBus);
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeParticles] PARTICLE_TYPES.register(modEventBus) failed", t);
        }
    }
}

