/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.registry;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.z2six.featheredfriend.neoforge.menu.ScrollSealingMenu;
import net.z2six.featheredfriend.neoforge.menu.ScrollViewMenu;
import net.z2six.featheredfriend.neoforge.menu.SealStampMenu;
import org.slf4j.Logger;

public final class FFNeoForgeMenus {
    private static final Logger LOG = LogUtils.getLogger();
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"featheredfriend");
    public static final Supplier<MenuType<ScrollSealingMenu>> SCROLL_SEALING_MENU = MENUS.register("scroll_sealing", () -> {
        LOG.debug("[FFNeoForgeMenus] Registering MenuType 'scroll_sealing'");
        return new MenuType(ScrollSealingMenu::new, FeatureFlags.DEFAULT_FLAGS);
    });
    public static final Supplier<MenuType<SealStampMenu>> SEAL_STAMP_MENU = MENUS.register("seal_stamp", () -> {
        LOG.debug("[FFNeoForgeMenus] Registering MenuType 'seal_stamp'");
        return new MenuType(SealStampMenu::new, FeatureFlags.DEFAULT_FLAGS);
    });
    public static final Supplier<MenuType<ScrollViewMenu>> SCROLL_VIEW_MENU = MENUS.register("scroll_view", () -> {
        LOG.debug("[FFNeoForgeMenus] Registering MenuType 'scroll_view'");
        return new MenuType(ScrollViewMenu::new, FeatureFlags.DEFAULT_FLAGS);
    });

    private FFNeoForgeMenus() {
    }

    public static void register(IEventBus modEventBus) {
        LOG.debug("[FFNeoForgeMenus] Registering menu deferred register on mod event bus");
        MENUS.register(modEventBus);
    }
}

