/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.registry;

import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import org.slf4j.Logger;

public final class FFNeoForgeEntities {
    private static final Logger LOG = LogUtils.getLogger();
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"featheredfriend");
    private static final float RAVEN_HITBOX_WIDTH = 0.7f;
    private static final float RAVEN_HITBOX_HEIGHT = 0.7f;
    public static final DeferredHolder<EntityType<?>, EntityType<RavenEntity>> RAVEN = ENTITY_TYPES.register("raven", () -> {
        try {
            LOG.info("[FFNeoForgeEntities] Building Raven EntityType with hitbox w={} h={}", (Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.7f));
            return EntityType.Builder.of(RavenEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.7f).clientTrackingRange(8).build("featheredfriend:raven");
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeEntities] Failed building Raven EntityType", t);
            return EntityType.Builder.of(RavenEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.7f).clientTrackingRange(8).build("featheredfriend:raven");
        }
    });

    private FFNeoForgeEntities() {
    }

    public static void register(IEventBus modEventBus) {
        LOG.info("[FFNeoForgeEntities] Registering entity types");
        try {
            ENTITY_TYPES.register(modEventBus);
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeEntities] ENTITY_TYPES.register(modEventBus) failed", t);
        }
        try {
            modEventBus.addListener(FFNeoForgeEntities::onEntityAttributeCreation);
            LOG.info("[FFNeoForgeEntities] Hooked EntityAttributeCreationEvent listener");
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeEntities] Failed to hook EntityAttributeCreationEvent listener", t);
        }
    }

    private static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        LOG.info("[FFNeoForgeEntities] Creating attributes for registered entities");
        try {
            event.put((EntityType)RAVEN.get(), FFNeoForgeEntities.createRavenAttributes().build());
            LOG.info("[FFNeoForgeEntities] Registered Raven attributes");
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeEntities] Failed to register Raven attributes", t);
        }
    }

    private static AttributeSupplier.Builder createRavenAttributes() {
        try {
            return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.28);
        }
        catch (Throwable t) {
            LOG.error("[FFNeoForgeEntities] createRavenAttributes failed; falling back to minimal attributes", t);
            return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0);
        }
    }
}

