/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.z2six.featheredfriend.item.ScrollViewItem;
import net.z2six.featheredfriend.item.SealStampItem;
import net.z2six.featheredfriend.item.UnsealedScrollItem;
import org.slf4j.Logger;

public final class FFItems {
    private static final Logger LOG = LogUtils.getLogger();
    public static final Map<String, java.util.function.Supplier<Item>> ITEM_MAP = new LinkedHashMap<String, java.util.function.Supplier<Item>>();
    public static final java.util.function.Supplier<Item> SCROLL_UNSEALED = FFItems.register("scroll_unsealed", () -> new UnsealedScrollItem(new Item.Properties().stacksTo(64)));
    public static final java.util.function.Supplier<Item> SCROLL_OPENED = FFItems.register("scroll_opened", () -> new ScrollViewItem(new Item.Properties().stacksTo(1)));
    public static final java.util.function.Supplier<Item> SCROLL_SEALED = FFItems.register("scroll_sealed", () -> new ScrollViewItem(new Item.Properties().stacksTo(1)));
    public static final java.util.function.Supplier<Item> SEAL_STAMP = FFItems.register("seal_stamp", () -> new SealStampItem(new Item.Properties().stacksTo(1).durability(256)));

    private static java.util.function.Supplier<Item> register(String name, java.util.function.Supplier<Item> factory) {
        LOG.debug("[FFItems] Queuing common item '{}' for registration", (Object)name);
        Supplier memoized = Suppliers.memoize(() -> {
            try {
                return (Item)factory.get();
            }
            catch (Throwable t) {
                LOG.error("[FFItems] Failed to create Item instance for '{}', falling back to plain Item", (Object)name, (Object)t);
                return new Item(new Item.Properties());
            }
        });
        java.util.function.Supplier<Item> previous = ITEM_MAP.put(name, (java.util.function.Supplier<Item>)memoized);
        if (previous != null) {
            LOG.warn("[FFItems] Duplicate common item key '{}' detected; overwriting previous supplier", (Object)name);
        }
        return memoized;
    }

    private FFItems() {
    }
}

