/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.registry;

import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.z2six.featheredfriend.Constants;
import net.z2six.featheredfriend.registry.FFItems;
import org.slf4j.Logger;

public final class FFCreativeTabsNeoForge {
    private static final Logger LOG = Constants.LOG;

    private FFCreativeTabsNeoForge() {
    }

    public static void register(IEventBus modEventBus) {
        LOG.debug("FFCreativeTabsNeoForge: Registering BuildCreativeModeTabContentsEvent listener");
        modEventBus.addListener(FFCreativeTabsNeoForge::onBuildCreativeTabContents);
    }

    public static void onBuildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            LOG.debug("FFCreativeTabsNeoForge: Populating Ingredients tab with FeatheredFriend items");
            try {
                event.accept((ItemLike)FFItems.SCROLL_UNSEALED.get());
            }
            catch (Throwable t) {
                LOG.error("Failed to add SCROLL_UNSEALED to Ingredients tab", t);
            }
            try {
                event.accept((ItemLike)FFItems.SCROLL_SEALED.get());
            }
            catch (Throwable t) {
                LOG.error("Failed to add SCROLL_SEALED to Ingredients tab", t);
            }
            try {
                event.accept((ItemLike)FFItems.SCROLL_OPENED.get());
            }
            catch (Throwable t) {
                LOG.error("Failed to add SCROLL_OPENED to Ingredients tab", t);
            }
            try {
                event.accept((ItemLike)FFItems.SEAL_STAMP.get());
            }
            catch (Throwable t) {
                LOG.error("Failed to add SEAL_STAMP to Ingredients tab", t);
            }
        }
    }
}

