/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.network;

import com.mojang.logging.LogUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.z2six.featheredfriend.menu.ScrollAttachmentProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record WaxSealPacket(int selectedStampSlot, String dateText, String recipientName, String recipientUUID, String recipientText, String messageText, String signatureText, long seed, int slices, int style, String senderName) implements CustomPacketPayload
{
    private static final Logger LOG = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<WaxSealPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"wax_seal"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WaxSealPacket> STREAM_CODEC = StreamCodec.of(WaxSealPacket::encode, WaxSealPacket::decode);

    private static void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull WaxSealPacket p) {
        try {
            buf.writeVarInt(p.selectedStampSlot);
            buf.writeUtf(p.dateText, 256);
            buf.writeUtf(p.recipientName, 256);
            buf.writeUtf(p.recipientUUID, 256);
            buf.writeUtf(p.recipientText, 32768);
            buf.writeUtf(p.messageText, 32768);
            buf.writeUtf(p.signatureText, 32768);
            buf.writeLong(p.seed);
            buf.writeVarInt(p.slices);
            buf.writeVarInt(p.style);
            buf.writeUtf(p.senderName, 256);
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] encode failed", t);
        }
    }

    @NotNull
    private static WaxSealPacket decode(@NotNull RegistryFriendlyByteBuf buf) {
        try {
            int slot = buf.readVarInt();
            String dateText = buf.readUtf(256);
            String recName = buf.readUtf(256);
            String recUUID = buf.readUtf(256);
            String recText = buf.readUtf(32768);
            String msg = buf.readUtf(32768);
            String sig = buf.readUtf(32768);
            long sd = buf.readLong();
            int sl = buf.readVarInt();
            int st = buf.readVarInt();
            String sender = buf.readUtf(256);
            return new WaxSealPacket(slot, dateText, recName, recUUID, recText, msg, sig, sd, sl, st, sender);
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] decode failed", t);
            return new WaxSealPacket(-1, "", "", "", "", "", "", 0L, 0, 0, "");
        }
    }

    @NotNull
    public CustomPacketPayload.Type<WaxSealPacket> type() {
        return TYPE;
    }

    public static void handle(@NotNull WaxSealPacket p, @NotNull ServerPlayer serverPlayer) {
        try {
            CompoundTag seal;
            CompoundTag root;
            ItemStack sealed;
            block27: {
                ItemStack removed = WaxSealPacket.removeOneUnsealedScroll(serverPlayer);
                if (removed == null) {
                    LOG.warn("[WaxSealPacket] Player {} tried sealing but has no featheredfriend:scroll_unsealed", (Object)serverPlayer.getGameProfile().getName());
                    return;
                }
                Item sealedItem = WaxSealPacket.resolveItemByPath("scroll_sealed");
                if (sealedItem == null || sealedItem == Items.AIR) {
                    LOG.error("[WaxSealPacket] sealed scroll item featheredfriend:scroll_sealed not found; aborting");
                    return;
                }
                sealed = new ItemStack((ItemLike)sealedItem, 1);
                root = new CompoundTag();
                seal = new CompoundTag();
                seal.putString("DateText", WaxSealPacket.safeString(p.dateText(), 256));
                seal.putString("RecipientName", WaxSealPacket.safeString(p.recipientName(), 256));
                seal.putString("RecipientUUID", WaxSealPacket.safeString(p.recipientUUID(), 256));
                seal.putString("RecipientText", WaxSealPacket.safeString(p.recipientText(), 32760));
                seal.putString("MessageText", WaxSealPacket.safeString(p.messageText(), 32760));
                seal.putString("SignatureText", WaxSealPacket.safeString(p.signatureText(), 32760));
                seal.putString("SenderName", WaxSealPacket.safeString(p.senderName(), 256));
                seal.putLong("Seed", p.seed());
                seal.putInt("Slices", p.slices());
                seal.putInt("Style", p.style());
                try {
                    AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
                    if (abstractContainerMenu instanceof ScrollAttachmentProvider) {
                        ScrollAttachmentProvider provider = (ScrollAttachmentProvider)abstractContainerMenu;
                        int slotCount = provider.getAttachmentSlotCount();
                        ListTag attachmentsList = new ListTag();
                        int nonEmptyCount = 0;
                        for (int i = 0; i < slotCount; ++i) {
                            ItemStack stack = provider.getAttachmentStack(i);
                            if (stack == null || stack.isEmpty()) continue;
                            CompoundTag stackTag = new CompoundTag();
                            try {
                                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                                if (itemId == null) {
                                    LOG.warn("[WaxSealPacket] Attachment slot {} has item with null registry key; skipping", (Object)i);
                                    continue;
                                }
                                stackTag.putString("id", itemId.toString());
                                stackTag.putInt("Count", stack.getCount());
                                try {
                                    CompoundTag customDataTag;
                                    CustomData cd = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
                                    if (cd != null && (customDataTag = cd.copyTag()) != null && !customDataTag.isEmpty()) {
                                        stackTag.put("CustomData", (Tag)customDataTag);
                                    }
                                }
                                catch (Throwable tCd) {
                                    LOG.error("[WaxSealPacket] Failed to copy CustomData for attachment slot {}", (Object)i, (Object)tCd);
                                }
                                if (stackTag.isEmpty()) {
                                    LOG.warn("[WaxSealPacket] Attachment stackTag ended up empty for slot {}; skipping", (Object)i);
                                    continue;
                                }
                                attachmentsList.add((Object)stackTag);
                                ++nonEmptyCount;
                                LOG.debug("[WaxSealPacket] Captured attachment slot {} -> id='{}' Count={} hasCustomData={}", new Object[]{i, itemId, stack.getCount(), stackTag.contains("CustomData")});
                                try {
                                    provider.clearAttachmentSlot(i);
                                }
                                catch (Throwable tClear) {
                                    LOG.error("[WaxSealPacket] Failed to clear attachment slot {}", (Object)i, (Object)tClear);
                                }
                                continue;
                            }
                            catch (Throwable tSave) {
                                LOG.error("[WaxSealPacket] Failed to serialize attachment stack at index {}", (Object)i, (Object)tSave);
                            }
                        }
                        if (nonEmptyCount > 0) {
                            seal.put("Attachments", (Tag)attachmentsList);
                            try {
                                provider.setSuppressAttachmentRefundOnClose(true);
                            }
                            catch (Throwable tFlag) {
                                LOG.error("[WaxSealPacket] Failed to set suppressAttachmentRefundOnClose on provider {}", (Object)provider.getClass().getName(), (Object)tFlag);
                            }
                            LOG.info("[WaxSealPacket] Captured {} attachment stack(s) into sealed scroll for player {}", (Object)nonEmptyCount, (Object)serverPlayer.getGameProfile().getName());
                            break block27;
                        }
                        LOG.debug("[WaxSealPacket] No attachments found in ScrollAttachmentProvider for player {}", (Object)serverPlayer.getGameProfile().getName());
                        break block27;
                    }
                    LOG.debug("[WaxSealPacket] Player containerMenu is not a ScrollAttachmentProvider: {}", (Object)(serverPlayer.containerMenu != null ? serverPlayer.containerMenu.getClass().getName() : "null"));
                }
                catch (Throwable tAttach) {
                    LOG.error("[WaxSealPacket] Failed while capturing attachments into sealed scroll NBT", tAttach);
                }
            }
            root.put("SealedScroll", (Tag)seal);
            try {
                sealed.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
            }
            catch (Throwable tSet) {
                LOG.error("[WaxSealPacket] Failed to attach CustomData to sealed scroll", tSet);
            }
            boolean added = false;
            try {
                added = serverPlayer.getInventory().add(sealed);
            }
            catch (Throwable tAdd) {
                LOG.error("[WaxSealPacket] Error while adding sealed scroll to inventory", tAdd);
            }
            if (!added) {
                try {
                    serverPlayer.drop(sealed, false);
                }
                catch (Throwable tDrop) {
                    LOG.error("[WaxSealPacket] Failed to drop sealed scroll at player", tDrop);
                }
            }
            LOG.info("[WaxSealPacket] Delivered sealed scroll to {} (sender='{}' seed={} slices={} style={} date='{}')", new Object[]{serverPlayer.getGameProfile().getName(), p.senderName(), p.seed(), p.slices(), p.style(), p.dateText()});
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] handle failed", t);
        }
    }

    private static ItemStack removeOneUnsealedScroll(@NotNull ServerPlayer player) {
        try {
            Item unsealed = WaxSealPacket.resolveItemByPath("scroll_unsealed");
            if (unsealed == null || unsealed == Items.AIR) {
                LOG.error("[WaxSealPacket] Unsealed scroll item featheredfriend:scroll_unsealed not found in registry");
                return null;
            }
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack s = (ItemStack)player.getInventory().items.get(i);
                if (s.isEmpty() || s.getItem() != unsealed) continue;
                ItemStack taken = s.copyWithCount(1);
                try {
                    s.shrink(1);
                }
                catch (Throwable tShrink) {
                    LOG.error("[WaxSealPacket] Failed to shrink unsealed scroll stack at slot {}", (Object)i, (Object)tShrink);
                }
                return taken;
            }
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] removeOneUnsealedScroll failed", t);
        }
        return null;
    }

    private static Item resolveItemByPath(@NotNull String path) {
        try {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)path);
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null) {
                LOG.error("[WaxSealPacket] resolveItemByPath: item {} is null", (Object)id);
                return Items.AIR;
            }
            if (item == Items.AIR) {
                LOG.warn("[WaxSealPacket] resolveItemByPath: item {} returned as AIR", (Object)id);
            }
            return item;
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] resolveItemByPath failed for path='{}'", (Object)path, (Object)t);
            return Items.AIR;
        }
    }

    private static String safeString(String input, int maxLen) {
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLen) {
            return input;
        }
        try {
            return input.substring(0, Math.max(0, maxLen));
        }
        catch (Throwable t) {
            LOG.error("[WaxSealPacket] safeString substring failed (len={} maxLen={})", new Object[]{input.length(), maxLen, t});
            return "";
        }
    }
}

