/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.network;

import com.mojang.logging.LogUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record SealStampCarveResultPacket(int stampSlot, long seed, int slices, int style, String ownerName) implements CustomPacketPayload
{
    private static final Logger LOG = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<SealStampCarveResultPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"seal_stamp_carve_result"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SealStampCarveResultPacket> STREAM_CODEC = StreamCodec.of(SealStampCarveResultPacket::encode, SealStampCarveResultPacket::decode);

    private static void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull SealStampCarveResultPacket msg) {
        try {
            buf.writeInt(msg.stampSlot);
            buf.writeLong(msg.seed);
            buf.writeInt(msg.slices);
            buf.writeInt(msg.style);
            buf.writeUtf(msg.ownerName);
        }
        catch (Throwable t) {
            LOG.error("[SealStampCarveResultPacket] encode failed", t);
        }
    }

    @NotNull
    private static SealStampCarveResultPacket decode(@NotNull RegistryFriendlyByteBuf buf) {
        try {
            int slot = buf.readInt();
            long seed = buf.readLong();
            int slices = buf.readInt();
            int style = buf.readInt();
            String owner = buf.readUtf();
            return new SealStampCarveResultPacket(slot, seed, slices, style, owner);
        }
        catch (Throwable t) {
            LOG.error("[SealStampCarveResultPacket] decode failed, returning safe default", t);
            return new SealStampCarveResultPacket(-1, 0L, 0, 0, "");
        }
    }

    @NotNull
    public CustomPacketPayload.Type<SealStampCarveResultPacket> type() {
        return TYPE;
    }

    public static void handle(@NotNull SealStampCarveResultPacket msg, @NotNull ServerPlayer player) {
        try {
            if (msg.stampSlot() < 0) {
                LOG.error("[SealStampCarveResultPacket] Invalid stampSlot {}", (Object)msg.stampSlot());
                return;
            }
            ItemStack stack = msg.stampSlot() == 36 ? player.getMainHandItem() : (msg.stampSlot() == 37 ? player.getOffhandItem() : (msg.stampSlot() >= 0 && msg.stampSlot() < player.getInventory().items.size() ? (ItemStack)player.getInventory().items.get(msg.stampSlot()) : ItemStack.EMPTY));
            if (stack.isEmpty()) {
                LOG.error("[SealStampCarveResultPacket] No stack at slot {} for player {}", (Object)msg.stampSlot(), (Object)player.getGameProfile().getName());
                return;
            }
            CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag root = customData.copyTag();
            if (root == null) {
                root = new CompoundTag();
            }
            CompoundTag sealRoot = new CompoundTag();
            sealRoot.putString("Owner", msg.ownerName());
            sealRoot.putLong("Seed", msg.seed());
            sealRoot.putInt("Slices", msg.slices());
            sealRoot.putInt("ShapeSet", msg.style());
            root.put("SealStamp", (Tag)sealRoot);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
            LOG.info("[SealStampCarveResultPacket] Wrote seal data to slot {} for player {} (seed={} slices={} style={} owner='{}')", new Object[]{msg.stampSlot(), player.getGameProfile().getName(), msg.seed(), msg.slices(), msg.style(), msg.ownerName()});
        }
        catch (Throwable t) {
            LOG.error("[SealStampCarveResultPacket] handle failed", t);
        }
    }
}

