/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.network;

import com.mojang.logging.LogUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.z2six.featheredfriend.entity.raven.RavenEntity;
import net.z2six.featheredfriend.entity.raven.modules.TamedRaven;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record RavenNameChosenPacket(int ravenEntityId, String name) implements CustomPacketPayload
{
    private static final Logger LOG = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<RavenNameChosenPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"raven_name_chosen"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RavenNameChosenPacket> STREAM_CODEC = StreamCodec.of(RavenNameChosenPacket::encode, RavenNameChosenPacket::decode);

    private static void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull RavenNameChosenPacket payload) {
        try {
            buf.writeVarInt(payload.ravenEntityId());
            buf.writeUtf(payload.name() != null ? payload.name() : "", 64);
        }
        catch (Throwable t) {
            LOG.error("[RavenNameChosenPacket] encode failed", t);
        }
    }

    @NotNull
    private static RavenNameChosenPacket decode(@NotNull RegistryFriendlyByteBuf buf) {
        try {
            int id = buf.readVarInt();
            String name = buf.readUtf(64);
            return new RavenNameChosenPacket(id, name);
        }
        catch (Throwable t) {
            LOG.error("[RavenNameChosenPacket] decode failed", t);
            return new RavenNameChosenPacket(-1, "");
        }
    }

    @NotNull
    public CustomPacketPayload.Type<RavenNameChosenPacket> type() {
        return TYPE;
    }

    public static void handle(@NotNull RavenNameChosenPacket payload, @NotNull ServerPlayer serverPlayer) {
        try {
            if (serverPlayer == null) {
                return;
            }
            Level level = serverPlayer.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (payload.ravenEntityId() <= 0) {
                LOG.warn("[RavenNameChosenPacket] handle: invalid ravenEntityId={} from player={}", (Object)payload.ravenEntityId(), (Object)serverPlayer.getGameProfile().getName());
                return;
            }
            Entity e = serverLevel.getEntity(payload.ravenEntityId());
            if (!(e instanceof RavenEntity)) {
                LOG.warn("[RavenNameChosenPacket] handle: entityId={} is not a RavenEntity (player={})", (Object)payload.ravenEntityId(), (Object)serverPlayer.getGameProfile().getName());
                return;
            }
            RavenEntity raven = (RavenEntity)e;
            TamedRaven tamed = raven.getTamedRavenModule();
            if (tamed == null) {
                LOG.warn("[RavenNameChosenPacket] handle: raven id={} has no TamedRaven module (player={})", (Object)raven.getId(), (Object)serverPlayer.getGameProfile().getName());
                return;
            }
            tamed.onNameChosenFromClient(serverPlayer, payload.name());
        }
        catch (Throwable t) {
            LOG.error("[RavenNameChosenPacket] handle failed safely for player={}", (Object)serverPlayer.getGameProfile().getName(), (Object)t);
        }
    }
}

