/*
 * Decompiled with CFR 0.152.
 */
package net.z2six.featheredfriend.network;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.z2six.featheredfriend.world.FeatheredFriendSettingsData;
import org.slf4j.Logger;

public final class FFPayloads {
    private static final Logger LOG = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";

    private FFPayloads() {
    }

    public static void register(IEventBus modBus) {
        try {
            modBus.addListener(FFPayloads::onRegisterPayloadHandlers);
            LOG.info("[FFPayloads] Hooked RegisterPayloadHandlersEvent listener");
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] register() failed safely", t);
        }
    }

    private static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        try {
            PayloadRegistrar registrar = event.registrar("featheredfriend").versioned(PROTOCOL_VERSION);
            registrar.playToServer(RequestServerSettingsPayload.TYPE, RequestServerSettingsPayload.STREAM_CODEC, FFPayloads::handleRequestServerSettings);
            registrar.playToClient(ServerSettingsPayload.TYPE, ServerSettingsPayload.STREAM_CODEC, FFPayloads::handleServerSettingsSync);
            registrar.playToServer(SetChatDisabledPayload.TYPE, SetChatDisabledPayload.STREAM_CODEC, FFPayloads::handleSetChatDisabled);
            LOG.info("[FFPayloads] Registered settings payloads OK (protocol={})", (Object)PROTOCOL_VERSION);
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] onRegisterPayloadHandlers failed safely", t);
        }
    }

    public static void sendSettingsToPlayer(ServerLevel level, ServerPlayer player) {
        try {
            boolean canEditChatValue;
            if (level == null || player == null) {
                LOG.warn("[FFPayloads] sendSettingsToPlayer: null args; skipping");
                return;
            }
            FeatheredFriendSettingsData data = FeatheredFriendSettingsData.get(level);
            boolean chatDisabledValue = data.isChatDisabled();
            try {
                canEditChatValue = player.hasPermissions(4);
            }
            catch (Throwable ignored) {
                canEditChatValue = false;
            }
            ServerSettingsPayload msg = new ServerSettingsPayload(chatDisabledValue, canEditChatValue);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
            LOG.info("[FFPayloads] Sent settings to {}: chatDisabled={} canEditChat={}", new Object[]{player.getGameProfile().getName(), chatDisabledValue, canEditChatValue});
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] sendSettingsToPlayer failed safely", t);
        }
    }

    public static void broadcastSettings(ServerLevel level) {
        try {
            if (level == null || level.getServer() == null) {
                LOG.warn("[FFPayloads] broadcastSettings: null level/server; skipping");
                return;
            }
            List players = level.getServer().getPlayerList().getPlayers();
            for (ServerPlayer sp : players) {
                try {
                    FFPayloads.sendSettingsToPlayer(level, sp);
                }
                catch (Throwable t) {
                    LOG.warn("[FFPayloads] broadcastSettings: failed sending to {}: {}", (Object)sp.getGameProfile().getName(), (Object)t.toString());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] broadcastSettings failed safely", t);
        }
    }

    private static void handleRequestServerSettings(RequestServerSettingsPayload payload, IPayloadContext context) {
        try {
            context.enqueueWork(() -> {
                try {
                    Player patt0$temp = context.player();
                    if (!(patt0$temp instanceof ServerPlayer)) {
                        LOG.warn("[FFPayloads] RequestServerSettings from non-ServerPlayer; ignoring");
                        return;
                    }
                    ServerPlayer sp = (ServerPlayer)patt0$temp;
                    ServerLevel level = sp.serverLevel();
                    if (level == null) {
                        LOG.warn("[FFPayloads] RequestServerSettings: serverLevel null; ignoring");
                        return;
                    }
                    FFPayloads.sendSettingsToPlayer(level, sp);
                }
                catch (Throwable t) {
                    LOG.error("[FFPayloads] handleRequestServerSettings work failed safely", t);
                }
            });
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] handleRequestServerSettings failed safely", t);
        }
    }

    private static void handleServerSettingsSync(ServerSettingsPayload payload, IPayloadContext context) {
        try {
            context.enqueueWork(() -> {
                try {
                    ClientState.applyFromServer(payload.chatDisabled(), payload.canEditChat());
                }
                catch (Throwable t) {
                    LOG.error("[FFPayloads] handleServerSettingsSync work failed safely", t);
                }
            });
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] handleServerSettingsSync failed safely", t);
        }
    }

    private static void handleSetChatDisabled(SetChatDisabledPayload payload, IPayloadContext context) {
        try {
            context.enqueueWork(() -> {
                try {
                    boolean allowed;
                    Player patt0$temp = context.player();
                    if (!(patt0$temp instanceof ServerPlayer)) {
                        LOG.warn("[FFPayloads] SetChatDisabled from non-ServerPlayer; ignoring");
                        return;
                    }
                    ServerPlayer sp = (ServerPlayer)patt0$temp;
                    ServerLevel level = sp.serverLevel();
                    if (level == null) {
                        LOG.warn("[FFPayloads] SetChatDisabled: serverLevel null; ignoring");
                        return;
                    }
                    try {
                        allowed = sp.hasPermissions(4);
                    }
                    catch (Throwable ignored) {
                        allowed = false;
                    }
                    if (!allowed) {
                        LOG.warn("[FFPayloads] {} tried to SetChatDisabled without permission; denied", (Object)sp.getGameProfile().getName());
                        FFPayloads.sendSettingsToPlayer(level, sp);
                        return;
                    }
                    FeatheredFriendSettingsData data = FeatheredFriendSettingsData.get(level);
                    data.setChatDisabled(payload.chatDisabled());
                    LOG.info("[FFPayloads] {} set chatDisabled -> {}", (Object)sp.getGameProfile().getName(), (Object)payload.chatDisabled());
                    FFPayloads.broadcastSettings(level);
                }
                catch (Throwable t) {
                    LOG.error("[FFPayloads] handleSetChatDisabled work failed safely", t);
                }
            });
        }
        catch (Throwable t) {
            LOG.error("[FFPayloads] handleSetChatDisabled failed safely", t);
        }
    }

    public record RequestServerSettingsPayload() implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"request_server_settings_v1");
        public static final CustomPacketPayload.Type<RequestServerSettingsPayload> TYPE = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, RequestServerSettingsPayload> STREAM_CODEC = StreamCodec.unit((Object)new RequestServerSettingsPayload());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ServerSettingsPayload(boolean chatDisabled, boolean canEditChat) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"server_settings_v1");
        public static final CustomPacketPayload.Type<ServerSettingsPayload> TYPE = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, ServerSettingsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerSettingsPayload::chatDisabled, (StreamCodec)ByteBufCodecs.BOOL, ServerSettingsPayload::canEditChat, ServerSettingsPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetChatDisabledPayload(boolean chatDisabled) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"featheredfriend", (String)"set_chat_disabled_v1");
        public static final CustomPacketPayload.Type<SetChatDisabledPayload> TYPE = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SetChatDisabledPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SetChatDisabledPayload::chatDisabled, SetChatDisabledPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static final class ClientState {
        private static volatile boolean hasSynced = false;
        private static volatile boolean chatDisabled = true;
        private static volatile boolean canEditChat = false;

        private ClientState() {
        }

        public static boolean hasSynced() {
            return hasSynced;
        }

        public static boolean isChatDisabled() {
            return chatDisabled;
        }

        public static boolean canEditChat() {
            return canEditChat;
        }

        private static void applyFromServer(boolean newChatDisabled, boolean newCanEditChat) {
            chatDisabled = newChatDisabled;
            canEditChat = newCanEditChat;
            hasSynced = true;
            LOG.info("[FFPayloads.ClientState] Applied server settings: chatDisabled={} canEditChat={}", (Object)newChatDisabled, (Object)newCanEditChat);
        }

        public static void clear() {
            hasSynced = false;
            chatDisabled = true;
            canEditChat = false;
            LOG.info("[FFPayloads.ClientState] Cleared client cache");
        }
    }
}

